/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.auth.internal;

import com.floragunn.searchguard.auth.AuthenticationBackend;
import com.floragunn.searchguard.auth.AuthorizationBackend;
import com.floragunn.searchguard.sgconf.ConfigModel;
import com.floragunn.searchguard.sgconf.DynamicConfigFactory;
import com.floragunn.searchguard.sgconf.DynamicConfigModel;
import com.floragunn.searchguard.sgconf.InternalUsersModel;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.elasticsearch.ElasticsearchSecurityException;

public class InternalAuthenticationBackend
implements AuthenticationBackend,
AuthorizationBackend,
DynamicConfigFactory.DCFListener {
    private InternalUsersModel internalUsersModel;

    @Override
    public boolean exists(User user) {
        if (user == null || this.internalUsersModel == null) {
            return false;
        }
        boolean exists = this.internalUsersModel.exists(user.getName());
        if (exists) {
            List<String> searchGuardRoles;
            user.addRoles(this.internalUsersModel.getBackenRoles(user.getName()));
            Map<String, String> customAttributes = this.internalUsersModel.getAttributes(user.getName());
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            if (customAttributes != null) {
                for (Map.Entry<String, String> attributeEntry : customAttributes.entrySet()) {
                    attributeMap.put("attr.internal." + attributeEntry.getKey(), attributeEntry.getValue());
                }
            }
            if ((searchGuardRoles = this.internalUsersModel.getSearchGuardRoles(user.getName())) != null) {
                user.addSearchGuardRoles(searchGuardRoles);
            }
            user.addAttributes(attributeMap);
            return true;
        }
        return false;
    }

    @Override
    public User authenticate(AuthCredentials credentials) {
        if (this.internalUsersModel == null) {
            throw new ElasticsearchSecurityException("Internal authentication backend not configured. May be Search Guard is not initialized. See https://docs.search-guard.com/latest/sgadmin", new Object[0]);
        }
        if (!this.internalUsersModel.exists(credentials.getUsername())) {
            throw new ElasticsearchSecurityException(credentials.getUsername() + " not found", new Object[0]);
        }
        byte[] password = credentials.getPassword();
        if (password == null || password.length == 0) {
            throw new ElasticsearchSecurityException("empty passwords not supported", new Object[0]);
        }
        ByteBuffer wrap = ByteBuffer.wrap(password);
        CharBuffer buf = StandardCharsets.UTF_8.decode(wrap);
        char[] array = new char[buf.limit()];
        buf.get(array);
        Arrays.fill(password, (byte)0);
        try {
            if (OpenBSDBCrypt.checkPassword((String)this.internalUsersModel.getHash(credentials.getUsername()), (char[])array)) {
                List<String> roles = this.internalUsersModel.getBackenRoles(credentials.getUsername());
                Map<String, String> customAttributes = this.internalUsersModel.getAttributes(credentials.getUsername());
                if (customAttributes != null) {
                    for (Map.Entry<String, String> attributeName : customAttributes.entrySet()) {
                        credentials.addAttribute("attr.internal." + attributeName.getKey(), attributeName.getValue());
                    }
                }
                User user = new User(credentials.getUsername(), roles, credentials);
                List<String> searchGuardRoles = this.internalUsersModel.getSearchGuardRoles(credentials.getUsername());
                if (searchGuardRoles != null) {
                    user.addSearchGuardRoles(searchGuardRoles);
                }
                User user2 = user;
                return user2;
            }
            throw new ElasticsearchSecurityException("password does not match", new Object[0]);
        }
        finally {
            Arrays.fill(wrap.array(), (byte)0);
            Arrays.fill(buf.array(), '\u0000');
            Arrays.fill(array, '\u0000');
        }
    }

    @Override
    public String getType() {
        return "internal";
    }

    @Override
    public void fillRoles(User user, AuthCredentials credentials) throws ElasticsearchSecurityException {
        List<String> roles;
        if (this.internalUsersModel == null) {
            throw new ElasticsearchSecurityException("Internal authentication backend not configured. May be Search Guard is not initialized. See https://docs.search-guard.com/latest/sgadmin", new Object[0]);
        }
        if (this.exists(user) && (roles = this.internalUsersModel.getBackenRoles(user.getName())) != null && !roles.isEmpty() && user != null) {
            user.addRoles(roles);
        }
    }

    @Override
    public void onChanged(ConfigModel cf, DynamicConfigModel dcf, InternalUsersModel ium) {
        this.internalUsersModel = ium;
    }
}

