/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.compliance;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.LicenseChangeListener;
import com.floragunn.searchguard.configuration.SearchGuardLicense;
import com.floragunn.searchguard.resolver.IndexResolverReplacer;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ComplianceConfig
implements LicenseChangeListener {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Settings settings;
    private final Map<String, Set<String>> readEnabledFields = new HashMap<String, Set<String>>(100);
    private final List<String> watchedWriteIndices;
    private DateTimeFormatter auditLogPattern = null;
    private String auditLogIndex = null;
    private final boolean logDiffsForWrite;
    private final boolean logWriteMetadataOnly;
    private final boolean logReadMetadataOnly;
    private final boolean logExternalConfig;
    private final boolean logInternalConfig;
    private final LoadingCache<String, Set<String>> cache;
    private final Set<String> immutableIndicesPatterns;
    private final byte[] salt16;
    private final String searchguardIndex;
    private final IndexResolverReplacer irr;
    private final Environment environment;
    private final AuditLog auditLog;
    private volatile boolean enabled = true;
    private volatile boolean externalConfigLogged = false;

    public ComplianceConfig(Environment environment, IndexResolverReplacer irr, AuditLog auditLog) {
        this.settings = environment.settings();
        this.environment = environment;
        this.irr = irr;
        this.auditLog = auditLog;
        List watchedReadFields = this.settings.getAsList("searchguard.compliance.history.read.watched_fields", Collections.emptyList(), Boolean.valueOf(false));
        this.watchedWriteIndices = this.settings.getAsList("searchguard.compliance.history.write.watched_indices", Collections.emptyList());
        this.logDiffsForWrite = this.settings.getAsBoolean("searchguard.compliance.history.write.log_diffs", Boolean.valueOf(false));
        this.logWriteMetadataOnly = this.settings.getAsBoolean("searchguard.compliance.history.write.metadata_only", Boolean.valueOf(false));
        this.logReadMetadataOnly = this.settings.getAsBoolean("searchguard.compliance.history.read.metadata_only", Boolean.valueOf(false));
        this.logExternalConfig = this.settings.getAsBoolean("searchguard.compliance.history.external_config_enabled", Boolean.valueOf(false));
        this.logInternalConfig = this.settings.getAsBoolean("searchguard.compliance.history.internal_config_enabled", Boolean.valueOf(false));
        this.immutableIndicesPatterns = new HashSet<String>(this.settings.getAsList("searchguard.compliance.immutable_indices", Collections.emptyList()));
        String saltAsString = this.settings.get("searchguard.compliance.salt", "e1ukloTsQlOgPquJ");
        byte[] saltAsBytes = saltAsString.getBytes(StandardCharsets.UTF_8);
        if (saltAsString.equals("e1ukloTsQlOgPquJ")) {
            this.log.warn("If you plan to use field masking pls configure searchguard.compliance.salt to be a random string of 16 chars length identical on all nodes");
        }
        if (saltAsBytes.length < 16) {
            throw new ElasticsearchException("searchguard.compliance.salt must at least contain 16 bytes", new Object[0]);
        }
        if (saltAsBytes.length > 16) {
            this.log.warn("searchguard.compliance.salt is greater than 16 bytes. Only the first 16 bytes are used for salting");
        }
        this.salt16 = Arrays.copyOf(saltAsBytes, 16);
        this.searchguardIndex = this.settings.get("searchguard.config_index_name", "searchguard");
        for (String watchedReadField : watchedReadFields) {
            ArrayList<String> split = new ArrayList<String>(Arrays.asList(watchedReadField.split(",")));
            if (split.isEmpty()) continue;
            if (split.size() == 1) {
                this.readEnabledFields.put((String)split.get(0), Collections.singleton("*"));
                continue;
            }
            HashSet _fields = new HashSet(split.subList(1, split.size()));
            this.readEnabledFields.put((String)split.get(0), _fields);
        }
        String type = this.settings.get("searchguard.audit.type", null);
        if ("internal_elasticsearch".equalsIgnoreCase(type)) {
            String index = this.settings.get("searchguard.audit.config.index", "'sg6-auditlog-'YYYY.MM.dd");
            try {
                this.auditLogPattern = DateTimeFormat.forPattern((String)index);
            }
            catch (IllegalArgumentException e) {
                this.auditLogIndex = index;
            }
            catch (Exception e) {
                this.log.error("Unable to check if auditlog index {} is part of compliance setup", (Object)index, (Object)e);
            }
        }
        this.log.info("PII configuration [auditLogPattern={},  auditLogIndex={}]: {}", (Object)this.auditLogPattern, (Object)this.auditLogIndex, this.readEnabledFields);
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, Set<String>>(){

            public Set<String> load(String index) throws Exception {
                return ComplianceConfig.this.getFieldsForIndex0(index);
            }
        });
    }

    @Override
    public void onChange(SearchGuardLicense license) {
        this.enabled = license == null ? false : license.hasFeature(SearchGuardLicense.Feature.COMPLIANCE);
        this.log.info("Compliance features are " + (this.enabled ? "enabled" : "disabled. To enable them you need a special license. Please contact support for this."));
        if (this.enabled && this.logExternalConfig && !this.externalConfigLogged) {
            this.auditLog.logExternalConfig(this.settings, this.environment);
            this.externalConfigLogged = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private Set<String> getFieldsForIndex0(String index) {
        if (index == null) {
            return Collections.EMPTY_SET;
        }
        if (this.auditLogIndex != null && this.auditLogIndex.equalsIgnoreCase(index)) {
            return Collections.EMPTY_SET;
        }
        if (this.auditLogPattern != null && index.equalsIgnoreCase(this.getExpandedIndexName(this.auditLogPattern, null))) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> tmp = new HashSet<String>(100);
        for (String indexPattern : this.readEnabledFields.keySet()) {
            if (indexPattern == null || indexPattern.isEmpty() || !WildcardMatcher.match(indexPattern, index)) continue;
            tmp.addAll((Collection<String>)this.readEnabledFields.get(indexPattern));
        }
        return tmp;
    }

    private String getExpandedIndexName(DateTimeFormatter indexPattern, String index) {
        if (indexPattern == null) {
            return index;
        }
        return indexPattern.print((ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC));
    }

    public boolean writeHistoryEnabledForIndex(String index) {
        if (index == null) {
            return false;
        }
        if (this.searchguardIndex.equals(index)) {
            return this.logInternalConfig;
        }
        if (this.auditLogIndex != null && this.auditLogIndex.equalsIgnoreCase(index)) {
            return false;
        }
        if (this.auditLogPattern != null && index.equalsIgnoreCase(this.getExpandedIndexName(this.auditLogPattern, null))) {
            return false;
        }
        return WildcardMatcher.matchAny(this.watchedWriteIndices, index);
    }

    public boolean readHistoryEnabledForIndex(String index) {
        if (!this.enabled) {
            return false;
        }
        if (this.searchguardIndex.equals(index)) {
            return this.logInternalConfig;
        }
        try {
            return !((Set)this.cache.get((Object)index)).isEmpty();
        }
        catch (ExecutionException e) {
            this.log.error((Object)e);
            return true;
        }
    }

    public boolean readHistoryEnabledForField(String index, String field) {
        if (!this.enabled) {
            return false;
        }
        if (this.searchguardIndex.equals(index)) {
            return this.logInternalConfig;
        }
        try {
            Set fields = (Set)this.cache.get((Object)index);
            if (fields.isEmpty()) {
                return false;
            }
            return WildcardMatcher.matchAny((Collection<String>)fields, field);
        }
        catch (ExecutionException e) {
            this.log.error((Object)e);
            return true;
        }
    }

    public boolean logDiffsForWrite() {
        return !this.logWriteMetadataOnly() && this.logDiffsForWrite;
    }

    public boolean logWriteMetadataOnly() {
        return this.logWriteMetadataOnly;
    }

    public boolean logReadMetadataOnly() {
        return this.logReadMetadataOnly;
    }

    public boolean isIndexImmutable(Object request) {
        if (!this.enabled) {
            return false;
        }
        if (this.immutableIndicesPatterns.isEmpty()) {
            return false;
        }
        IndexResolverReplacer.Resolved resolved = this.irr.resolveRequest(request);
        Set<String> allIndices = resolved.getAllIndices();
        return WildcardMatcher.matchAny(this.immutableIndicesPatterns, allIndices);
    }

    public byte[] getSalt16() {
        return (byte[])this.salt16.clone();
    }
}

