/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;

public class ClusterInfoHolder
implements ClusterStateListener {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile Boolean has6xNodes = null;
    private volatile Boolean has6xIndices = null;
    private volatile DiscoveryNodes nodes = null;
    private volatile Boolean isLocalNodeElectedMaster = null;
    private volatile boolean initialized;

    public void clusterChanged(ClusterChangedEvent event) {
        if (this.has6xNodes == null || event.nodesChanged()) {
            this.has6xNodes = ClusterInfoHolder.clusterHas6xNodes(event.state());
            if (this.log.isTraceEnabled()) {
                this.log.trace("has6xNodes: {}", (Object)this.has6xNodes);
            }
        }
        List indicesCreated = event.indicesCreated();
        List indicesDeleted = event.indicesDeleted();
        if (this.has6xIndices == null || !indicesCreated.isEmpty() || !indicesDeleted.isEmpty()) {
            this.has6xIndices = ClusterInfoHolder.clusterHas6xIndices(event.state());
            if (this.log.isTraceEnabled()) {
                this.log.trace("has6xIndices: {}", (Object)this.has6xIndices);
            }
        }
        if (this.nodes == null || event.nodesChanged()) {
            this.nodes = event.state().nodes();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder now initialized for 'nodes'");
            }
            this.initialized = true;
        }
        this.isLocalNodeElectedMaster = event.localNodeMaster() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getHas6xNodes() {
        return this.has6xNodes;
    }

    public Boolean getHas6xIndices() {
        return this.has6xIndices;
    }

    public Boolean isLocalNodeElectedMaster() {
        return this.isLocalNodeElectedMaster;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Boolean hasNode(DiscoveryNode node) {
        if (this.nodes == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder not initialized yet for 'nodes'");
            }
            return null;
        }
        return this.nodes.nodeExists(node) ? Boolean.TRUE : Boolean.FALSE;
    }

    private static boolean clusterHas6xNodes(ClusterState state) {
        return state.nodes().getMinNodeVersion().before(Version.V_7_0_0);
    }

    private static boolean clusterHas6xIndices(ClusterState state) {
        Iterator indices = state.metaData().indices().valuesIt();
        while (indices.hasNext()) {
            IndexMetaData indexMetaData = (IndexMetaData)indices.next();
            if (!indexMetaData.getCreationVersion().before(Version.V_7_0_0)) continue;
            return true;
        }
        return false;
    }
}

