/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.sgconf.ConfigModel;
import com.floragunn.searchguard.sgconf.DynamicConfigFactory;
import com.floragunn.searchguard.sgconf.DynamicConfigModel;
import com.floragunn.searchguard.sgconf.InternalUsersModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public class CompatConfig
implements DynamicConfigFactory.DCFListener {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Settings staticSettings;
    private DynamicConfigModel dcm;

    public CompatConfig(Environment environment) {
        this.staticSettings = environment.settings();
    }

    @Override
    public void onChanged(ConfigModel cm, DynamicConfigModel dcm, InternalUsersModel ium) {
        this.dcm = dcm;
        this.log.debug("dynamicSgConfig updated?: {}", (Object)(dcm != null ? 1 : 0));
    }

    public boolean restAuthEnabled() {
        boolean restInitiallyDisabled = this.staticSettings.getAsBoolean("searchguard.unsupported.disable_rest_auth_initially", Boolean.valueOf(false));
        if (restInitiallyDisabled) {
            if (this.dcm == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("dynamicSgConfig is null, initially static restDisabled");
                }
                return false;
            }
            boolean restDynamicallyDisabled = this.dcm.isRestAuthDisabled();
            if (this.log.isTraceEnabled()) {
                this.log.trace("searchguard.dynamic.disable_rest_auth {}", (Object)restDynamicallyDisabled);
            }
            return !restDynamicallyDisabled;
        }
        return true;
    }

    public boolean transportInterClusterAuthEnabled() {
        boolean interClusterAuthInitiallyDisabled = this.staticSettings.getAsBoolean("searchguard.unsupported.disable_intertransport_auth_initially", Boolean.valueOf(false));
        if (interClusterAuthInitiallyDisabled) {
            if (this.dcm == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("dynamicSgConfig is null, initially static interClusterAuthDisabled");
                }
                return false;
            }
            boolean interClusterAuthDynamicallyDisabled = this.dcm.isInterTransportAuthDisabled();
            if (this.log.isTraceEnabled()) {
                this.log.trace("searchguard.dynamic.disable_intertransport_auth {}", (Object)interClusterAuthDynamicallyDisabled);
            }
            return !interClusterAuthDynamicallyDisabled;
        }
        return true;
    }
}

