/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.compliance.ComplianceConfig;
import com.floragunn.searchguard.configuration.ConfigUpdateAlreadyInProgressException;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationLoaderSG7;
import com.floragunn.searchguard.configuration.InvalidConfigException;
import com.floragunn.searchguard.configuration.LicenseChangeListener;
import com.floragunn.searchguard.configuration.SearchGuardLicense;
import com.floragunn.searchguard.sgconf.DynamicConfigFactory;
import com.floragunn.searchguard.sgconf.impl.CType;
import com.floragunn.searchguard.sgconf.impl.SgDynamicConfiguration;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.support.ConfigHelper;
import com.floragunn.searchguard.support.LicenseHelper;
import com.floragunn.searchguard.support.SgUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.threadpool.ThreadPool;

public class ConfigurationRepository {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationRepository.class);
    private final String searchguardIndex;
    private final Client client;
    private final Cache<CType, SgDynamicConfiguration<?>> configCache;
    private final List<ConfigurationChangeListener> configurationChangedListener;
    private final List<LicenseChangeListener> licenseChangeListener;
    private final ConfigurationLoaderSG7 cl;
    private final Settings settings;
    private final ClusterService clusterService;
    private final AuditLog auditLog;
    private final ComplianceConfig complianceConfig;
    private final ThreadPool threadPool;
    private volatile SearchGuardLicense effectiveLicense;
    private DynamicConfigFactory dynamicConfigFactory;
    private final int configVersion = 2;
    private final Thread bgThread;
    private final AtomicBoolean installDefaultConfig = new AtomicBoolean();
    private final Lock LOCK = new ReentrantLock();

    private ConfigurationRepository(final Settings settings, final Path configPath, final ThreadPool threadPool, final Client client, final ClusterService clusterService, AuditLog auditLog, ComplianceConfig complianceConfig) {
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.settings = settings;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.auditLog = auditLog;
        this.complianceConfig = complianceConfig;
        this.configurationChangedListener = new ArrayList<ConfigurationChangeListener>();
        this.licenseChangeListener = new ArrayList<LicenseChangeListener>();
        this.cl = new ConfigurationLoaderSG7(client, threadPool, settings, clusterService);
        this.configCache = CacheBuilder.newBuilder().build();
        this.bgThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    block26: {
                        LOGGER.info("Background init thread started. Install default config?: " + ConfigurationRepository.this.installDefaultConfig.get());
                        if (ConfigurationRepository.this.installDefaultConfig.get()) {
                            try {
                                String lookupDir = System.getProperty("sg.default_init.dir");
                                String cd = lookupDir != null ? lookupDir + "/" : new Environment(settings, configPath).pluginsFile().toAbsolutePath().toString() + "/search-guard-7/sgconfig/";
                                File confFile = new File(cd + "sg_config.yml");
                                if (confFile.exists()) {
                                    ThreadContext threadContext = threadPool.getThreadContext();
                                    try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
                                        threadContext.putHeader("_sg_conf_request", "true");
                                        LOGGER.info("Will create {} index so we can apply default config", (Object)ConfigurationRepository.this.searchguardIndex);
                                        HashMap<String, Object> indexSettings = new HashMap<String, Object>();
                                        indexSettings.put("index.number_of_shards", 1);
                                        indexSettings.put("index.auto_expand_replicas", "0-all");
                                        boolean ok = ((CreateIndexResponse)client.admin().indices().create(new CreateIndexRequest(ConfigurationRepository.this.searchguardIndex).settings(indexSettings)).actionGet()).isAcknowledged();
                                        LOGGER.info("Index {} created?: {}", (Object)ConfigurationRepository.this.searchguardIndex, (Object)ok);
                                        if (ok) {
                                            ConfigHelper.uploadFile(client, cd + "sg_config.yml", ConfigurationRepository.this.searchguardIndex, CType.CONFIG, 2);
                                            ConfigHelper.uploadFile(client, cd + "sg_roles.yml", ConfigurationRepository.this.searchguardIndex, CType.ROLES, 2);
                                            ConfigHelper.uploadFile(client, cd + "sg_roles_mapping.yml", ConfigurationRepository.this.searchguardIndex, CType.ROLESMAPPING, 2);
                                            ConfigHelper.uploadFile(client, cd + "sg_internal_users.yml", ConfigurationRepository.this.searchguardIndex, CType.INTERNALUSERS, 2);
                                            ConfigHelper.uploadFile(client, cd + "sg_action_groups.yml", ConfigurationRepository.this.searchguardIndex, CType.ACTIONGROUPS, 2);
                                            ConfigHelper.uploadFile(client, cd + "sg_tenants.yml", ConfigurationRepository.this.searchguardIndex, CType.TENANTS, 2);
                                            LOGGER.info("Default config applied");
                                        } else {
                                            LOGGER.error("Can not create {} index", (Object)ConfigurationRepository.this.searchguardIndex);
                                        }
                                        break block26;
                                    }
                                }
                                LOGGER.error("{} does not exist", (Object)confFile.getAbsolutePath());
                            }
                            catch (Exception e) {
                                LOGGER.debug("Cannot apply default config (this is maybe not an error!) due to {}", (Object)e.getMessage());
                            }
                        }
                    }
                    LOGGER.debug("Node started, try to initialize it. Wait for at least yellow cluster state....");
                    ClusterHealthResponse response = null;
                    try {
                        response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{ConfigurationRepository.this.searchguardIndex}).waitForActiveShards(1).waitForYellowStatus()).actionGet();
                    }
                    catch (Exception e1) {
                        LOGGER.debug("Catched a {} but we just try again ...", (Object)e1.toString());
                    }
                    while (response == null || response.isTimedOut() || response.getStatus() == ClusterHealthStatus.RED) {
                        LOGGER.debug("index '{}' not healthy yet, we try again ... (Reason: {})", (Object)ConfigurationRepository.this.searchguardIndex, (Object)(response == null ? "no response" : (response.isTimedOut() ? "timeout" : "other, maybe red cluster")));
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                        }
                        try {
                            response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{ConfigurationRepository.this.searchguardIndex}).waitForYellowStatus()).actionGet();
                        }
                        catch (Exception e1) {
                            LOGGER.debug("Catched again a {} but we just try again ...", (Object)e1.toString());
                        }
                    }
                    while (!ConfigurationRepository.this.dynamicConfigFactory.isInitialized()) {
                        try {
                            LOGGER.debug("Try to load config ...");
                            ConfigurationRepository.this.reloadConfiguration(Arrays.asList(CType.values()));
                        }
                        catch (Exception e) {
                            LOGGER.debug("Unable to load configuration due to {}", (Object)String.valueOf(ExceptionUtils.getRootCause(e)));
                            try {
                                Thread.sleep(3000L);
                                continue;
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                                LOGGER.debug("Thread was interrupted so we cancel initialization");
                            }
                        }
                        break;
                    }
                    LOGGER.info("Node '{}' initialized", (Object)clusterService.localNode().getName());
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected exception while initializing node " + e, (Throwable)e);
                }
            }
        });
    }

    public void initOnNodeStart() {
        LOGGER.info("Check if " + this.searchguardIndex + " index exists ...");
        try {
            if (this.clusterService.state().metaData().hasConcreteIndex(this.searchguardIndex)) {
                LOGGER.info("{} index does already exist, so we try to load the config from it", (Object)this.searchguardIndex);
                this.bgThread.start();
            } else if (this.settings.getAsBoolean("searchguard.allow_default_init_sgindex", Boolean.valueOf(false)).booleanValue()) {
                LOGGER.info("{} index does not exist yet, so we create a default config", (Object)this.searchguardIndex);
                this.installDefaultConfig.set(true);
                this.bgThread.start();
            } else if (this.settings.getAsBoolean("searchguard.background_init_if_sgindex_not_exist", Boolean.valueOf(true)).booleanValue()) {
                LOGGER.info("{} index does not exist yet, so no need to load config on node startup. Use sgadmin to initialize cluster", (Object)this.searchguardIndex);
                this.bgThread.start();
            } else {
                LOGGER.info("{} index does not exist yet, use sgadmin to initialize the cluster. We will not perform background initialization", (Object)this.searchguardIndex);
            }
        }
        catch (Throwable e2) {
            LOGGER.error("Error during node initialization: {}", (Object)e2, (Object)e2);
            this.bgThread.start();
        }
    }

    public static ConfigurationRepository create(Settings settings, Path configPath, ThreadPool threadPool, Client client, ClusterService clusterService, AuditLog auditLog, ComplianceConfig complianceConfig) {
        ConfigurationRepository repository = new ConfigurationRepository(settings, configPath, threadPool, client, clusterService, auditLog, complianceConfig);
        return repository;
    }

    public void setDynamicConfigFactory(DynamicConfigFactory dynamicConfigFactory) {
        this.dynamicConfigFactory = dynamicConfigFactory;
    }

    public SgDynamicConfiguration<?> getConfiguration(CType configurationType) {
        SgDynamicConfiguration conf = (SgDynamicConfiguration)this.configCache.getIfPresent((Object)configurationType);
        if (conf != null) {
            return conf.deepClone();
        }
        return SgDynamicConfiguration.empty();
    }

    public void reloadConfiguration(Collection<CType> configTypes) throws ConfigUpdateAlreadyInProgressException {
        block6: {
            try {
                if (this.LOCK.tryLock(60L, TimeUnit.SECONDS)) {
                    try {
                        this.reloadConfiguration0(configTypes);
                        break block6;
                    }
                    finally {
                        this.LOCK.unlock();
                    }
                }
                throw new ConfigUpdateAlreadyInProgressException("A config update is already imn progress", new Object[0]);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ConfigUpdateAlreadyInProgressException("Interrupted config update", new Object[0]);
            }
        }
    }

    private void reloadConfiguration0(Collection<CType> configTypes) {
        Map<CType, SgDynamicConfiguration<?>> loaded = this.getConfigurationsFromIndex(configTypes, false);
        this.configCache.putAll(loaded);
        this.notifyAboutChanges(loaded);
        SearchGuardLicense sgLicense = this.getLicense();
        this.notifyAboutLicenseChanges(sgLicense);
        String license = sgLicense == null ? "No license needed because enterprise modules are not enabled" : sgLicense.toString();
        LOGGER.info("Search Guard License Info: " + license);
        if (sgLicense != null) {
            LOGGER.info("Search Guard License Type: " + (Object)((Object)sgLicense.getType()) + ", " + (sgLicense.isValid() ? "valid" : "invalid"));
            if (sgLicense.getExpiresInDays() <= 30L && sgLicense.isValid()) {
                LOGGER.warn("Your Search Guard license expires in " + sgLicense.getExpiresInDays() + " days.");
                System.out.println("Your Search Guard license expires in " + sgLicense.getExpiresInDays() + " days.");
            }
            if (!sgLicense.isValid()) {
                String reasons = String.join((CharSequence)"; ", sgLicense.getMsgs());
                LOGGER.error("You are running an unlicensed version of Search Guard. Reason(s): " + reasons);
                System.out.println("You are running an unlicensed version of Search Guard. Reason(s): " + reasons);
                System.err.println("You are running an unlicensed version of Search Guard. Reason(s): " + reasons);
            }
        }
    }

    public synchronized void subscribeOnChange(ConfigurationChangeListener listener) {
        this.configurationChangedListener.add(listener);
    }

    public synchronized void subscribeOnLicenseChange(LicenseChangeListener licenseChangeListener) {
        if (licenseChangeListener != null) {
            this.licenseChangeListener.add(licenseChangeListener);
        }
    }

    private synchronized void notifyAboutLicenseChanges(SearchGuardLicense license) {
        for (LicenseChangeListener listener : this.licenseChangeListener) {
            listener.onChange(license);
        }
    }

    private synchronized void notifyAboutChanges(Map<CType, SgDynamicConfiguration<?>> typeToConfig) {
        for (ConfigurationChangeListener listener : this.configurationChangedListener) {
            try {
                LOGGER.debug("Notify {} listener about change configuration with type {}", (Object)listener);
                listener.onChange(typeToConfig);
            }
            catch (Exception e) {
                LOGGER.error("{} listener errored: " + e, (Object)listener, (Object)e);
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }
    }

    public Map<CType, SgDynamicConfiguration<?>> getConfigurationsFromIndex(Collection<CType> configTypes, boolean logComplianceEvent) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        HashMap retVal = new HashMap();
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            MappingMetaData mappingMetaData;
            threadContext.putHeader("_sg_conf_request", "true");
            IndexMetaData searchGuardMetaData = this.clusterService.state().metaData().index(this.searchguardIndex);
            MappingMetaData mappingMetaData2 = mappingMetaData = searchGuardMetaData == null ? null : searchGuardMetaData.mapping();
            if (searchGuardMetaData != null && mappingMetaData != null) {
                if ("sg".equals(mappingMetaData.type())) {
                    LOGGER.debug("sg index exists and was created before ES 7 (legacy layout)");
                } else {
                    LOGGER.debug("sg index exists and was created with ES 7 (new layout)");
                }
                retVal.putAll(this.validate(this.cl.load(configTypes.toArray(new CType[0]), 5L, TimeUnit.SECONDS), configTypes.size()));
            } else {
                LOGGER.debug("sg index not exists (yet)");
                retVal.putAll(this.validate(this.cl.load(configTypes.toArray(new CType[0]), 5L, TimeUnit.SECONDS), configTypes.size()));
            }
        }
        catch (Exception e) {
            throw new ElasticsearchException((Throwable)e);
        }
        if (logComplianceEvent && this.complianceConfig.isEnabled()) {
            CType configurationType = configTypes.iterator().next();
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put(configurationType.toLCString(), Strings.toString((ToXContent)((ToXContent)retVal.get((Object)configurationType))));
            this.auditLog.logDocumentRead(this.searchguardIndex, configurationType.toLCString(), null, fields, this.complianceConfig);
        }
        return retVal;
    }

    private Map<CType, SgDynamicConfiguration<?>> validate(Map<CType, SgDynamicConfiguration<?>> conf, int expectedSize) throws InvalidConfigException {
        if (conf == null || conf.size() != expectedSize) {
            throw new InvalidConfigException("Retrieved only partial configuration");
        }
        return conf;
    }

    private static String formatDate(long date) {
        return new SimpleDateFormat("yyyy-MM-dd", SgUtils.EN_Locale).format(new Date(date));
    }

    public SearchGuardLicense getLicense() {
        boolean enterpriseModulesEnabled = this.settings.getAsBoolean("searchguard.enterprise_modules_enabled", Boolean.valueOf(true));
        if (!enterpriseModulesEnabled) {
            return null;
        }
        String licenseText = this.dynamicConfigFactory.getLicenseString();
        if (licenseText == null || licenseText.isEmpty()) {
            if (this.effectiveLicense != null) {
                return this.effectiveLicense;
            }
            return this.createOrGetTrial(null);
        }
        try {
            SearchGuardLicense retVal;
            licenseText = LicenseHelper.validateLicense(licenseText);
            this.effectiveLicense = retVal = new SearchGuardLicense(XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (String)licenseText, (boolean)true), this.clusterService);
            return retVal;
        }
        catch (Exception e) {
            LOGGER.error("Unable to verify license", (Throwable)e);
            if (this.effectiveLicense != null) {
                return this.effectiveLicense;
            }
            return this.createOrGetTrial("Unable to verify license due to " + ExceptionUtils.getRootCause(e));
        }
    }

    private SearchGuardLicense createOrGetTrial(String msg) {
        IndexMetaData sgIndexMetaData = this.clusterService.state().metaData().index(this.searchguardIndex);
        if (sgIndexMetaData == null) {
            LOGGER.error("Unable to retrieve trial license (or create  a new one) because {} index does not exist", (Object)this.searchguardIndex);
            throw new RuntimeException(this.searchguardIndex + " does not exist");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create or retrieve trial license from {} created with version {} and mapping type: {}", (Object)this.searchguardIndex, (Object)sgIndexMetaData.getCreationVersion(), (Object)sgIndexMetaData.mapping().type());
        }
        String type = "_doc";
        if (sgIndexMetaData.mapping().type().equals("sg")) {
            type = "sg";
        }
        long created = System.currentTimeMillis();
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            threadContext.putHeader("_sg_conf_request", "true");
            GetResponse get = (GetResponse)this.client.prepareGet(this.searchguardIndex, type, "tattr").get();
            if (get.isExists()) {
                created = (Long)get.getSource().get("val");
            } else {
                try {
                    this.client.index(((IndexRequest)new IndexRequest(this.searchguardIndex).type(type).id("tattr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).create(true).source("{\"val\": " + System.currentTimeMillis() + "}", XContentType.JSON)).actionGet();
                }
                catch (VersionConflictEngineException versionConflictEngineException) {
                }
                catch (Exception e) {
                    LOGGER.error("Unable to index tattr", (Throwable)e);
                }
            }
        }
        return SearchGuardLicense.createTrialLicense(ConfigurationRepository.formatDate(created), this.clusterService, msg);
    }
}

