/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.EmptyFilterLeafReader;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;

public class SearchGuardIndexSearcherWrapper
implements CheckedFunction<DirectoryReader, DirectoryReader, IOException> {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final ThreadContext threadContext;
    protected final Index index;
    protected final String searchguardIndex;
    private final AdminDNs adminDns;

    public SearchGuardIndexSearcherWrapper(IndexService indexService, Settings settings, AdminDNs adminDNs) {
        this.index = indexService.index();
        this.threadContext = indexService.getThreadPool().getThreadContext();
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.adminDns = adminDNs;
    }

    public final DirectoryReader apply(DirectoryReader reader) throws IOException {
        if (this.isSearchGuardIndexRequest() && !this.isAdminAuthenticatedOrInternalRequest()) {
            return new EmptyFilterLeafReader.EmptyDirectoryReader(reader);
        }
        return this.dlsFlsWrap(reader, this.isAdminAuthenticatedOrInternalRequest());
    }

    protected DirectoryReader dlsFlsWrap(DirectoryReader reader, boolean isAdmin) throws IOException {
        return reader;
    }

    protected final boolean isAdminAuthenticatedOrInternalRequest() {
        User user = (User)this.threadContext.getTransient("_sg_user");
        if (user != null && this.adminDns.isAdmin(user)) {
            return true;
        }
        return "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_sg_conf_request"));
    }

    protected final boolean isSearchGuardIndexRequest() {
        return this.index.getName().equals(this.searchguardIndex);
    }
}

