/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.support.SgUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class SearchGuardLicense
implements Writeable {
    private static final DateTimeFormatter DEFAULT_FOMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(SgUtils.EN_Locale);
    private String uid;
    private Type type;
    private Feature[] features;
    private String issueDate;
    private String expiryDate;
    private String issuedTo;
    private String issuer;
    private String startDate;
    private Integer majorVersion;
    private String clusterName;
    private int allowedNodeCount;
    private final List<String> msgs = new ArrayList<String>();
    private long expiresInDays = 0L;
    private boolean isExpired = true;
    private boolean valid = true;
    private String action;
    private String prodUsage;
    private final ClusterService clusterService;

    public static SearchGuardLicense createTrialLicense(String issueDate, ClusterService clusterService, String msg) {
        SearchGuardLicense trialLicense = new SearchGuardLicense("00000000-0000-0000-0000-000000000000", Type.TRIAL, Feature.values(), issueDate, SearchGuardLicense.addDays(issueDate, 60), "The world", "floragunn GmbH", issueDate, 7, "*", Integer.MAX_VALUE, clusterService);
        if (msg != null) {
            trialLicense.msgs.add(msg);
        }
        return trialLicense;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uid);
        out.writeEnum((Enum)this.type);
        out.writeString(this.issueDate);
        out.writeString(this.expiryDate);
        out.writeString(this.issuedTo);
        out.writeString(this.issuer);
        out.writeString(this.startDate);
        out.writeOptionalVInt(this.majorVersion);
        out.writeString(this.clusterName);
        out.writeInt(this.allowedNodeCount);
        out.writeStringCollection(this.msgs);
        out.writeLong(this.expiresInDays);
        out.writeBoolean(this.isExpired);
        out.writeBoolean(this.valid);
        out.writeString(this.action);
        out.writeString(this.prodUsage);
        out.writeArray(StreamOutput::writeEnum, (Object[])(this.features == null ? new Feature[]{} : this.features));
    }

    public SearchGuardLicense(StreamInput in) throws IOException {
        this.uid = in.readString();
        this.type = (Type)in.readEnum(Type.class);
        this.issueDate = in.readString();
        this.expiryDate = in.readString();
        this.issuedTo = in.readString();
        this.issuer = in.readString();
        this.startDate = in.readString();
        this.majorVersion = in.readOptionalVInt();
        this.clusterName = in.readString();
        this.allowedNodeCount = in.readInt();
        this.msgs.addAll(in.readList(StreamInput::readString));
        this.expiresInDays = in.readLong();
        this.isExpired = in.readBoolean();
        this.valid = in.readBoolean();
        this.action = in.readString();
        this.prodUsage = in.readString();
        this.features = (Feature[])in.readArray((Writeable.Reader)new Writeable.Reader<Feature>(){

            public Feature read(StreamInput in) throws IOException {
                return (Feature)in.readEnum(Feature.class);
            }
        }, Feature[]::new);
        this.clusterService = null;
    }

    public SearchGuardLicense(Map<String, Object> map, ClusterService clusterService) {
        this((String)(map == null ? null : map.get("uid")), map == null ? null : Type.valueOf(((String)map.get("type")).toUpperCase()), map == null ? null : SearchGuardLicense.parseFeatures((List)map.get("features")), (String)(map == null ? null : map.get("issued_date")), (String)(map == null ? null : map.get("expiry_date")), (String)(map == null ? null : map.get("issued_to")), (String)(map == null ? null : map.get("issuer")), (String)(map == null ? null : map.get("start_date")), (Integer)(map == null ? null : map.get("major_version")), (String)(map == null ? null : map.get("cluster_name")), (Integer)(map == null ? Integer.valueOf(0) : map.get("allowed_node_count_per_cluster")), clusterService);
    }

    private static final Feature[] parseFeatures(List<String> featuresAsString) {
        if (featuresAsString == null || featuresAsString.isEmpty()) {
            return new Feature[0];
        }
        ArrayList<Feature> retVal = new ArrayList<Feature>();
        for (String feature : featuresAsString) {
            if (feature == null || feature.isEmpty()) continue;
            try {
                retVal.add(Feature.valueOf(feature.toUpperCase()));
            }
            catch (Exception exception) {}
        }
        return retVal.toArray(new Feature[0]);
    }

    public SearchGuardLicense(String uid, Type type, Feature[] features, String issueDate, String expiryDate, String issuedTo, String issuer, String startDate, Integer majorVersion, String clusterName, int allowedNodeCount, ClusterService clusterService) {
        this.uid = Objects.requireNonNull(uid);
        this.type = Objects.requireNonNull(type);
        this.features = features == null ? new Feature[]{} : (Feature[])features.clone();
        this.issueDate = Objects.requireNonNull(issueDate);
        this.expiryDate = Objects.requireNonNull(expiryDate);
        this.issuedTo = Objects.requireNonNull(issuedTo);
        this.issuer = Objects.requireNonNull(issuer);
        this.startDate = Objects.requireNonNull(startDate);
        this.majorVersion = Objects.requireNonNull(majorVersion);
        this.clusterName = Objects.requireNonNull(clusterName);
        this.allowedNodeCount = allowedNodeCount;
        this.clusterService = Objects.requireNonNull(clusterService);
        this.validate();
    }

    private void validate() {
        String nodes;
        int numberOfNodes;
        LocalDate today = LocalDate.now();
        if (this.uid == null || this.uid.isEmpty()) {
            this.valid = false;
            this.msgs.add("'uid' must not be empty or null");
        }
        if (this.type == null) {
            this.valid = false;
            this.msgs.add("'type' must not be empty or null");
        }
        try {
            LocalDate isd = SearchGuardLicense.parseDate(this.issueDate);
            if (isd.isAfter(today)) {
                this.valid = false;
                this.msgs.add("License not valid yet.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.valid = false;
            this.msgs.add("'issued_date' not valid");
        }
        try {
            LocalDate exd = SearchGuardLicense.parseDate(this.expiryDate);
            if (exd.isBefore(today)) {
                this.valid = false;
                this.msgs.add("License is expired");
            } else {
                this.isExpired = false;
                this.expiresInDays = SearchGuardLicense.diffDays(exd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.valid = false;
            this.msgs.add("'expiry_date' not valid");
        }
        if (this.issuedTo == null || this.issuedTo.isEmpty()) {
            this.valid = false;
            this.msgs.add("'issued_to' must not be empty or null");
        }
        if (this.issuer == null || this.issuer.isEmpty()) {
            this.valid = false;
            this.msgs.add("'issuer' must not be empty or null");
        }
        try {
            UUID.fromString(this.uid);
        }
        catch (Exception e) {
            this.valid = false;
            this.msgs.add("'uid' not valid");
        }
        try {
            SearchGuardLicense.parseDate(this.startDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.valid = false;
            this.msgs.add("'start_date' not valid");
        }
        if (this.clusterName == null || this.clusterName.isEmpty()) {
            this.valid = false;
            this.msgs.add("'cluster_name' must not be empty or null");
        }
        if ((numberOfNodes = this.clusterService.state().getNodes().getSize()) > this.allowedNodeCount) {
            this.valid = false;
            this.msgs.add("Only " + this.allowedNodeCount + " node(s) allowed but you run " + numberOfNodes + " node(s)");
        }
        String string = nodes = this.allowedNodeCount > 1500 ? "unlimited" : String.valueOf(this.allowedNodeCount);
        if (!this.valid) {
            this.prodUsage = "No, because the license is not valid.";
            this.action = "Purchase a license. Visit docs.search-guard.com/latest/search-guard-enterprise-edition or write to <sales@floragunn.com>";
        } else {
            switch (this.type) {
                case ACADEMIC: {
                    this.prodUsage = "Yes, unlimited clusters with all commercial features and " + nodes + " nodes per cluster for non-commercial academic and scientific use.";
                    break;
                }
                case OEM: {
                    this.prodUsage = "Yes, for usage with bundled OEM products. Standalone usage is not permitted.";
                    break;
                }
                case COMPANY: {
                    this.prodUsage = "Yes, unlimited clusters with all commercial features and " + nodes + " nodes per cluster for usage by '" + this.issuedTo + "'";
                    break;
                }
                default: {
                    this.prodUsage = "Yes, one cluster with all commercial features and " + nodes + " nodes per cluster.";
                }
            }
            this.action = "";
        }
    }

    private static LocalDate parseDate(String date) {
        return LocalDate.parse(date, DEFAULT_FOMATTER);
    }

    private static String addDays(String date, int days) {
        LocalDate d = SearchGuardLicense.parseDate(date);
        return DEFAULT_FOMATTER.format(d.plus(Period.ofDays(days)));
    }

    private static long diffDays(LocalDate to) {
        return ChronoUnit.DAYS.between(LocalDate.now(), to);
    }

    public String getUid() {
        return this.uid;
    }

    public Type getType() {
        return this.type;
    }

    public String getIssueDate() {
        return this.issueDate;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public String getIssuedTo() {
        return this.issuedTo;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public List<String> getMsgs() {
        return Collections.unmodifiableList(this.msgs);
    }

    public long getExpiresInDays() {
        return this.expiresInDays;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getAction() {
        return this.action;
    }

    public String getProdUsage() {
        return this.prodUsage;
    }

    public int getAllowedNodeCount() {
        return this.allowedNodeCount;
    }

    public Feature[] getFeatures() {
        return this.features == null ? null : (Feature[])this.features.clone();
    }

    public boolean hasFeature(Feature feature) {
        if (this.features == null || this.features.length == 0) {
            return false;
        }
        return Arrays.asList(this.features).contains((Object)feature);
    }

    public String toString() {
        return "SearchGuardLicense [uid=" + this.uid + ", type=" + (Object)((Object)this.type) + ", features=" + Arrays.toString((Object[])this.features) + ", issueDate=" + this.issueDate + ", expiryDate=" + this.expiryDate + ", issuedTo=" + this.issuedTo + ", issuer=" + this.issuer + ", startDate=" + this.startDate + ", majorVersion=" + this.majorVersion + ", clusterName=" + this.clusterName + ", allowedNodeCount=" + this.allowedNodeCount + ", msgs=" + this.msgs + ", expiresInDays=" + this.expiresInDays + ", isExpired=" + this.isExpired + ", valid=" + this.valid + ", action=" + this.action + ", prodUsage=" + this.prodUsage + ", clusterService=" + this.clusterService + ", getMsgs()=" + this.getMsgs() + ", getExpiresInDays()=" + this.getExpiresInDays() + ", isExpired()=" + this.isExpired() + ", isValid()=" + this.isValid() + ", getAction()=" + this.getAction() + ", getProdUsage()=" + this.getProdUsage() + "]";
    }

    public static enum Feature {
        COMPLIANCE;

    }

    public static enum Type {
        FULL,
        SME,
        SINGLE,
        ACADEMIC,
        OEM,
        TRIAL,
        COMPANY;

    }
}

