/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.filter;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.compliance.ComplianceConfig;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CompatConfig;
import com.floragunn.searchguard.configuration.DlsFlsRequestValve;
import com.floragunn.searchguard.privileges.PrivilegesEvaluator;
import com.floragunn.searchguard.privileges.PrivilegesEvaluatorResponse;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.SourceFieldsContext;
import com.floragunn.searchguard.user.User;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public class SearchGuardFilter
implements ActionFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final Logger actionTrace = LogManager.getLogger((String)"sg_action_trace");
    private final PrivilegesEvaluator evalp;
    private final AdminDNs adminDns;
    private DlsFlsRequestValve dlsFlsValve;
    private final AuditLog auditLog;
    private final org.elasticsearch.common.util.concurrent.ThreadContext threadContext;
    private final ClusterService cs;
    private final ComplianceConfig complianceConfig;
    private final CompatConfig compatConfig;

    public SearchGuardFilter(PrivilegesEvaluator evalp, AdminDNs adminDns, DlsFlsRequestValve dlsFlsValve, AuditLog auditLog, ThreadPool threadPool, ClusterService cs, ComplianceConfig complianceConfig, CompatConfig compatConfig) {
        this.evalp = evalp;
        this.adminDns = adminDns;
        this.dlsFlsValve = dlsFlsValve;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.cs = cs;
        this.complianceConfig = complianceConfig;
        this.compatConfig = compatConfig;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true);){
            ThreadContext.clearAll();
            this.apply0(task, action, request, listener, chain);
        }
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void apply0(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        try {
            boolean internalRequest;
            if (this.threadContext.getTransient("_sg_origin") == null) {
                this.threadContext.putTransient("_sg_origin", (Object)AuditLog.Origin.LOCAL.toString());
            }
            if (this.complianceConfig != null && this.complianceConfig.isEnabled()) {
                this.attachSourceFieldContext(request);
            }
            User user = (User)this.threadContext.getTransient("_sg_user");
            boolean userIsAdmin = SearchGuardFilter.isUserAdmin(user, this.adminDns);
            boolean interClusterRequest = HeaderHelper.isInterClusterRequest(this.threadContext);
            boolean trustedClusterRequest = HeaderHelper.isTrustedClusterRequest(this.threadContext);
            boolean confRequest = "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_sg_conf_request"));
            boolean passThroughRequest = action.equals("cluster:admin/searchguard/license/info") || action.startsWith("indices:admin/seq_no") || action.equals("cluster:admin/searchguard/whoami");
            boolean bl = internalRequest = (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext)) && action.startsWith("internal:") && !action.startsWith("internal:transport/proxy");
            if (user != null) {
                ThreadContext.put((String)"user", (String)user.getName());
            }
            if (this.actionTrace.isTraceEnabled()) {
                String count = "";
                if (request instanceof BulkRequest) {
                    count = "" + ((BulkRequest)request).requests().size();
                }
                if (request instanceof MultiGetRequest) {
                    count = "" + ((MultiGetRequest)request).getItems().size();
                }
                if (request instanceof MultiSearchRequest) {
                    count = "" + ((MultiSearchRequest)request).requests().size();
                }
                this.actionTrace.trace("Node " + this.cs.localNode().getName() + " -> " + action + " (" + count + "): userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + this.threadContext.getTransient("_sg_origin") + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + request.remoteAddress());
                this.threadContext.putHeader("_sg_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " FILTER -> Node " + this.cs.localNode().getName() + " -> " + action + " userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + this.threadContext.getTransient("_sg_origin") + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + request.remoteAddress() + " " + this.threadContext.getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_sg_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())));
            }
            if (userIsAdmin || confRequest || internalRequest || passThroughRequest) {
                if (userIsAdmin && !confRequest && !internalRequest && !passThroughRequest) {
                    this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            if (this.complianceConfig != null && this.complianceConfig.isEnabled()) {
                boolean isImmutable = false;
                if (request instanceof BulkShardRequest) {
                    BulkItemRequest bsr;
                    BulkItemRequest[] bulkItemRequestArray = ((BulkShardRequest)request).items();
                    int n = bulkItemRequestArray.length;
                    for (int i = 0; i < n && !(isImmutable = this.checkImmutableIndices((bsr = bulkItemRequestArray[i]).request(), listener)); ++i) {
                    }
                } else {
                    isImmutable = this.checkImmutableIndices(request, listener);
                }
                if (isImmutable) {
                    return;
                }
            }
            if (AuditLog.Origin.LOCAL.toString().equals(this.threadContext.getTransient("_sg_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext))) {
                chain.proceed(task, action, request, listener);
                return;
            }
            if (user == null) {
                if (action.startsWith("cluster:monitor/state")) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                if ((interClusterRequest || trustedClusterRequest || request.remoteAddress() == null) && !this.compatConfig.transportInterClusterAuthEnabled()) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                this.log.error("No user found for " + action + " from " + request.remoteAddress() + " " + this.threadContext.getTransient("_sg_origin") + " via " + this.threadContext.getTransient("_sg_channel_type") + " " + this.threadContext.getHeaders());
                listener.onFailure((Exception)new ElasticsearchSecurityException("No user found for " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                return;
            }
            PrivilegesEvaluator eval = this.evalp;
            if (!eval.isInitialized()) {
                this.log.error("Search Guard not initialized (SG11) for {}", (Object)action);
                listener.onFailure((Exception)new ElasticsearchSecurityException("Search Guard not initialized (SG11) for " + action + ". See https://docs.search-guard.com/latest/sgadmin", RestStatus.SERVICE_UNAVAILABLE, new Object[0]));
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Evaluate permissions for user: {}", (Object)user.getName());
            }
            PrivilegesEvaluatorResponse pres = eval.evaluate(user, action, request, task);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)pres);
            }
            if (pres.isAllowed()) {
                this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                if (!this.dlsFlsValve.invoke(request, listener, pres.getAllowedFlsFields(), pres.getMaskedFields(), pres.getQueries())) {
                    return;
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            this.auditLog.logMissingPrivileges(action, (TransportRequest)request, task);
            this.log.debug("no permissions for {}", pres.getMissingPrivileges());
            listener.onFailure((Exception)new ElasticsearchSecurityException("no permissions for " + pres.getMissingPrivileges() + " and " + user, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        catch (Throwable e) {
            this.log.error("Unexpected exception " + e, e);
            listener.onFailure((Exception)new ElasticsearchSecurityException("Unexpected exception " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            return;
        }
    }

    private static boolean isUserAdmin(User user, AdminDNs adminDns) {
        return user != null && adminDns.isAdmin(user);
    }

    private void attachSourceFieldContext(ActionRequest request) {
        if (request instanceof SearchRequest && SourceFieldsContext.isNeeded((SearchRequest)request)) {
            if (this.threadContext.getHeader("_sg_source_field_context") == null) {
                String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((SearchRequest)request));
                this.threadContext.putHeader("_sg_source_field_context", serializedSourceFieldContext);
            }
        } else if (request instanceof GetRequest && SourceFieldsContext.isNeeded((GetRequest)request) && this.threadContext.getHeader("_sg_source_field_context") == null) {
            String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((GetRequest)request));
            this.threadContext.putHeader("_sg_source_field_context", serializedSourceFieldContext);
        }
    }

    private boolean checkImmutableIndices(Object request, ActionListener listener) {
        if ((request instanceof DeleteRequest || request instanceof UpdateRequest || request instanceof UpdateByQueryRequest || request instanceof DeleteByQueryRequest || request instanceof DeleteIndexRequest || request instanceof RestoreSnapshotRequest || request instanceof CloseIndexRequest || request instanceof IndicesAliasesRequest) && this.complianceConfig != null && this.complianceConfig.isIndexImmutable(request)) {
            listener.onFailure((Exception)new ElasticsearchSecurityException("Index is immutable", RestStatus.FORBIDDEN, new Object[0]));
            return true;
        }
        if (request instanceof IndexRequest && this.complianceConfig != null && this.complianceConfig.isIndexImmutable(request)) {
            ((IndexRequest)request).opType(DocWriteRequest.OpType.CREATE);
        }
        return false;
    }
}

