/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.filter;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.configuration.CompatConfig;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import com.floragunn.searchguard.support.HTTPHelper;
import com.floragunn.searchguard.user.User;
import java.nio.file.Path;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchGuardRestFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final BackendRegistry registry;
    private final AuditLog auditLog;
    private final org.elasticsearch.common.util.concurrent.ThreadContext threadContext;
    private final PrincipalExtractor principalExtractor;
    private final Settings settings;
    private final Path configPath;
    private final CompatConfig compatConfig;

    public SearchGuardRestFilter(BackendRegistry registry, AuditLog auditLog, ThreadPool threadPool, PrincipalExtractor principalExtractor, Settings settings, Path configPath, CompatConfig compatConfig) {
        this.registry = registry;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.principalExtractor = principalExtractor;
        this.settings = settings;
        this.configPath = configPath;
        this.compatConfig = compatConfig;
    }

    public RestHandler wrap(final RestHandler original) {
        return new RestHandler(){

            public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
                ThreadContext.clearAll();
                if (!SearchGuardRestFilter.this.checkAndAuthenticateRequest(request, channel, client)) {
                    original.handleRequest(request, channel, client);
                }
            }
        };
    }

    private boolean checkAndAuthenticateRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        this.threadContext.putTransient("_sg_origin", (Object)AuditLog.Origin.REST.toString());
        if (HTTPHelper.containsBadHeader(request)) {
            ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
            this.log.error((Object)exception);
            this.auditLog.logBadHeaders(request);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
            return true;
        }
        if (SSLRequestHelper.containsBadHeader(this.threadContext, "_sg_")) {
            ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
            this.log.error((Object)exception);
            this.auditLog.logBadHeaders(request);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
            return true;
        }
        try {
            SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(this.settings, this.configPath, request, this.principalExtractor);
            if (sslInfo != null) {
                if (sslInfo.getPrincipal() != null) {
                    this.threadContext.putTransient("_sg_ssl_principal", (Object)sslInfo.getPrincipal());
                }
                if (sslInfo.getX509Certs() != null) {
                    this.threadContext.putTransient("_sg_ssl_peer_certificates", (Object)sslInfo.getX509Certs());
                }
                this.threadContext.putTransient("_sg_ssl_protocol", (Object)sslInfo.getProtocol());
                this.threadContext.putTransient("_sg_ssl_cipher", (Object)sslInfo.getCipher());
            }
        }
        catch (SSLPeerUnverifiedException e) {
            this.log.error("No ssl info", (Throwable)e);
            this.auditLog.logSSLException(request, e);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)e));
            return true;
        }
        if (!this.compatConfig.restAuthEnabled()) {
            return false;
        }
        if (request.method() != RestRequest.Method.OPTIONS && !"/_searchguard/license".equals(request.path()) && !"/_searchguard/health".equals(request.path())) {
            if (!this.registry.authenticate(request, channel, this.threadContext)) {
                ThreadContext.remove((String)"user");
                return true;
            }
            ThreadContext.put((String)"user", (String)((User)this.threadContext.getTransient("_sg_user")).getName());
        }
        return false;
    }
}

