/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.http.RemoteIpDetector;
import com.floragunn.searchguard.sgconf.ConfigModel;
import com.floragunn.searchguard.sgconf.DynamicConfigFactory;
import com.floragunn.searchguard.sgconf.DynamicConfigModel;
import com.floragunn.searchguard.sgconf.InternalUsersModel;
import java.net.InetSocketAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class XFFResolver
implements DynamicConfigFactory.DCFListener {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile boolean enabled;
    private volatile RemoteIpDetector detector;
    private final ThreadContext threadContext;

    public XFFResolver(ThreadPool threadPool) {
        this.threadContext = threadPool.getThreadContext();
    }

    public TransportAddress resolve(RestRequest request) throws ElasticsearchSecurityException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolve {}", (Object)request.getHttpChannel().getRemoteAddress());
        }
        if (this.enabled && request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress && request.getHttpChannel() instanceof Netty4HttpChannel) {
            InetSocketAddress isa = new InetSocketAddress(this.detector.detect(request, this.threadContext), request.getHttpChannel().getRemoteAddress().getPort());
            if (isa.isUnresolved()) {
                throw new ElasticsearchSecurityException("Cannot resolve address " + isa.getHostString(), new Object[0]);
            }
            if (this.log.isTraceEnabled()) {
                if (this.threadContext.getTransient("_sg_xff_done") == Boolean.TRUE) {
                    this.log.trace("xff resolved {} to {}", (Object)request.getHttpChannel().getRemoteAddress(), (Object)isa);
                } else {
                    this.log.trace("no xff done for {}", request.getClass());
                }
            }
            return new TransportAddress(isa);
        }
        if (request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("no xff done (enabled or no netty request) {},{},{},{}", (Object)this.enabled, request.getClass());
            }
            return new TransportAddress(request.getHttpChannel().getRemoteAddress());
        }
        throw new ElasticsearchSecurityException("Cannot handle this request. Remote address is " + request.getHttpChannel().getRemoteAddress() + " with request class " + request.getClass(), new Object[0]);
    }

    @Override
    public void onChanged(ConfigModel cm, DynamicConfigModel dcm, InternalUsersModel ium) {
        this.enabled = dcm.isXffEnabled();
        if (this.enabled) {
            this.detector = new RemoteIpDetector();
            this.detector.setInternalProxies(dcm.getInternalProxies());
            this.detector.setRemoteIpHeader(dcm.getRemoteIpHeader());
        } else {
            this.detector = null;
        }
    }
}

