/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.privileges;

import com.floragunn.searchguard.privileges.PrivilegesEvaluatorResponse;
import com.floragunn.searchguard.resolver.IndexResolverReplacer;
import com.floragunn.searchguard.sgconf.SgRoles;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.User;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;

public class DlsFlsEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ThreadPool threadPool;

    public DlsFlsEvaluator(Settings settings, ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, ClusterService clusterService, IndexNameExpressionResolver resolver, IndexResolverReplacer.Resolved requestedResolved, User user, SgRoles sgRoles, PrivilegesEvaluatorResponse presponse) {
        Map.Entry<String, Set<String>> entry;
        Iterator<Map.Entry<String, Set<String>>> it;
        ThreadContext threadContext = this.threadPool.getThreadContext();
        Map<String, Set<String>> maskedFieldsMap = sgRoles.getMaskedFields(user, resolver, clusterService);
        if (maskedFieldsMap != null && !maskedFieldsMap.isEmpty()) {
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(threadContext)) {
                threadContext.addResponseHeader("_sg_masked_fields", Base64Helper.serializeObject((Serializable)((Object)maskedFieldsMap)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("added response header for masked fields info: {}", maskedFieldsMap);
                }
            } else if (threadContext.getHeader("_sg_masked_fields") != null) {
                if (!maskedFieldsMap.equals(Base64Helper.deserializeObject(threadContext.getHeader("_sg_masked_fields")))) {
                    throw new ElasticsearchSecurityException("_sg_masked_fields does not match (SG 901D)", new Object[0]);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("_sg_masked_fields already set");
                }
            } else {
                threadContext.putHeader("_sg_masked_fields", Base64Helper.serializeObject((Serializable)((Object)maskedFieldsMap)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("attach masked fields info: {}", maskedFieldsMap);
                }
            }
            presponse.maskedFields = new HashMap<String, Set<String>>(maskedFieldsMap);
            if (!requestedResolved.getAllIndices().isEmpty()) {
                Iterator<Map.Entry<String, Set<String>>> it2 = presponse.maskedFields.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry<String, Set<String>> entry2 = it2.next();
                    if (WildcardMatcher.matchAny(entry2.getKey(), requestedResolved.getAllIndices(), false)) continue;
                    it2.remove();
                }
            }
        }
        Tuple<Map<String, Set<String>>, Map<String, Set<String>>> dlsFls = sgRoles.getDlsFls(user, resolver, clusterService);
        Map dlsQueries = (Map)dlsFls.v1();
        Map flsFields = (Map)dlsFls.v2();
        if (!dlsQueries.isEmpty()) {
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(threadContext)) {
                threadContext.addResponseHeader("_sg_dls_query", Base64Helper.serializeObject((Serializable)((Object)dlsQueries)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("added response header for DLS info: {}", (Object)dlsQueries);
                }
            } else if (threadContext.getHeader("_sg_dls_query") != null) {
                if (!dlsQueries.equals(Base64Helper.deserializeObject(threadContext.getHeader("_sg_dls_query")))) {
                    throw new ElasticsearchSecurityException("_sg_dls_query does not match (SG 900D)", new Object[0]);
                }
            } else {
                threadContext.putHeader("_sg_dls_query", Base64Helper.serializeObject((Serializable)((Object)dlsQueries)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("attach DLS info: {}", (Object)dlsQueries);
                }
            }
            presponse.queries = new HashMap<String, Set<String>>(dlsQueries);
            if (!requestedResolved.getAllIndices().isEmpty()) {
                it = presponse.queries.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    if (WildcardMatcher.matchAny(entry.getKey(), requestedResolved.getAllIndices(), false)) continue;
                    it.remove();
                }
            }
        }
        if (!flsFields.isEmpty()) {
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(threadContext)) {
                threadContext.addResponseHeader("_sg_fls_fields", Base64Helper.serializeObject((Serializable)((Object)flsFields)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("added response header for FLS info: {}", (Object)flsFields);
                }
            } else if (threadContext.getHeader("_sg_fls_fields") != null) {
                if (!flsFields.equals(Base64Helper.deserializeObject(threadContext.getHeader("_sg_fls_fields")))) {
                    throw new ElasticsearchSecurityException("_sg_fls_fields does not match (SG 901D)", new Object[0]);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("_sg_fls_fields already set");
                }
            } else {
                threadContext.putHeader("_sg_fls_fields", Base64Helper.serializeObject((Serializable)((Object)flsFields)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("attach FLS info: {}", (Object)flsFields);
                }
            }
            presponse.allowedFlsFields = new HashMap<String, Set<String>>(flsFields);
            if (!requestedResolved.getAllIndices().isEmpty()) {
                it = presponse.allowedFlsFields.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    if (WildcardMatcher.matchAny(entry.getKey(), requestedResolved.getAllIndices(), false)) continue;
                    it.remove();
                }
            }
        }
        return presponse;
    }
}

