/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.privileges;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.privileges.PrivilegesEvaluatorResponse;
import com.floragunn.searchguard.resolver.IndexResolverReplacer;
import com.floragunn.searchguard.support.WildcardMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;

public class SearchGuardIndexAccessEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final String searchguardIndex;
    private final AuditLog auditLog;
    private final String[] sgDeniedActionPatterns;
    private final IndexResolverReplacer irr;
    private final boolean filterSgIndex;

    public SearchGuardIndexAccessEvaluator(Settings settings, AuditLog auditLog, IndexResolverReplacer irr) {
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.auditLog = auditLog;
        this.irr = irr;
        this.filterSgIndex = settings.getAsBoolean("searchguard.filter_sgindex_from_all_requests", Boolean.valueOf(false));
        boolean restoreSgIndexEnabled = settings.getAsBoolean("searchguard.unsupported.restore.sgindex.enabled", Boolean.valueOf(false));
        ArrayList<String> sgIndexDeniedActionPatternsList = new ArrayList<String>();
        sgIndexDeniedActionPatternsList.add("indices:data/write*");
        sgIndexDeniedActionPatternsList.add("indices:admin/delete*");
        sgIndexDeniedActionPatternsList.add("indices:admin/mapping/delete*");
        sgIndexDeniedActionPatternsList.add("indices:admin/mapping/put*");
        sgIndexDeniedActionPatternsList.add("indices:admin/freeze*");
        sgIndexDeniedActionPatternsList.add("indices:admin/settings/update*");
        sgIndexDeniedActionPatternsList.add("indices:admin/aliases");
        ArrayList<String> sgIndexDeniedActionPatternsListNoSnapshot = new ArrayList<String>();
        sgIndexDeniedActionPatternsListNoSnapshot.addAll(sgIndexDeniedActionPatternsList);
        sgIndexDeniedActionPatternsListNoSnapshot.add("indices:admin/close*");
        sgIndexDeniedActionPatternsListNoSnapshot.add("cluster:admin/snapshot/restore*");
        this.sgDeniedActionPatterns = (restoreSgIndexEnabled ? sgIndexDeniedActionPatternsList : sgIndexDeniedActionPatternsListNoSnapshot).toArray(new String[0]);
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, Task task, String action, IndexResolverReplacer.Resolved requestedResolved, PrivilegesEvaluatorResponse presponse) {
        if (requestedResolved.getAllIndices().contains(this.searchguardIndex) && WildcardMatcher.matchAny(this.sgDeniedActionPatterns, action)) {
            if (this.filterSgIndex) {
                HashSet<String> allWithoutSg = new HashSet<String>(requestedResolved.getAllIndices());
                allWithoutSg.remove(this.searchguardIndex);
                if (allWithoutSg.isEmpty()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Filtered '{}' but resulting list is empty", (Object)this.searchguardIndex);
                    }
                    presponse.allowed = false;
                    return presponse.markComplete();
                }
                this.irr.replace((TransportRequest)request, false, allWithoutSg.toArray(new String[0]));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Filtered '{}', resulting list is {}", (Object)this.searchguardIndex, allWithoutSg);
                }
                return presponse;
            }
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action, task);
            this.log.warn(action + " for '{}' index is not allowed for a regular user", (Object)this.searchguardIndex);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if (requestedResolved.isLocalAll() && WildcardMatcher.matchAny(this.sgDeniedActionPatterns, action)) {
            if (this.filterSgIndex) {
                this.irr.replace((TransportRequest)request, false, "*", "-" + this.searchguardIndex);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Filtered '{}'from {}, resulting list with *,-{} is {}", (Object)this.searchguardIndex, (Object)requestedResolved, (Object)this.searchguardIndex, (Object)this.irr.resolveRequest(request));
                }
                return presponse;
            }
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action, task);
            this.log.warn(action + " for '_all' indices is not allowed for a regular user");
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if (requestedResolved.getAllIndices().contains(this.searchguardIndex) || requestedResolved.isLocalAll()) {
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).requestCache(Boolean.FALSE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable search request cache for this request");
                }
            }
            if (request instanceof RealtimeRequest) {
                ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable realtime for this request");
                }
            }
        }
        return presponse;
    }
}

