/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.privileges;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.ClusterInfoHolder;
import com.floragunn.searchguard.privileges.PrivilegesEvaluatorResponse;
import com.floragunn.searchguard.support.SnapshotRestoreHelper;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;

public class SnapshotRestoreEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final boolean enableSnapshotRestorePrivilege;
    private final String searchguardIndex;
    private final AuditLog auditLog;
    private final boolean restoreSgIndexEnabled;

    public SnapshotRestoreEvaluator(Settings settings, AuditLog auditLog) {
        this.enableSnapshotRestorePrivilege = settings.getAsBoolean("searchguard.enable_snapshot_restore_privilege", Boolean.valueOf(true));
        this.restoreSgIndexEnabled = settings.getAsBoolean("searchguard.unsupported.restore.sgindex.enabled", Boolean.valueOf(false));
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.auditLog = auditLog;
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, Task task, String action, ClusterInfoHolder clusterInfoHolder, PrivilegesEvaluatorResponse presponse) {
        if (!(request instanceof RestoreSnapshotRequest)) {
            return presponse;
        }
        if (!this.enableSnapshotRestorePrivilege) {
            this.log.warn(action + " is not allowed for a regular user");
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if (this.restoreSgIndexEnabled) {
            presponse.allowed = true;
            return presponse;
        }
        if (clusterInfoHolder.isLocalNodeElectedMaster() == Boolean.FALSE) {
            presponse.allowed = true;
            return presponse.markComplete();
        }
        RestoreSnapshotRequest restoreRequest = (RestoreSnapshotRequest)request;
        if (restoreRequest.includeGlobalState()) {
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action, task);
            this.log.warn(action + " with 'include_global_state' enabled is not allowed");
            presponse.allowed = false;
            return presponse.markComplete();
        }
        List<String> rs = SnapshotRestoreHelper.resolveOriginalIndices(restoreRequest);
        if (rs != null && (rs.contains(this.searchguardIndex) || rs.contains("_all") || rs.contains("*"))) {
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action, task);
            this.log.warn(action + " for '{}' as source index is not allowed", (Object)this.searchguardIndex);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        return presponse;
    }
}

