/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.privileges;

import com.floragunn.searchguard.privileges.PrivilegesEvaluatorResponse;
import com.floragunn.searchguard.resolver.IndexResolverReplacer;
import com.floragunn.searchguard.sgconf.SgRoles;
import com.floragunn.searchguard.user.User;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class TermsAggregationEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private static final String[] READ_ACTIONS = new String[]{"indices:data/read/msearch", "indices:data/read/mget", "indices:data/read/get", "indices:data/read/search", "indices:data/read/field_caps*"};
    private static final QueryBuilder NONE_QUERY = new MatchNoneQueryBuilder();

    public PrivilegesEvaluatorResponse evaluate(IndexResolverReplacer.Resolved resolved, ActionRequest request, ClusterService clusterService, User user, SgRoles sgRoles, IndexNameExpressionResolver resolver, PrivilegesEvaluatorResponse presponse) {
        try {
            AggregationBuilder ab;
            SearchRequest sr;
            if (request instanceof SearchRequest && (sr = (SearchRequest)request).source() != null && sr.source().query() == null && sr.source().aggregations() != null && sr.source().aggregations().getAggregatorFactories() != null && sr.source().aggregations().getAggregatorFactories().size() == 1 && sr.source().size() == 0 && (ab = (AggregationBuilder)sr.source().aggregations().getAggregatorFactories().iterator().next()) instanceof TermsAggregationBuilder && "terms".equals(ab.getType()) && "indices".equals(ab.getName()) && "_index".equals(((TermsAggregationBuilder)ab).field()) && ab.getPipelineAggregations().isEmpty() && ab.getSubAggregations().isEmpty()) {
                Set<String> allPermittedIndices = sgRoles.getAllPermittedIndicesForKibana(resolved, user, READ_ACTIONS, resolver, clusterService);
                if (allPermittedIndices == null || allPermittedIndices.isEmpty()) {
                    sr.source().query(NONE_QUERY);
                } else {
                    sr.source().query((QueryBuilder)new TermsQueryBuilder("_index", allPermittedIndices));
                }
                presponse.allowed = true;
                return presponse.markComplete();
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to evaluate terms aggregation", (Throwable)e);
            return presponse;
        }
        return presponse;
    }
}

