/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.resolver;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.configuration.ClusterInfoHolder;
import com.floragunn.searchguard.sgconf.ConfigModel;
import com.floragunn.searchguard.sgconf.DynamicConfigFactory;
import com.floragunn.searchguard.sgconf.DynamicConfigModel;
import com.floragunn.searchguard.sgconf.InternalUsersModel;
import com.floragunn.searchguard.support.SnapshotRestoreHelper;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.main.MainRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportRequest;

public final class IndexResolverReplacer
implements DynamicConfigFactory.DCFListener {
    private static final Set<String> NULL_SET = Sets.newHashSet((Object[])new String[]{null});
    private final Logger log = LogManager.getLogger(this.getClass());
    private final IndexNameExpressionResolver resolver;
    private final ClusterService clusterService;
    private final ClusterInfoHolder clusterInfoHolder;
    private volatile boolean respectRequestIndicesOptions = false;

    public IndexResolverReplacer(IndexNameExpressionResolver resolver, ClusterService clusterService, ClusterInfoHolder clusterInfoHolder) {
        this.resolver = resolver;
        this.clusterService = clusterService;
        this.clusterInfoHolder = clusterInfoHolder;
    }

    private static final boolean isAllWithNoRemote(String ... requestedPatterns) {
        List<String> patterns;
        List<String> list = patterns = requestedPatterns == null ? null : Arrays.asList(requestedPatterns);
        if (IndexNameExpressionResolver.isAllIndices(patterns)) {
            return true;
        }
        if (patterns.size() == 1 && patterns.contains("*")) {
            return true;
        }
        return new HashSet<String>(patterns).equals(NULL_SET);
    }

    private static final boolean isLocalAll(String ... requestedPatterns) {
        List<String> patterns;
        List<String> list = patterns = requestedPatterns == null ? null : Arrays.asList(requestedPatterns);
        if (IndexNameExpressionResolver.isAllIndices(patterns)) {
            return true;
        }
        if (patterns.contains("_all")) {
            return true;
        }
        return new HashSet<String>(patterns).equals(NULL_SET);
    }

    private Resolved resolveIndexPatterns(IndicesOptions indicesOptions, Object request, String ... requestedPatterns0) {
        HashSet<Object> matchingAllIndices;
        HashSet<Object> matchingIndices;
        HashSet<String> matchingAliases;
        Set<String> remoteIndices;
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolve requestedPatterns: " + Arrays.toString(requestedPatterns0));
        }
        if (IndexResolverReplacer.isAllWithNoRemote(requestedPatterns0)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(Arrays.toString(requestedPatterns0) + " is an ALL pattern without any remote indices");
            }
            return Resolved._LOCAL_ALL;
        }
        ArrayList<String> localRequestedPatterns = new ArrayList<String>(Arrays.asList(requestedPatterns0));
        RemoteClusterService remoteClusterService = SearchGuardPlugin.GuiceHolder.getRemoteClusterService();
        if (remoteClusterService.isCrossClusterSearchEnabled() && request != null && (request instanceof FieldCapabilitiesRequest || request instanceof SearchRequest)) {
            remoteIndices = new HashSet();
            Map remoteClusterIndices = SearchGuardPlugin.GuiceHolder.getRemoteClusterService().groupIndices(indicesOptions, requestedPatterns0, idx -> this.resolver.hasIndexOrAlias(idx, this.clusterService.state()));
            Set<String> remoteClusters = remoteClusterIndices.keySet().stream().filter(k -> !"".equals(k)).collect(Collectors.toSet());
            for (String remoteCluster : remoteClusters) {
                for (String remoteIndex : ((OriginalIndices)remoteClusterIndices.get(remoteCluster)).indices()) {
                    remoteIndices.add(RemoteClusterService.buildRemoteIndexName((String)remoteCluster, (String)remoteIndex));
                }
            }
            Iterator iterator = localRequestedPatterns.iterator();
            while (iterator.hasNext()) {
                String[] split = ((String)iterator.next()).split(String.valueOf(':'), 2);
                if (split.length <= 1 || !WildcardMatcher.matchAny(split[0], remoteClusters)) continue;
                iterator.remove();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("CCS is enabled, we found this local patterns " + localRequestedPatterns + " and this remote patterns: " + remoteIndices);
            }
        } else {
            remoteIndices = Collections.emptySet();
        }
        if (IndexResolverReplacer.isLocalAll(requestedPatterns0)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(Arrays.toString(requestedPatterns0) + " is an LOCAL ALL pattern");
            }
            matchingAliases = Resolved.All_SET;
            matchingIndices = Resolved.All_SET;
            matchingAllIndices = Resolved.All_SET;
        } else {
            ArrayList<Object> _indices;
            Set<String> aliases;
            SortedMap lookup;
            block23: {
                if (!remoteIndices.isEmpty() && localRequestedPatterns.isEmpty()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(Arrays.toString(requestedPatterns0) + " is an LOCAL EMPTY request");
                    }
                    return new Resolved.Builder().addOriginalRequested(Arrays.asList(requestedPatterns0)).addRemoteIndices(remoteIndices).build();
                }
                ClusterState state = this.clusterService.state();
                lookup = state.metaData().getAliasAndIndexLookup();
                aliases = lookup.entrySet().stream().filter(e -> ((AliasOrIndex)e.getValue()).isAlias()).map(e -> (String)e.getKey()).collect(Collectors.toSet());
                matchingAliases = new HashSet<String>(localRequestedPatterns.size() * 10);
                matchingIndices = new HashSet<Object>(localRequestedPatterns.size() * 10);
                matchingAllIndices = new HashSet<Object>(localRequestedPatterns.size() * 10);
                for (String localRequestedPattern : localRequestedPatterns) {
                    String requestedPattern = this.resolver.resolveDateMathExpression(localRequestedPattern);
                    List<String> _aliases = WildcardMatcher.getMatchAny(requestedPattern, aliases);
                    matchingAliases.addAll(_aliases);
                }
                try {
                    _indices = new ArrayList<String>(Arrays.asList(this.resolver.concreteIndexNames(state, indicesOptions, localRequestedPatterns.toArray(new String[0]))));
                    if (!this.log.isDebugEnabled()) break block23;
                    this.log.debug("Resolved pattern {} to {}", localRequestedPatterns, _indices);
                }
                catch (IndexNotFoundException e1) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("No such indices for pattern {}, use raw value", localRequestedPatterns);
                    }
                    _indices = new ArrayList(localRequestedPatterns.size());
                    for (String requestedPattern : localRequestedPatterns) {
                        _indices.add(this.resolver.resolveDateMathExpression(requestedPattern));
                    }
                }
            }
            List<String> _aliases = WildcardMatcher.getMatchAny(localRequestedPatterns.toArray(new String[0]), aliases);
            matchingAllIndices.addAll(_indices);
            if (_aliases.isEmpty()) {
                matchingIndices.addAll(_indices);
            } else if (!_indices.isEmpty()) {
                for (String al : _aliases) {
                    Set doubleIndices = ((AliasOrIndex)lookup.get(al)).getIndices().stream().map(a -> a.getIndex().getName()).collect(Collectors.toSet());
                    _indices.removeAll(doubleIndices);
                }
                matchingIndices.addAll(_indices);
            }
        }
        return new Resolved.Builder((Collection<String>)matchingAliases, (Collection<String>)matchingIndices, (Collection<String>)matchingAllIndices, null, requestedPatterns0, remoteIndices).build();
    }

    public boolean replace(TransportRequest request, final boolean retainMode, final String ... replacements) {
        return this.getOrReplaceAllIndices(request, new IndicesProvider(){

            @Override
            public String[] provide(String[] original, Object request, boolean supportsReplace) {
                if (supportsReplace) {
                    if (retainMode && !IndexResolverReplacer.isAllWithNoRemote(original)) {
                        Resolved resolved = IndexResolverReplacer.this.resolveRequest(request);
                        List<String> retained = WildcardMatcher.getMatchAny(resolved.getAllIndices(), replacements);
                        retained.addAll(resolved.getRemoteIndices());
                        return retained.toArray(new String[0]);
                    }
                    return replacements;
                }
                return NOOP;
            }
        }, false);
    }

    public Resolved resolveRequest(final Object request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolve aliases, indices and types from {}", (Object)request.getClass().getSimpleName());
        }
        final Resolved.Builder resolvedBuilder = new Resolved.Builder();
        final AtomicBoolean isIndicesRequest = new AtomicBoolean();
        this.getOrReplaceAllIndices(request, new IndicesProvider(){

            @Override
            public String[] provide(String[] original, Object localRequest, boolean supportsReplace) {
                IndicesOptions indicesOptions = IndexResolverReplacer.this.indicesOptionsFrom(localRequest);
                Resolved iResolved = IndexResolverReplacer.this.resolveIndexPatterns(indicesOptions, localRequest, original);
                resolvedBuilder.add(iResolved);
                isIndicesRequest.set(true);
                if (IndexResolverReplacer.this.log.isTraceEnabled()) {
                    IndexResolverReplacer.this.log.trace("Resolved patterns {} for {} ({}) to {}", (Object)original, (Object)localRequest.getClass().getSimpleName(), (Object)request.getClass().getSimpleName(), (Object)iResolved);
                }
                return IndicesProvider.NOOP;
            }
        }, false);
        if (!isIndicesRequest.get()) {
            return Resolved._LOCAL_ALL;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Finally resolved for {}: {}", (Object)request.getClass().getSimpleName(), (Object)resolvedBuilder.build());
        }
        return resolvedBuilder.build();
    }

    private List<String> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices) {
        try {
            ArrayList<String> renamedIndices = new ArrayList<String>();
            Iterator<String> iterator = filteredIndices.iterator();
            while (iterator.hasNext()) {
                String index;
                String renamedIndex = index = iterator.next();
                if (request.renameReplacement() != null && request.renamePattern() != null) {
                    renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
                }
                renamedIndices.add(renamedIndex);
            }
            return renamedIndices;
        }
        catch (PatternSyntaxException e) {
            this.log.error("Unable to parse the regular expression denoted in 'rename_pattern'. Please correct the pattern an try again.");
            throw e;
        }
    }

    private boolean checkIndices(Object request, String[] indices, boolean needsToBeSizeOne, boolean allowEmpty) {
        if (indices == IndicesProvider.NOOP) {
            return false;
        }
        if (!(allowEmpty || indices != null && indices.length != 0)) {
            if (this.log.isTraceEnabled() && request != null) {
                this.log.trace("Null or empty indices for " + request.getClass().getName());
            }
            return false;
        }
        if (!allowEmpty && needsToBeSizeOne && indices.length != 1) {
            if (this.log.isTraceEnabled() && request != null) {
                this.log.trace("To much indices for " + request.getClass().getName());
            }
            return false;
        }
        for (int i = 0; i < indices.length; ++i) {
            String index = indices[i];
            if (index != null && !index.isEmpty()) continue;
            if (this.log.isTraceEnabled() && request != null) {
                this.log.trace("At least one null or empty index for " + request.getClass().getName());
            }
            return false;
        }
        return true;
    }

    private boolean getOrReplaceAllIndices(Object request, IndicesProvider provider, boolean allowEmptyIndices) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("getOrReplaceAllIndices() for " + request.getClass());
        }
        boolean result = true;
        if (request instanceof BulkRequest) {
            for (DocWriteRequest ar : ((BulkRequest)request).requests()) {
                result = this.getOrReplaceAllIndices(ar, provider, false) && result;
            }
        } else if (request instanceof MultiGetRequest) {
            ListIterator it = ((MultiGetRequest)request).getItems().listIterator();
            while (it.hasNext()) {
                MultiGetRequest.Item item = (MultiGetRequest.Item)it.next();
                result = this.getOrReplaceAllIndices(item, provider, false) && result;
            }
        } else if (request instanceof MultiSearchRequest) {
            ListIterator it = ((MultiSearchRequest)request).requests().listIterator();
            while (it.hasNext()) {
                SearchRequest ar = (SearchRequest)it.next();
                result = this.getOrReplaceAllIndices(ar, provider, false) && result;
            }
        } else if (request instanceof MultiTermVectorsRequest) {
            for (ActionRequest ar : () -> ((MultiTermVectorsRequest)request).iterator()) {
                result = this.getOrReplaceAllIndices(ar, provider, false) && result;
            }
        } else if (request instanceof PutMappingRequest) {
            PutMappingRequest pmr = (PutMappingRequest)request;
            Index concreteIndex = pmr.getConcreteIndex();
            if (concreteIndex != null && (pmr.indices() == null || pmr.indices().length == 0)) {
                String[] newIndices = provider.provide(new String[]{concreteIndex.getName()}, request, true);
                if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                    return false;
                }
                ((PutMappingRequest)request).indices(newIndices);
                ((PutMappingRequest)request).setConcreteIndex(null);
            } else {
                String[] newIndices = provider.provide(((PutMappingRequest)request).indices(), request, true);
                if (!this.checkIndices(request, newIndices, false, allowEmptyIndices)) {
                    return false;
                }
                ((PutMappingRequest)request).indices(newIndices);
            }
        } else if (request instanceof RestoreSnapshotRequest) {
            if (this.clusterInfoHolder.isLocalNodeElectedMaster() == Boolean.FALSE) {
                return true;
            }
            RestoreSnapshotRequest restoreRequest = (RestoreSnapshotRequest)request;
            SnapshotInfo snapshotInfo = SnapshotRestoreHelper.getSnapshotInfo(restoreRequest);
            if (snapshotInfo == null) {
                this.log.warn("snapshot repository '" + restoreRequest.repository() + "', snapshot '" + restoreRequest.snapshot() + "' not found");
                provider.provide(new String[]{"*"}, request, false);
            } else {
                List requestedResolvedIndices = SnapshotUtils.filterIndices((List)snapshotInfo.indices(), (String[])restoreRequest.indices(), (IndicesOptions)restoreRequest.indicesOptions());
                List<String> renamedTargetIndices = this.renamedIndices(restoreRequest, requestedResolvedIndices);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("snapshot: {} contains this indices: {}", (Object)snapshotInfo.snapshotId().getName(), renamedTargetIndices);
                }
                provider.provide(renamedTargetIndices.toArray(new String[0]), request, false);
            }
        } else if (request instanceof IndicesAliasesRequest) {
            for (IndicesAliasesRequest.AliasActions ar : ((IndicesAliasesRequest)request).getAliasActions()) {
                result = this.getOrReplaceAllIndices(ar, provider, false) && result;
            }
        } else if (request instanceof DeleteRequest) {
            String[] newIndices = provider.provide(((DeleteRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((DeleteRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof UpdateRequest) {
            String[] newIndices = provider.provide(((UpdateRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((UpdateRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof SingleShardRequest) {
            String[] newIndices;
            SingleShardRequest gr = (SingleShardRequest)request;
            String[] indices = gr.indices();
            String index = gr.index();
            ArrayList<String> indicesL = new ArrayList<String>();
            if (index != null) {
                indicesL.add(index);
            }
            if (indices != null && indices.length > 0) {
                indicesL.addAll(Arrays.asList(indices));
            }
            if (!this.checkIndices(request, newIndices = provider.provide(indicesL.toArray(new String[0]), request, true), true, allowEmptyIndices)) {
                return false;
            }
            ((SingleShardRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof IndexRequest) {
            String[] newIndices = provider.provide(((IndexRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((IndexRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof IndicesRequest.Replaceable) {
            String[] newIndices = provider.provide(((IndicesRequest.Replaceable)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, false, allowEmptyIndices)) {
                return false;
            }
            ((IndicesRequest.Replaceable)request).indices(newIndices);
        } else if (request instanceof BulkShardRequest) {
            provider.provide(((ReplicationRequest)request).indices(), request, false);
        } else if (request instanceof ReplicationRequest) {
            String[] newIndices = provider.provide(((ReplicationRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((ReplicationRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof MultiGetRequest.Item) {
            String[] newIndices = provider.provide(((MultiGetRequest.Item)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((MultiGetRequest.Item)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof CreateIndexRequest) {
            String[] newIndices = provider.provide(((CreateIndexRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((CreateIndexRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof ReindexRequest) {
            result = this.getOrReplaceAllIndices(((ReindexRequest)request).getDestination(), provider, false) && result;
            result = this.getOrReplaceAllIndices(((ReindexRequest)request).getSearchRequest(), provider, false) && result;
        } else if (!(request instanceof BaseNodesRequest || request instanceof MainRequest || request instanceof ClearScrollRequest || request instanceof SearchScrollRequest)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(request.getClass() + " not supported (It is likely not a indices related request)");
            }
            result = false;
        }
        return result;
    }

    private IndicesOptions indicesOptionsFrom(Object localRequest) {
        if (!this.respectRequestIndicesOptions) {
            return IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)false);
        }
        if (IndicesRequest.class.isInstance(localRequest)) {
            return ((IndicesRequest)localRequest).indicesOptions();
        }
        if (RestoreSnapshotRequest.class.isInstance(localRequest)) {
            return ((RestoreSnapshotRequest)localRequest).indicesOptions();
        }
        return IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)false);
    }

    @Override
    public void onChanged(ConfigModel cm, DynamicConfigModel dcm, InternalUsersModel ium) {
        this.respectRequestIndicesOptions = dcm.isRespectRequestIndicesEnabled();
    }

    @FunctionalInterface
    public static interface IndicesProvider {
        public static final String[] NOOP = new String[0];

        public String[] provide(String[] var1, Object var2, boolean var3);
    }

    public static final class Resolved
    implements Serializable,
    Writeable {
        private static final Set<String> All_SET = Collections.singleton("*");
        private static final long serialVersionUID = 1L;
        public static final Resolved _LOCAL_ALL = new Resolved(All_SET, All_SET, All_SET, All_SET, Collections.emptySet(), Collections.emptySet());
        private final Set<String> aliases;
        private final Set<String> indices;
        private final Set<String> allIndices;
        private final Set<String> types;
        private final Set<String> originalRequested;
        private final Set<String> remoteIndices;

        private Resolved(Set<String> aliases, Set<String> indices, Set<String> allIndices, Set<String> types, Set<String> originalRequested, Set<String> remoteIndices) {
            this.aliases = aliases;
            this.indices = indices;
            this.allIndices = allIndices;
            this.types = types;
            this.originalRequested = originalRequested;
            this.remoteIndices = remoteIndices;
            if (aliases.isEmpty() && indices.isEmpty() && allIndices.isEmpty() || types.isEmpty()) {
                // empty if block
            }
        }

        public boolean isLocalAll() {
            if (IndexResolverReplacer.isLocalAll(this.originalRequested == null ? null : this.originalRequested.toArray(new String[0]))) {
                return true;
            }
            return this.aliases.contains("*") && this.indices.contains("*") && this.allIndices.contains("*") && this.types.contains("*");
        }

        public Set<String> getAliases() {
            return Collections.unmodifiableSet(this.aliases);
        }

        public Set<String> getIndices() {
            return Collections.unmodifiableSet(this.indices);
        }

        public Set<String> getAllIndices() {
            return Collections.unmodifiableSet(this.allIndices);
        }

        public Set<String> getTypes() {
            return Collections.unmodifiableSet(this.types);
        }

        public Set<String> getOriginalRequested() {
            return Collections.unmodifiableSet(this.originalRequested);
        }

        public Set<String> getRemoteIndices() {
            return Collections.unmodifiableSet(this.remoteIndices);
        }

        public String toString() {
            return "Resolved [aliases=" + this.aliases + ", indices=" + this.indices + ", allIndices=" + this.allIndices + ", types=" + this.types + ", originalRequested=" + this.originalRequested + ", remoteIndices=" + this.remoteIndices + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.aliases == null ? 0 : this.aliases.hashCode());
            result = 31 * result + (this.allIndices == null ? 0 : this.allIndices.hashCode());
            result = 31 * result + (this.indices == null ? 0 : this.indices.hashCode());
            result = 31 * result + (this.originalRequested == null ? 0 : this.originalRequested.hashCode());
            result = 31 * result + (this.remoteIndices == null ? 0 : this.remoteIndices.hashCode());
            result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resolved other = (Resolved)obj;
            if (this.aliases == null ? other.aliases != null : !this.aliases.equals(other.aliases)) {
                return false;
            }
            if (this.allIndices == null ? other.allIndices != null : !this.allIndices.equals(other.allIndices)) {
                return false;
            }
            if (this.indices == null ? other.indices != null : !this.indices.equals(other.indices)) {
                return false;
            }
            if (this.originalRequested == null ? other.originalRequested != null : !this.originalRequested.equals(other.originalRequested)) {
                return false;
            }
            if (this.remoteIndices == null ? other.remoteIndices != null : !this.remoteIndices.equals(other.remoteIndices)) {
                return false;
            }
            return !(this.types == null ? other.types != null : !this.types.equals(other.types));
        }

        public Resolved(StreamInput in) throws IOException {
            this.aliases = new HashSet<String>(in.readList(StreamInput::readString));
            this.indices = new HashSet<String>(in.readList(StreamInput::readString));
            this.allIndices = new HashSet<String>(in.readList(StreamInput::readString));
            this.types = new HashSet<String>(in.readList(StreamInput::readString));
            this.originalRequested = new HashSet<String>(in.readList(StreamInput::readString));
            this.remoteIndices = new HashSet<String>(in.readList(StreamInput::readString));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(new ArrayList<String>(this.aliases));
            out.writeStringCollection(new ArrayList<String>(this.indices));
            out.writeStringCollection(new ArrayList<String>(this.allIndices));
            out.writeStringCollection(new ArrayList<String>(this.types));
            out.writeStringCollection(new ArrayList<String>(this.originalRequested));
            out.writeStringCollection(new ArrayList<String>(this.remoteIndices));
        }

        private static class Builder {
            private final Set<String> aliases = new HashSet<String>();
            private final Set<String> indices = new HashSet<String>();
            private final Set<String> allIndices = new HashSet<String>();
            private final Set<String> originalRequested = new HashSet<String>();
            private final Set<String> remoteIndices = new HashSet<String>();

            public Builder() {
                this(null, null, null, null, null, null);
            }

            public Builder(Collection<String> aliases, Collection<String> indices, Collection<String> allIndices, Collection<String> types, String[] originalRequested, Collection<String> remoteIndices) {
                if (aliases != null) {
                    this.aliases.addAll(aliases);
                }
                if (indices != null) {
                    this.indices.addAll(indices);
                }
                if (allIndices != null) {
                    this.allIndices.addAll(allIndices);
                }
                if (types != null) {
                    // empty if block
                }
                if (originalRequested != null) {
                    this.originalRequested.addAll(Arrays.asList(originalRequested));
                }
                if (remoteIndices != null) {
                    this.remoteIndices.addAll(remoteIndices);
                }
            }

            public Builder add(Resolved r) {
                this.aliases.addAll(r.aliases);
                this.indices.addAll(r.indices);
                this.allIndices.addAll(r.allIndices);
                this.originalRequested.addAll(r.originalRequested);
                this.remoteIndices.addAll(r.remoteIndices);
                return this;
            }

            public Builder addOriginalRequested(List<String> originalRequested) {
                if (originalRequested != null) {
                    this.originalRequested.addAll(originalRequested);
                }
                return this;
            }

            public Builder addRemoteIndices(Set<String> remoteIndices) {
                if (remoteIndices != null) {
                    this.remoteIndices.addAll(remoteIndices);
                }
                return this;
            }

            public Resolved build() {
                return new Resolved(new HashSet<String>(this.aliases), new HashSet<String>(this.indices), new HashSet<String>(this.allIndices), Collections.singleton("*"), new HashSet<String>(this.originalRequested), new HashSet<String>(this.remoteIndices));
            }
        }
    }
}

