/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.privileges.PrivilegesEvaluator;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class KibanaInfoAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;

    public KibanaInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool) {
        super(settings);
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
        controller.registerHandler(RestRequest.Method.GET, "/_searchguard/kibanainfo", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_searchguard/kibanainfo", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)KibanaInfoAction.this.threadContext.getTransient("_sg_user");
                    builder.startObject();
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("not_fail_on_forbidden_enabled", KibanaInfoAction.this.evaluator.notFailOnForbiddenEnabled());
                    builder.field("kibana_mt_enabled", KibanaInfoAction.this.evaluator.multitenancyEnabled());
                    builder.field("kibana_index", KibanaInfoAction.this.evaluator.kibanaIndex());
                    builder.field("kibana_server_user", KibanaInfoAction.this.evaluator.kibanaServerUsername());
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Kibana Info Action";
    }

    static /* synthetic */ Logger access$200(KibanaInfoAction x0) {
        return x0.log;
    }
}

