/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.auth.BackendRegistry;
import java.io.IOException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class SearchGuardHealthAction
extends BaseRestHandler {
    private final BackendRegistry registry;

    public SearchGuardHealthAction(Settings settings, RestController controller, BackendRegistry registry) {
        super(settings);
        this.registry = registry;
        controller.registerHandler(RestRequest.Method.GET, "/_searchguard/health", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_searchguard/health", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final String mode;
            {
                this.mode = request.param("mode", "strict");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                XContentBuilder builder = channel.newBuilder();
                RestStatus restStatus = RestStatus.OK;
                BytesRestResponse response = null;
                try {
                    String status = "UP";
                    String message = null;
                    builder.startObject();
                    if ("strict".equalsIgnoreCase(this.mode) && !SearchGuardHealthAction.this.registry.isInitialized()) {
                        status = "DOWN";
                        message = "Not initialized";
                        restStatus = RestStatus.SERVICE_UNAVAILABLE;
                    }
                    builder.field("message", message);
                    builder.field("mode", this.mode);
                    builder.field("status", status);
                    builder.endObject();
                    response = new BytesRestResponse(restStatus, builder);
                }
                finally {
                    builder.close();
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Search Guard Health Check";
    }
}

