/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.privileges.PrivilegesEvaluator;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class TenantInfoAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;
    private final ClusterService clusterService;
    private final AdminDNs adminDns;

    public TenantInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool, ClusterService clusterService, AdminDNs adminDns) {
        super(settings);
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
        this.clusterService = clusterService;
        this.adminDns = adminDns;
        controller.registerHandler(RestRequest.Method.GET, "/_searchguard/tenantinfo", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_searchguard/tenantinfo", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)TenantInfoAction.this.threadContext.getTransient("_sg_user");
                    if (user == null || !user.getName().equals(TenantInfoAction.this.evaluator.kibanaServerUsername()) && !TenantInfoAction.this.adminDns.isAdmin(user)) {
                        response = new BytesRestResponse(RestStatus.FORBIDDEN, "");
                    } else {
                        builder.startObject();
                        SortedMap lookup = TenantInfoAction.this.clusterService.state().metaData().getAliasAndIndexLookup();
                        for (String indexOrAlias : lookup.keySet()) {
                            String tenant = TenantInfoAction.this.tenantNameForIndex(indexOrAlias);
                            if (tenant == null) continue;
                            builder.field(indexOrAlias, tenant);
                        }
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.OK, builder);
                    }
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    private String tenantNameForIndex(String index) {
        String[] indexParts;
        if (index == null || (indexParts = index.split("_")).length != 3) {
            return null;
        }
        if (!indexParts[0].equals(this.evaluator.kibanaIndex())) {
            return null;
        }
        try {
            int expectedHash = Integer.parseInt(indexParts[1]);
            String sanitizedName = indexParts[2];
            for (String tenant : this.evaluator.getAllConfiguredTenantNames()) {
                if (tenant.hashCode() != expectedHash || !sanitizedName.equals(tenant.toLowerCase().replaceAll("[^a-z0-9]+", ""))) continue;
                return tenant;
            }
            return "__private__";
        }
        catch (NumberFormatException e) {
            this.log.warn("Index " + index + " looks like a SG tenant index but we cannot parse the hashcode so we ignore it.");
            return null;
        }
    }

    public String getName() {
        return "Tenant Info Action";
    }

    static /* synthetic */ Logger access$500(TenantInfoAction x0) {
        return x0.log;
    }
}

