/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgconf;

import com.floragunn.searchguard.resolver.IndexResolverReplacer;
import com.floragunn.searchguard.sgconf.ConfigModel;
import com.floragunn.searchguard.sgconf.DynamicConfigModel;
import com.floragunn.searchguard.sgconf.impl.SgDynamicConfiguration;
import com.floragunn.searchguard.sgconf.impl.v7.ActionGroupsV7;
import com.floragunn.searchguard.sgconf.impl.v7.RoleMappingsV7;
import com.floragunn.searchguard.sgconf.impl.v7.RoleV7;
import com.floragunn.searchguard.sgconf.impl.v7.TenantV7;
import com.floragunn.searchguard.support.ConfigConstants;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;

public class ConfigModelV7
extends ConfigModel {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private ConfigConstants.RolesMappingResolution rolesMappingResolution;
    private ActionGroupResolver agr = null;
    private SgRoles sgRoles = null;
    private TenantHolder tenantHolder;
    private RoleMappingHolder roleMappingHolder;
    private SgDynamicConfiguration<RoleV7> roles;
    private SgDynamicConfiguration<TenantV7> tenants;

    public ConfigModelV7(SgDynamicConfiguration<RoleV7> roles, SgDynamicConfiguration<RoleMappingsV7> rolemappings, SgDynamicConfiguration<ActionGroupsV7> actiongroups, SgDynamicConfiguration<TenantV7> tenants, DynamicConfigModel dcm, Settings esSettings) {
        this.roles = roles;
        this.tenants = tenants;
        try {
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.valueOf(esSettings.get("searchguard.roles_mapping_resolution", ConfigConstants.RolesMappingResolution.MAPPING_ONLY.toString()).toUpperCase());
        }
        catch (Exception e) {
            this.log.error("Cannot apply roles mapping resolution", (Throwable)e);
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.MAPPING_ONLY;
        }
        this.agr = this.reloadActionGroups(actiongroups);
        this.sgRoles = this.reload(roles);
        this.tenantHolder = new TenantHolder(roles, tenants);
        this.roleMappingHolder = new RoleMappingHolder(rolemappings, dcm.getHostsResolverMode());
    }

    @Override
    public Set<String> getAllConfiguredTenantNames() {
        return Collections.unmodifiableSet(this.tenants.getCEntries().keySet());
    }

    @Override
    public SgRoles getSgRoles() {
        return this.sgRoles;
    }

    private ActionGroupResolver reloadActionGroups(final SgDynamicConfiguration<ActionGroupsV7> actionGroups) {
        return new ActionGroupResolver(){

            private Set<String> getGroupMembers(String groupname) {
                if (actionGroups == null) {
                    return Collections.emptySet();
                }
                return Collections.unmodifiableSet(this.resolve(actionGroups, groupname));
            }

            private Set<String> resolve(SgDynamicConfiguration<?> actionGroups2, String entry) {
                if (!actionGroups2.getCEntries().containsKey(entry)) {
                    return Collections.emptySet();
                }
                HashSet<String> ret = new HashSet<String>();
                Object actionGroupAsObject = actionGroups2.getCEntries().get(entry);
                if (actionGroupAsObject != null && actionGroupAsObject instanceof List) {
                    for (String perm : (List)actionGroupAsObject) {
                        if (actionGroups2.getCEntries().keySet().contains(perm)) {
                            ret.addAll(this.resolve(actionGroups2, perm));
                            continue;
                        }
                        ret.add(perm);
                    }
                } else if (actionGroupAsObject != null && actionGroupAsObject instanceof ActionGroupsV7) {
                    for (String perm : ((ActionGroupsV7)actionGroupAsObject).getAllowed_actions()) {
                        if (actionGroups2.getCEntries().keySet().contains(perm)) {
                            ret.addAll(this.resolve(actionGroups2, perm));
                            continue;
                        }
                        ret.add(perm);
                    }
                } else {
                    throw new RuntimeException("Unable to handle " + actionGroupAsObject);
                }
                return Collections.unmodifiableSet(ret);
            }

            @Override
            public Set<String> resolvedActions(List<String> actions) {
                HashSet<String> resolvedActions = new HashSet<String>();
                for (String string : actions) {
                    Set<String> groups = this.getGroupMembers(string);
                    if (groups.isEmpty()) {
                        resolvedActions.add(string);
                        continue;
                    }
                    resolvedActions.addAll(groups);
                }
                return Collections.unmodifiableSet(resolvedActions);
            }
        };
    }

    private SgRoles reload(SgDynamicConfiguration<RoleV7> settings) {
        HashSet<Future> futures = new HashSet<Future>(5000);
        ExecutorService execs = Executors.newFixedThreadPool(10);
        for (final Map.Entry<String, RoleV7> sgRole : settings.getCEntries().entrySet()) {
            Future future = execs.submit(new Callable<SgRole>(){

                @Override
                public SgRole call() throws Exception {
                    SgRole _sgRole = new SgRole((String)sgRole.getKey());
                    if (sgRole.getValue() == null) {
                        return null;
                    }
                    Set<String> permittedClusterActions = ConfigModelV7.this.agr.resolvedActions(((RoleV7)sgRole.getValue()).getCluster_permissions());
                    _sgRole.addClusterPerms(permittedClusterActions);
                    for (RoleV7.Index permittedAliasesIndex : ((RoleV7)sgRole.getValue()).getIndex_permissions()) {
                        String dls = permittedAliasesIndex.getDls();
                        List<String> fls = permittedAliasesIndex.getFls();
                        List<String> maskedFields = permittedAliasesIndex.getMasked_fields();
                        for (String pat : permittedAliasesIndex.getIndex_patterns()) {
                            IndexPattern _indexPattern = new IndexPattern(pat);
                            _indexPattern.setDlsQuery(dls);
                            _indexPattern.addFlsFields(fls);
                            _indexPattern.addMaskedFields(maskedFields);
                            _indexPattern.addPerm(ConfigModelV7.this.agr.resolvedActions(permittedAliasesIndex.getAllowed_actions()));
                            _sgRole.addIndexPattern(_indexPattern);
                        }
                    }
                    return _sgRole;
                }
            });
            futures.add(future);
        }
        execs.shutdown();
        try {
            execs.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Thread interrupted (1) while loading roles");
            return null;
        }
        try {
            SgRoles _sgRoles = new SgRoles(futures.size());
            for (Future future : futures) {
                _sgRoles.addSgRole((SgRole)future.get());
            }
            return _sgRoles;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Thread interrupted (2) while loading roles");
            return null;
        }
        catch (ExecutionException e) {
            this.log.error("Error while updating roles: {}", (Object)e.getCause(), (Object)e.getCause());
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    private static String replaceProperties(String orig, User user) {
        if (user == null || orig == null) {
            return orig;
        }
        orig = orig.replace("${user.name}", user.getName()).replace("${user_name}", user.getName());
        orig = ConfigModelV7.replaceRoles(orig, user);
        for (Map.Entry<String, String> entry : user.getCustomAttributesMap().entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            orig = orig.replace("${" + entry.getKey() + "}", entry.getValue());
            orig = orig.replace("${" + entry.getKey().replace('.', '_') + "}", entry.getValue());
        }
        return orig;
    }

    private static String replaceRoles(String orig, User user) {
        String retVal = orig;
        if (orig.contains("${user.roles}") || orig.contains("${user_roles}")) {
            String commaSeparatedRoles = ConfigModelV7.toQuotedCommaSeparatedString(user.getRoles());
            retVal = orig.replace("${user.roles}", commaSeparatedRoles).replace("${user_roles}", commaSeparatedRoles);
        }
        return retVal;
    }

    private static String toQuotedCommaSeparatedString(Set<String> roles) {
        return Joiner.on((char)',').join(Iterables.transform(roles, s -> new StringBuilder(s.length() + 2).append('\"').append((String)s).append('\"').toString()));
    }

    private static boolean impliesTypePerm(Set<IndexPattern> ipatterns, IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
        HashSet<String> matchingIndex = new HashSet<String>(resolved.getAllIndices());
        for (String in : resolved.getAllIndices()) {
            HashSet<String> matchingActions = new HashSet<String>(Arrays.asList(actions));
            for (IndexPattern p : ipatterns) {
                if (!WildcardMatcher.matchAny(p.getResolvedIndexPattern(user, resolver, cs), in)) continue;
                for (String a : Arrays.asList(actions)) {
                    if (!WildcardMatcher.matchAny((Collection<String>)p.perms, a)) continue;
                    matchingActions.remove(a);
                }
            }
            if (!matchingActions.isEmpty()) continue;
            matchingIndex.remove(in);
        }
        return matchingIndex.isEmpty();
    }

    @Override
    public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
        return this.tenantHolder.mapTenants(user, roles);
    }

    @Override
    public Set<String> mapSgRoles(User user, TransportAddress caller) {
        return this.roleMappingHolder.map(user, caller);
    }

    private class RoleMappingHolder {
        private ListMultimap<String, String> users;
        private ListMultimap<Set<String>, String> abars;
        private ListMultimap<String, String> bars;
        private ListMultimap<String, String> hosts;
        private final String hostResolverMode;

        private RoleMappingHolder(SgDynamicConfiguration<RoleMappingsV7> rolemappings, String hostResolverMode) {
            this.hostResolverMode = hostResolverMode;
            if (ConfigModelV7.this.roles != null) {
                ArrayListMultimap users_ = ArrayListMultimap.create();
                ArrayListMultimap abars_ = ArrayListMultimap.create();
                ArrayListMultimap bars_ = ArrayListMultimap.create();
                ArrayListMultimap hosts_ = ArrayListMultimap.create();
                for (Map.Entry<String, RoleMappingsV7> roleMap : rolemappings.getCEntries().entrySet()) {
                    for (String u : roleMap.getValue().getUsers()) {
                        users_.put((Object)u, (Object)roleMap.getKey());
                    }
                    HashSet<String> abar = new HashSet<String>(roleMap.getValue().getAnd_backend_roles());
                    if (!abar.isEmpty()) {
                        abars_.put(abar, (Object)roleMap.getKey());
                    }
                    for (String bar : roleMap.getValue().getBackend_roles()) {
                        bars_.put((Object)bar, (Object)roleMap.getKey());
                    }
                    for (String host : roleMap.getValue().getHosts()) {
                        hosts_.put((Object)host, (Object)roleMap.getKey());
                    }
                }
                this.users = users_;
                this.abars = abars_;
                this.bars = bars_;
                this.hosts = hosts_;
            }
        }

        private Set<String> map(User user, TransportAddress caller) {
            if (user == null || this.users == null || this.abars == null || this.bars == null || this.hosts == null) {
                return Collections.emptySet();
            }
            TreeSet<String> sgRoles = new TreeSet<String>(user.getSearchGuardRoles());
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BACKENDROLES_ONLY) {
                if (ConfigModelV7.this.log.isDebugEnabled()) {
                    ConfigModelV7.this.log.debug("Pass backendroles from {}", (Object)user);
                }
                sgRoles.addAll(user.getRoles());
            }
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.MAPPING_ONLY) {
                for (String string : WildcardMatcher.getAllMatchingPatterns((Collection<String>)this.users.keySet(), user.getName())) {
                    sgRoles.addAll(this.users.get((Object)string));
                }
                for (String string : WildcardMatcher.getAllMatchingPatterns((Collection<String>)this.bars.keySet(), user.getRoles())) {
                    sgRoles.addAll(this.bars.get((Object)string));
                }
                for (Set set : this.abars.keySet()) {
                    if (!WildcardMatcher.allPatternsMatched(set, user.getRoles())) continue;
                    sgRoles.addAll(this.abars.get((Object)set));
                }
                if (caller != null) {
                    String ipAddress = caller.getAddress();
                    for (String p : WildcardMatcher.getAllMatchingPatterns((Collection<String>)this.hosts.keySet(), ipAddress)) {
                        sgRoles.addAll(this.hosts.get((Object)p));
                    }
                    if (caller.address() != null && (this.hostResolverMode.equalsIgnoreCase("ip-hostname") || this.hostResolverMode.equalsIgnoreCase("ip-hostname-lookup"))) {
                        String string = caller.address().getHostString();
                        for (String p : WildcardMatcher.getAllMatchingPatterns((Collection<String>)this.hosts.keySet(), string)) {
                            sgRoles.addAll(this.hosts.get((Object)p));
                        }
                    }
                    if (caller.address() != null && this.hostResolverMode.equalsIgnoreCase("ip-hostname-lookup")) {
                        String string = caller.address().getHostName();
                        for (String p : WildcardMatcher.getAllMatchingPatterns((Collection<String>)this.hosts.keySet(), string)) {
                            sgRoles.addAll(this.hosts.get((Object)p));
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(sgRoles);
        }
    }

    private class TenantHolder {
        private SetMultimap<String, Tuple<String, Boolean>> tenantsMM = null;

        public TenantHolder(SgDynamicConfiguration<RoleV7> roles, final SgDynamicConfiguration<TenantV7> definedTenants) {
            HashSet<Future> futures = new HashSet<Future>(roles.getCEntries().size());
            ExecutorService execs = Executors.newFixedThreadPool(10);
            for (final Map.Entry<String, RoleV7> sgRole : roles.getCEntries().entrySet()) {
                if (sgRole.getValue() == null) continue;
                Future future = execs.submit(new Callable<Tuple<String, Set<Tuple<String, Boolean>>>>(){

                    @Override
                    public Tuple<String, Set<Tuple<String, Boolean>>> call() throws Exception {
                        HashSet<Tuple> tuples = new HashSet<Tuple>();
                        List<RoleV7.Tenant> tenants = ((RoleV7)sgRole.getValue()).getTenant_permissions();
                        if (tenants != null) {
                            for (RoleV7.Tenant tenant : tenants) {
                                for (String matchingTenant : WildcardMatcher.getMatchAny(tenant.getTenant_patterns(), definedTenants.getCEntries().keySet())) {
                                    tuples.add(new Tuple((Object)matchingTenant, (Object)ConfigModelV7.this.agr.resolvedActions(tenant.getAllowed_actions()).contains("kibana:saved_objects/*/write")));
                                }
                            }
                        }
                        return new Tuple((Object)((String)sgRole.getKey()), tuples);
                    }
                });
                futures.add(future);
            }
            execs.shutdown();
            try {
                execs.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV7.this.log.error("Thread interrupted (1) while loading roles");
                return;
            }
            try {
                SetMultimap tenantsMM_ = MultimapBuilder.SetMultimapBuilder.hashKeys((int)futures.size()).hashSetValues(16).build();
                for (Future future : futures) {
                    Tuple result = (Tuple)future.get();
                    tenantsMM_.putAll((Object)((String)result.v1()), (Iterable)result.v2());
                }
                this.tenantsMM = tenantsMM_;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV7.this.log.error("Thread interrupted (2) while loading roles");
                return;
            }
            catch (ExecutionException e) {
                ConfigModelV7.this.log.error("Error while updating roles: {}", (Object)e.getCause(), (Object)e.getCause());
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }

        public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
            if (user == null || this.tenantsMM == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(roles.size());
            result.put(user.getName(), true);
            this.tenantsMM.entries().stream().filter(e -> roles.contains(e.getKey())).filter(e -> !user.getName().equals(((Tuple)e.getValue()).v1())).forEach(e -> {
                String tenant = (String)((Tuple)e.getValue()).v1();
                boolean rw = (Boolean)((Tuple)e.getValue()).v2();
                if (rw || !result.containsKey(tenant)) {
                    result.put(tenant, rw);
                }
            });
            if (!result.containsKey("SGS_GLOBAL_TENANT") && (roles.contains("sg_kibana_user") || roles.contains("SGS_KIBANA_USER") || roles.contains("sg_all_access") || roles.contains("SGS_ALL_ACCESS"))) {
                result.put("SGS_GLOBAL_TENANT", true);
            }
            return Collections.unmodifiableMap(result);
        }
    }

    public static class Tenant {
        private final String tenant;
        private final boolean readWrite;

        private Tenant(String tenant, boolean readWrite) {
            this.tenant = tenant;
            this.readWrite = readWrite;
        }

        public String getTenant() {
            return this.tenant;
        }

        public boolean isReadWrite() {
            return this.readWrite;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.readWrite ? 1231 : 1237);
            result = 31 * result + (this.tenant == null ? 0 : this.tenant.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tenant other = (Tenant)obj;
            if (this.readWrite != other.readWrite) {
                return false;
            }
            return !(this.tenant == null ? other.tenant != null : !this.tenant.equals(other.tenant));
        }

        public String toString() {
            return System.lineSeparator() + "                tenant=" + this.tenant + System.lineSeparator() + "                readWrite=" + this.readWrite;
        }
    }

    public static class IndexPattern {
        private final String indexPattern;
        private String dlsQuery;
        private final Set<String> fls = new HashSet<String>();
        private final Set<String> maskedFields = new HashSet<String>();
        private final Set<String> perms = new HashSet<String>();

        public IndexPattern(String indexPattern) {
            this.indexPattern = Objects.requireNonNull(indexPattern);
        }

        public IndexPattern addFlsFields(List<String> flsFields) {
            if (flsFields != null) {
                this.fls.addAll(flsFields);
            }
            return this;
        }

        public IndexPattern addMaskedFields(List<String> maskedFields) {
            if (maskedFields != null) {
                this.maskedFields.addAll(maskedFields);
            }
            return this;
        }

        public IndexPattern addPerm(Set<String> perms) {
            if (perms != null) {
                this.perms.addAll(perms);
            }
            return this;
        }

        public IndexPattern setDlsQuery(String dlsQuery) {
            if (dlsQuery != null) {
                this.dlsQuery = dlsQuery;
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dlsQuery == null ? 0 : this.dlsQuery.hashCode());
            result = 31 * result + (this.fls == null ? 0 : this.fls.hashCode());
            result = 31 * result + (this.maskedFields == null ? 0 : this.maskedFields.hashCode());
            result = 31 * result + (this.indexPattern == null ? 0 : this.indexPattern.hashCode());
            result = 31 * result + (this.perms == null ? 0 : this.perms.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexPattern other = (IndexPattern)obj;
            if (this.dlsQuery == null ? other.dlsQuery != null : !this.dlsQuery.equals(other.dlsQuery)) {
                return false;
            }
            if (this.fls == null ? other.fls != null : !this.fls.equals(other.fls)) {
                return false;
            }
            if (this.maskedFields == null ? other.maskedFields != null : !this.maskedFields.equals(other.maskedFields)) {
                return false;
            }
            if (this.indexPattern == null ? other.indexPattern != null : !this.indexPattern.equals(other.indexPattern)) {
                return false;
            }
            return !(this.perms == null ? other.perms != null : !this.perms.equals(other.perms));
        }

        public String toString() {
            return System.lineSeparator() + "        indexPattern=" + this.indexPattern + System.lineSeparator() + "          dlsQuery=" + this.dlsQuery + System.lineSeparator() + "          fls=" + this.fls + System.lineSeparator() + "          perms=" + this.perms;
        }

        public String getUnresolvedIndexPattern(User user) {
            return ConfigModelV7.replaceProperties(this.indexPattern, user);
        }

        private String[] getResolvedIndexPattern(User user, IndexNameExpressionResolver resolver, ClusterService cs) {
            String[] aliasesForPermittedPattern;
            String unresolved = this.getUnresolvedIndexPattern(user);
            String[] resolved = null;
            if (WildcardMatcher.containsWildcard(unresolved) && (aliasesForPermittedPattern = (String[])cs.state().getMetaData().getAliasAndIndexLookup().entrySet().stream().filter(e -> ((AliasOrIndex)e.getValue()).isAlias()).filter(e -> WildcardMatcher.match(unresolved, (String)e.getKey())).map(e -> (String)e.getKey()).toArray(String[]::new)) != null && aliasesForPermittedPattern.length > 0) {
                resolved = resolver.concreteIndexNames(cs.state(), IndicesOptions.lenientExpandOpen(), aliasesForPermittedPattern);
            }
            if (resolved == null && !unresolved.isEmpty()) {
                resolved = resolver.concreteIndexNames(cs.state(), IndicesOptions.lenientExpandOpen(), new String[]{unresolved});
            }
            if (resolved == null || resolved.length == 0) {
                return new String[]{unresolved};
            }
            String[] retval = (String[])Arrays.copyOf(resolved, resolved.length + 1);
            retval[retval.length - 1] = unresolved;
            return retval;
        }

        public String getDlsQuery(User user) {
            return ConfigModelV7.replaceProperties(this.dlsQuery, user);
        }

        public Set<String> getFls() {
            return Collections.unmodifiableSet(this.fls);
        }

        public Set<String> getMaskedFields() {
            return Collections.unmodifiableSet(this.maskedFields);
        }

        public Set<String> getPerms() {
            return Collections.unmodifiableSet(this.perms);
        }
    }

    public static class SgRole {
        private final String name;
        private final Set<IndexPattern> ipatterns = new HashSet<IndexPattern>();
        private final Set<String> clusterPerms = new HashSet<String>();

        private SgRole(String name) {
            this.name = Objects.requireNonNull(name);
        }

        private boolean impliesClusterPermission(String action) {
            return WildcardMatcher.matchAny(this.clusterPerms, action);
        }

        private Set<String> getAllResolvedPermittedIndices(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet retVal = new HashSet();
            for (IndexPattern p : this.ipatterns) {
                boolean patternMatch = WildcardMatcher.matchAll(p.getPerms().toArray(new String[0]), actions);
                if (!patternMatch) continue;
                String[] permitted = p.getResolvedIndexPattern(user, resolver, cs);
                HashSet<String> res = new HashSet<String>();
                if (!(resolved.isLocalAll() || resolved.getAllIndices().contains("*") || resolved.getAllIndices().contains("_all"))) {
                    HashSet<String> wanted = new HashSet<String>(resolved.getAllIndices());
                    WildcardMatcher.wildcardRetainInSet(wanted, permitted);
                    res.addAll(wanted);
                } else {
                    String[] allIndices = cs.state().metaData().getConcreteAllOpenIndices();
                    HashSet<String> wanted = new HashSet<String>(Arrays.asList(allIndices));
                    WildcardMatcher.wildcardRetainInSet(wanted, permitted);
                    res.addAll(wanted);
                }
                retVal.addAll(res);
            }
            return Collections.unmodifiableSet(retVal);
        }

        private SgRole addIndexPattern(IndexPattern indexPattern) {
            if (indexPattern != null) {
                this.ipatterns.add(indexPattern);
            }
            return this;
        }

        private SgRole addClusterPerms(Collection<String> clusterPerms) {
            if (clusterPerms != null) {
                this.clusterPerms.addAll(clusterPerms);
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clusterPerms == null ? 0 : this.clusterPerms.hashCode());
            result = 31 * result + (this.ipatterns == null ? 0 : this.ipatterns.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SgRole other = (SgRole)obj;
            if (this.clusterPerms == null ? other.clusterPerms != null : !this.clusterPerms.equals(other.clusterPerms)) {
                return false;
            }
            if (this.ipatterns == null ? other.ipatterns != null : !this.ipatterns.equals(other.ipatterns)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return System.lineSeparator() + "  " + this.name + System.lineSeparator() + "    ipatterns=" + this.ipatterns + System.lineSeparator() + "    clusterPerms=" + this.clusterPerms;
        }

        public Set<IndexPattern> getIpatterns() {
            return Collections.unmodifiableSet(this.ipatterns);
        }

        public Set<String> getClusterPerms() {
            return Collections.unmodifiableSet(this.clusterPerms);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class SgRoles
    extends com.floragunn.searchguard.sgconf.SgRoles {
        protected final Logger log = LogManager.getLogger(this.getClass());
        final Set<SgRole> roles;

        private SgRoles(int roleCount) {
            this.roles = new HashSet<SgRole>(roleCount);
        }

        private SgRoles addSgRole(SgRole sgRole) {
            if (sgRole != null) {
                this.roles.add(sgRole);
            }
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SgRoles other = (SgRoles)obj;
            return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
        }

        public String toString() {
            return "roles=" + this.roles;
        }

        public Set<SgRole> getRoles() {
            return Collections.unmodifiableSet(this.roles);
        }

        @Override
        public Set<String> getRoleNames() {
            return this.getRoles().stream().map(r -> r.getName()).collect(Collectors.toSet());
        }

        @Override
        public SgRoles filter(Set<String> keep) {
            SgRoles retVal = new SgRoles(this.roles.size());
            for (SgRole sgr : this.roles) {
                if (!keep.contains(sgr.getName())) continue;
                retVal.addSgRole(sgr);
            }
            return retVal;
        }

        @Override
        public Map<String, Set<String>> getMaskedFields(User user, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashMap<String, Set<String>> maskedFieldsMap = new HashMap<String, Set<String>>();
            for (SgRole sgr : this.roles) {
                for (IndexPattern ip : sgr.getIpatterns()) {
                    Set<String> maskedFields = ip.getMaskedFields();
                    String indexPattern = ip.getUnresolvedIndexPattern(user);
                    String[] concreteIndices = new String[]{};
                    if (maskedFields != null && maskedFields.size() > 0) {
                        concreteIndices = ip.getResolvedIndexPattern(user, resolver, cs);
                    }
                    if (maskedFields == null || maskedFields.size() <= 0) continue;
                    if (maskedFieldsMap.containsKey(indexPattern)) {
                        ((Set)maskedFieldsMap.get(indexPattern)).addAll(Sets.newHashSet(maskedFields));
                    } else {
                        maskedFieldsMap.put(indexPattern, new HashSet());
                        ((Set)maskedFieldsMap.get(indexPattern)).addAll(Sets.newHashSet(maskedFields));
                    }
                    for (int i = 0; i < concreteIndices.length; ++i) {
                        String ci = concreteIndices[i];
                        if (maskedFieldsMap.containsKey(ci)) {
                            ((Set)maskedFieldsMap.get(ci)).addAll(Sets.newHashSet(maskedFields));
                            continue;
                        }
                        maskedFieldsMap.put(ci, new HashSet());
                        ((Set)maskedFieldsMap.get(ci)).addAll(Sets.newHashSet(maskedFields));
                    }
                }
            }
            return maskedFieldsMap;
        }

        @Override
        public Tuple<Map<String, Set<String>>, Map<String, Set<String>>> getDlsFls(User user, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashMap dlsQueries = new HashMap();
            HashMap flsFields = new HashMap();
            for (SgRole sgr : this.roles) {
                for (IndexPattern ip : sgr.getIpatterns()) {
                    String ci;
                    int i;
                    Set<String> fls = ip.getFls();
                    String dls = ip.getDlsQuery(user);
                    String indexPattern = ip.getUnresolvedIndexPattern(user);
                    String[] concreteIndices = new String[]{};
                    if (dls != null && dls.length() > 0 || fls != null && fls.size() > 0) {
                        concreteIndices = ip.getResolvedIndexPattern(user, resolver, cs);
                    }
                    if (dls != null && dls.length() > 0) {
                        if (dlsQueries.containsKey(indexPattern)) {
                            ((Set)dlsQueries.get(indexPattern)).add(dls);
                        } else {
                            dlsQueries.put(indexPattern, new HashSet());
                            ((Set)dlsQueries.get(indexPattern)).add(dls);
                        }
                        for (i = 0; i < concreteIndices.length; ++i) {
                            ci = concreteIndices[i];
                            if (dlsQueries.containsKey(ci)) {
                                ((Set)dlsQueries.get(ci)).add(dls);
                                continue;
                            }
                            dlsQueries.put(ci, new HashSet());
                            ((Set)dlsQueries.get(ci)).add(dls);
                        }
                    }
                    if (fls == null || fls.size() <= 0) continue;
                    if (flsFields.containsKey(indexPattern)) {
                        ((Set)flsFields.get(indexPattern)).addAll(Sets.newHashSet(fls));
                    } else {
                        flsFields.put(indexPattern, new HashSet());
                        ((Set)flsFields.get(indexPattern)).addAll(Sets.newHashSet(fls));
                    }
                    for (i = 0; i < concreteIndices.length; ++i) {
                        ci = concreteIndices[i];
                        if (flsFields.containsKey(ci)) {
                            ((Set)flsFields.get(ci)).addAll(Sets.newHashSet(fls));
                            continue;
                        }
                        flsFields.put(ci, new HashSet());
                        ((Set)flsFields.get(ci)).addAll(Sets.newHashSet(fls));
                    }
                }
            }
            return new Tuple(dlsQueries, flsFields);
        }

        @Override
        public Set<String> getAllPermittedIndicesForKibana(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet<String> retVal = new HashSet<String>();
            for (SgRole sgr : this.roles) {
                retVal.addAll(sgr.getAllResolvedPermittedIndices(IndexResolverReplacer.Resolved._LOCAL_ALL, user, actions, resolver, cs));
                retVal.addAll(resolved.getRemoteIndices());
            }
            return Collections.unmodifiableSet(retVal);
        }

        @Override
        public Set<String> reduce(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet retVal = new HashSet();
            for (SgRole sgr : this.roles) {
                retVal.addAll(sgr.getAllResolvedPermittedIndices(resolved, user, actions, resolver, cs));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reduced requested resolved indices {} to permitted indices {}.", (Object)resolved, (Object)((Object)retVal).toString());
            }
            return Collections.unmodifiableSet(retVal);
        }

        @Override
        public boolean get(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            for (SgRole sgr : this.roles) {
                if (!ConfigModelV7.impliesTypePerm(sgr.getIpatterns(), resolved, user, actions, resolver, cs)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean impliesClusterPermissionPermission(String action) {
            return this.roles.stream().filter((? super T r) -> ((SgRole)r).impliesClusterPermission(action)).count() > 0L;
        }

        @Override
        public boolean impliesTypePermGlobal(IndexResolverReplacer.Resolved resolved, User user, String[] actions, IndexNameExpressionResolver resolver, ClusterService cs) {
            HashSet ipatterns = new HashSet();
            this.roles.stream().forEach(p -> ipatterns.addAll(p.getIpatterns()));
            return ConfigModelV7.impliesTypePerm(ipatterns, resolved, user, actions, resolver, cs);
        }
    }

    private static interface ActionGroupResolver {
        public Set<String> resolvedActions(List<String> var1);
    }
}

