/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgconf;

import com.fasterxml.jackson.databind.JsonNode;
import com.floragunn.searchguard.DefaultObjectMapper;
import com.floragunn.searchguard.auth.internal.InternalAuthenticationBackend;
import com.floragunn.searchguard.configuration.ClusterInfoHolder;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.StaticResourceException;
import com.floragunn.searchguard.sgconf.ConfigModel;
import com.floragunn.searchguard.sgconf.ConfigModelV6;
import com.floragunn.searchguard.sgconf.ConfigModelV7;
import com.floragunn.searchguard.sgconf.DynamicConfigModel;
import com.floragunn.searchguard.sgconf.DynamicConfigModelV6;
import com.floragunn.searchguard.sgconf.DynamicConfigModelV7;
import com.floragunn.searchguard.sgconf.Initializable;
import com.floragunn.searchguard.sgconf.InternalUsersModel;
import com.floragunn.searchguard.sgconf.impl.CType;
import com.floragunn.searchguard.sgconf.impl.SgDynamicConfiguration;
import com.floragunn.searchguard.sgconf.impl.v6.ActionGroupsV6;
import com.floragunn.searchguard.sgconf.impl.v6.ConfigV6;
import com.floragunn.searchguard.sgconf.impl.v6.InternalUserV6;
import com.floragunn.searchguard.sgconf.impl.v6.RoleMappingsV6;
import com.floragunn.searchguard.sgconf.impl.v6.RoleV6;
import com.floragunn.searchguard.sgconf.impl.v7.ActionGroupsV7;
import com.floragunn.searchguard.sgconf.impl.v7.ConfigV7;
import com.floragunn.searchguard.sgconf.impl.v7.InternalUserV7;
import com.floragunn.searchguard.sgconf.impl.v7.RoleV7;
import com.floragunn.searchguard.sgconf.impl.v7.TenantV7;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;

public class DynamicConfigFactory
implements Initializable,
ConfigurationChangeListener {
    private static SgDynamicConfiguration<RoleV7> staticRoles = SgDynamicConfiguration.empty();
    private static SgDynamicConfiguration<ActionGroupsV7> staticActionGroups = SgDynamicConfiguration.empty();
    private static SgDynamicConfiguration<TenantV7> staticTenants = SgDynamicConfiguration.empty();
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ConfigurationRepository cr;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final List<DCFListener> listeners = new ArrayList<DCFListener>();
    private final Settings esSettings;
    private final Path configPath;
    private final InternalAuthenticationBackend iab = new InternalAuthenticationBackend();
    SgDynamicConfiguration<?> config;

    static void resetStatics() {
        staticRoles = SgDynamicConfiguration.empty();
        staticActionGroups = SgDynamicConfiguration.empty();
        staticTenants = SgDynamicConfiguration.empty();
    }

    private void loadStaticConfig() throws IOException {
        JsonNode staticRolesJsonNode = DefaultObjectMapper.YAML_MAPPER.readTree(DynamicConfigFactory.class.getResourceAsStream("/static_config/static_roles.yml"));
        staticRoles = SgDynamicConfiguration.fromNode(staticRolesJsonNode, CType.ROLES, 2, 0L, 0L);
        JsonNode staticActionGroupsJsonNode = DefaultObjectMapper.YAML_MAPPER.readTree(DynamicConfigFactory.class.getResourceAsStream("/static_config/static_action_groups.yml"));
        staticActionGroups = SgDynamicConfiguration.fromNode(staticActionGroupsJsonNode, CType.ACTIONGROUPS, 2, 0L, 0L);
        JsonNode staticTenantsJsonNode = DefaultObjectMapper.YAML_MAPPER.readTree(DynamicConfigFactory.class.getResourceAsStream("/static_config/static_tenants.yml"));
        staticTenants = SgDynamicConfiguration.fromNode(staticTenantsJsonNode, CType.TENANTS, 2, 0L, 0L);
    }

    public static final SgDynamicConfiguration<?> addStatics(SgDynamicConfiguration<?> original) {
        if (original.getCType() == CType.ACTIONGROUPS && !staticActionGroups.getCEntries().isEmpty()) {
            original.add(staticActionGroups.deepClone());
        }
        if (original.getCType() == CType.ROLES && !staticRoles.getCEntries().isEmpty()) {
            original.add(staticRoles.deepClone());
        }
        if (original.getCType() == CType.TENANTS && !staticTenants.getCEntries().isEmpty()) {
            original.add(staticTenants.deepClone());
        }
        return original;
    }

    public DynamicConfigFactory(ConfigurationRepository cr, Settings esSettings, Path configPath, Client client, ThreadPool threadPool, ClusterInfoHolder cih) {
        this.cr = cr;
        this.esSettings = esSettings;
        this.configPath = configPath;
        if (esSettings.getAsBoolean("searchguard.unsupported.load_static_resources", Boolean.valueOf(true)).booleanValue()) {
            try {
                this.loadStaticConfig();
            }
            catch (IOException e) {
                throw new StaticResourceException("Unable to load static resources due to " + e, e, new Object[0]);
            }
        } else {
            this.log.info("Static resources will not be loaded.");
        }
        this.registerDCFListener(this.iab);
        this.cr.subscribeOnChange(this);
    }

    @Override
    public void onChange(Map<CType, SgDynamicConfiguration<?>> typeToConfig) {
        SgDynamicConfiguration<ActionGroupsV6> actionGroups = this.cr.getConfiguration(CType.ACTIONGROUPS);
        this.config = this.cr.getConfiguration(CType.CONFIG);
        SgDynamicConfiguration<InternalUserV6> internalusers = this.cr.getConfiguration(CType.INTERNALUSERS);
        SgDynamicConfiguration<RoleV6> roles = this.cr.getConfiguration(CType.ROLES);
        SgDynamicConfiguration<RoleMappingsV6> rolesmapping = this.cr.getConfiguration(CType.ROLESMAPPING);
        SgDynamicConfiguration<TenantV7> tenants = this.cr.getConfiguration(CType.TENANTS);
        if (this.log.isDebugEnabled()) {
            String logmsg = "current config (because of " + typeToConfig.keySet() + ")\n actionGroups: " + actionGroups.getImplementingClass() + " with " + actionGroups.getCEntries().size() + " entries\n config: " + this.config.getImplementingClass() + " with " + this.config.getCEntries().size() + " entries\n internalusers: " + internalusers.getImplementingClass() + " with " + internalusers.getCEntries().size() + " entries\n roles: " + roles.getImplementingClass() + " with " + roles.getCEntries().size() + " entries\n rolesmapping: " + rolesmapping.getImplementingClass() + " with " + rolesmapping.getCEntries().size() + " entries\n tenants: " + tenants.getImplementingClass() + " with " + tenants.getCEntries().size() + " entries";
            this.log.debug(logmsg);
        }
        if (this.config.getImplementingClass() == ConfigV7.class) {
            if (roles.containsAny(staticRoles)) {
                throw new StaticResourceException("Cannot override static roles", new Object[0]);
            }
            if (!roles.add(staticRoles) && !staticRoles.getCEntries().isEmpty()) {
                throw new StaticResourceException("Unable to load static roles", new Object[0]);
            }
            this.log.debug("Static roles loaded ({})", (Object)staticRoles.getCEntries().size());
            if (actionGroups.containsAny(staticActionGroups)) {
                throw new StaticResourceException("Cannot override static action groups", new Object[0]);
            }
            if (!actionGroups.add(staticActionGroups) && !staticActionGroups.getCEntries().isEmpty()) {
                throw new StaticResourceException("Unable to load static action groups", new Object[0]);
            }
            this.log.debug("Static action groups loaded ({})", (Object)staticActionGroups.getCEntries().size());
            if (tenants.containsAny(staticTenants)) {
                throw new StaticResourceException("Cannot override static tenants", new Object[0]);
            }
            if (!tenants.add(staticTenants) && !staticTenants.getCEntries().isEmpty()) {
                throw new StaticResourceException("Unable to load static tenants", new Object[0]);
            }
            this.log.debug("Static tenants loaded ({})", (Object)staticTenants.getCEntries().size());
            this.log.debug("Static configuration loaded (total roles: {}/total action groups: {}/total tenants: {})", (Object)roles.getCEntries().size(), (Object)actionGroups.getCEntries().size(), (Object)tenants.getCEntries().size());
            DynamicConfigModelV7 dcm = new DynamicConfigModelV7(DynamicConfigFactory.getConfigV7(this.config), this.esSettings, this.configPath, this.iab);
            InternalUsersModelV7 ium = new InternalUsersModelV7(internalusers);
            ConfigModelV7 cm = new ConfigModelV7(roles, rolesmapping, actionGroups, tenants, dcm, this.esSettings);
            for (DCFListener listener : this.listeners) {
                listener.onChanged(cm, dcm, ium);
            }
        } else {
            DynamicConfigModelV6 dcmv6 = new DynamicConfigModelV6(DynamicConfigFactory.getConfigV6(this.config), this.esSettings, this.configPath, this.iab);
            InternalUsersModelV6 iumv6 = new InternalUsersModelV6(internalusers);
            ConfigModelV6 cmv6 = new ConfigModelV6(roles, actionGroups, rolesmapping, dcmv6, this.esSettings);
            for (DCFListener listener : this.listeners) {
                listener.onChanged(cmv6, dcmv6, iumv6);
            }
        }
        this.initialized.set(true);
    }

    public String getLicenseString() {
        if (!this.isInitialized()) {
            throw new RuntimeException("Can not retrieve license because not initialized (yet)");
        }
        if (this.config.getImplementingClass() == ConfigV6.class) {
            SgDynamicConfiguration<?> c = this.config;
            return ((ConfigV6)c.getCEntry((String)"searchguard")).dynamic.license;
        }
        SgDynamicConfiguration<?> c = this.config;
        return ((ConfigV7)c.getCEntry((String)"sg_config")).dynamic.license;
    }

    private static ConfigV6 getConfigV6(SgDynamicConfiguration<?> sdc) {
        SgDynamicConfiguration<?> c = sdc;
        return (ConfigV6)c.getCEntry("searchguard");
    }

    private static ConfigV7 getConfigV7(SgDynamicConfiguration<?> sdc) {
        SgDynamicConfiguration<?> c = sdc;
        return (ConfigV7)c.getCEntry("sg_config");
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized.get();
    }

    public void registerDCFListener(DCFListener listener) {
        this.listeners.add(listener);
    }

    private static class InternalUsersModelV6
    extends InternalUsersModel {
        SgDynamicConfiguration<InternalUserV6> configuration;

        public InternalUsersModelV6(SgDynamicConfiguration<InternalUserV6> configuration) {
            this.configuration = configuration;
        }

        @Override
        public boolean exists(String user) {
            return this.configuration.exists(user);
        }

        @Override
        public List<String> getBackenRoles(String user) {
            InternalUserV6 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getRoles();
        }

        @Override
        public Map<String, String> getAttributes(String user) {
            InternalUserV6 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getAttributes();
        }

        @Override
        public String getDescription(String user) {
            return null;
        }

        @Override
        public String getHash(String user) {
            InternalUserV6 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getHash();
        }

        @Override
        public List<String> getSearchGuardRoles(String user) {
            return Collections.emptyList();
        }
    }

    private static class InternalUsersModelV7
    extends InternalUsersModel {
        SgDynamicConfiguration<InternalUserV7> configuration;

        public InternalUsersModelV7(SgDynamicConfiguration<InternalUserV7> configuration) {
            this.configuration = configuration;
        }

        @Override
        public boolean exists(String user) {
            return this.configuration.exists(user);
        }

        @Override
        public List<String> getBackenRoles(String user) {
            InternalUserV7 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getBackend_roles();
        }

        @Override
        public Map<String, String> getAttributes(String user) {
            InternalUserV7 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getAttributes();
        }

        @Override
        public String getDescription(String user) {
            InternalUserV7 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getDescription();
        }

        @Override
        public String getHash(String user) {
            InternalUserV7 tmp = this.configuration.getCEntry(user);
            return tmp == null ? null : tmp.getHash();
        }

        @Override
        public List<String> getSearchGuardRoles(String user) {
            InternalUserV7 tmp = this.configuration.getCEntry(user);
            return tmp == null ? Collections.emptyList() : tmp.getSearch_guard_roles();
        }
    }

    public static interface DCFListener {
        public void onChanged(ConfigModel var1, DynamicConfigModel var2, InternalUsersModel var3);
    }
}

