/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgconf.impl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.floragunn.searchguard.DefaultObjectMapper;
import com.floragunn.searchguard.sgconf.Hashed;
import com.floragunn.searchguard.sgconf.Hideable;
import com.floragunn.searchguard.sgconf.StaticDefinable;
import com.floragunn.searchguard.sgconf.impl.CType;
import com.floragunn.searchguard.sgconf.impl.Meta;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public class SgDynamicConfiguration<T>
implements ToXContent {
    private static final TypeReference<HashMap<String, Object>> typeRefMSO = new TypeReference<HashMap<String, Object>>(){};
    @JsonIgnore
    private final Map<String, T> centries = new HashMap<String, T>();
    private long seqNo = -1L;
    private long primaryTerm = -1L;
    private CType ctype;
    private int version = -1;
    private Meta _sg_meta;

    public static <T> SgDynamicConfiguration<T> empty() {
        return new SgDynamicConfiguration<T>();
    }

    public static <T> SgDynamicConfiguration<T> fromJson(String json, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        SgDynamicConfiguration sdc = null;
        if (ctype != null) {
            Class<?> implementationClass = ctype.getImplementationClass().get(version);
            if (implementationClass == null) {
                throw new IllegalArgumentException("No implementation class found for " + (Object)((Object)ctype) + " and config version " + version);
            }
            sdc = (SgDynamicConfiguration)DefaultObjectMapper.readValue(json, DefaultObjectMapper.getTypeFactory().constructParametricType(SgDynamicConfiguration.class, new Class[]{implementationClass}));
            SgDynamicConfiguration.validate(sdc, version, ctype);
        } else {
            sdc = new SgDynamicConfiguration();
        }
        sdc.ctype = ctype;
        sdc.seqNo = seqNo;
        sdc.primaryTerm = primaryTerm;
        sdc.version = version;
        return sdc;
    }

    public static void validate(SgDynamicConfiguration sdc, int version, CType ctype) throws IOException {
        if (version < 2 && sdc.get_sg_meta() != null) {
            throw new IOException("A version of " + version + " can not have a _sg_meta key for " + (Object)((Object)ctype));
        }
        if (version >= 2 && sdc.get_sg_meta() == null) {
            throw new IOException("A version of " + version + " must have a _sg_meta key for " + (Object)((Object)ctype));
        }
        if (!(version >= 2 || ctype != CType.CONFIG || sdc.getCEntries().size() == 1 && sdc.getCEntries().keySet().contains("searchguard"))) {
            throw new IOException("A version of " + version + " must have a single toplevel key named 'searchguard' for " + (Object)((Object)ctype));
        }
        if (!(version < 2 || ctype != CType.CONFIG || sdc.getCEntries().size() == 1 && sdc.getCEntries().keySet().contains("sg_config"))) {
            throw new IOException("A version of " + version + " must have a single toplevel key named 'sg_config' for " + (Object)((Object)ctype));
        }
    }

    public static <T> SgDynamicConfiguration<T> fromNode(JsonNode json, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return SgDynamicConfiguration.fromJson(DefaultObjectMapper.writeValueAsString(json, false), ctype, version, seqNo, primaryTerm);
    }

    private SgDynamicConfiguration() {
    }

    public Meta get_sg_meta() {
        return this._sg_meta;
    }

    public void set_sg_meta(Meta _sg_meta) {
        this._sg_meta = _sg_meta;
    }

    @JsonAnySetter
    void setCEntries(String key, T value) {
        this.putCEntry(key, value);
    }

    @JsonAnyGetter
    public Map<String, T> getCEntries() {
        return this.centries;
    }

    @JsonIgnore
    public void removeHidden() {
        for (Map.Entry<String, T> entry : new HashMap<String, T>(this.centries).entrySet()) {
            if (!(entry.getValue() instanceof Hideable) || !((Hideable)entry.getValue()).isHidden()) continue;
            this.centries.remove(entry.getKey());
        }
    }

    @JsonIgnore
    public void removeStatic() {
        for (Map.Entry<String, T> entry : new HashMap<String, T>(this.centries).entrySet()) {
            if (!(entry.getValue() instanceof StaticDefinable) || !((StaticDefinable)entry.getValue()).isStatic()) continue;
            this.centries.remove(entry.getKey());
        }
    }

    @JsonIgnore
    public void clearHashes() {
        for (Map.Entry<String, T> entry : this.centries.entrySet()) {
            if (!(entry.getValue() instanceof Hashed)) continue;
            ((Hashed)entry.getValue()).clearHash();
        }
    }

    public void removeOthers(String key) {
        T tmp = this.centries.get(key);
        this.centries.clear();
        this.centries.put(key, tmp);
    }

    @JsonIgnore
    public T putCEntry(String key, T value) {
        return this.centries.put(key, value);
    }

    @JsonIgnore
    public void putCObject(String key, Object value) {
        this.centries.put(key, value);
    }

    @JsonIgnore
    public T getCEntry(String key) {
        return this.centries.get(key);
    }

    @JsonIgnore
    public boolean exists(String key) {
        return this.centries.containsKey(key);
    }

    @JsonIgnore
    public BytesReference toBytesReference() throws IOException {
        return XContentHelper.toXContent((ToXContent)this, (XContentType)XContentType.JSON, (boolean)false);
    }

    public String toString() {
        return "SgDynamicConfiguration [seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", ctype=" + (Object)((Object)this.ctype) + ", version=" + this.version + ", centries=" + this.centries + ", getImplementingClass()=" + this.getImplementingClass() + "]";
    }

    @JsonIgnore
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean omitDefaults = params != null && params.paramAsBoolean("omit_defaults", false);
        return builder.map((Map)DefaultObjectMapper.readValue(DefaultObjectMapper.writeValueAsString(this, omitDefaults), typeRefMSO));
    }

    @JsonIgnore
    public boolean isFragment() {
        return false;
    }

    @JsonIgnore
    public long getSeqNo() {
        return this.seqNo;
    }

    @JsonIgnore
    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @JsonIgnore
    public CType getCType() {
        return this.ctype;
    }

    @JsonIgnore
    public void setCType(CType ctype) {
        this.ctype = ctype;
    }

    @JsonIgnore
    public int getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Class<?> getImplementingClass() {
        return this.ctype == null ? null : this.ctype.getImplementationClass().get(this.getVersion());
    }

    @JsonIgnore
    public SgDynamicConfiguration<T> deepClone() {
        try {
            return SgDynamicConfiguration.fromJson(DefaultObjectMapper.writeValueAsString(this, false), this.ctype, this.version, this.seqNo, this.primaryTerm);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    @JsonIgnore
    public void remove(String key) {
        this.centries.remove(key);
    }

    public boolean add(SgDynamicConfiguration other) {
        if (other.ctype == null || !other.ctype.equals((Object)this.ctype)) {
            return false;
        }
        if (other.getImplementingClass() == null || !other.getImplementingClass().equals(this.getImplementingClass())) {
            return false;
        }
        if (other.version != this.version) {
            return false;
        }
        this.centries.putAll(other.centries);
        return true;
    }

    @JsonIgnore
    public boolean containsAny(SgDynamicConfiguration other) {
        return !Collections.disjoint(this.centries.keySet(), other.centries.keySet());
    }
}

