/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.http.netty;

import com.floragunn.searchguard.ssl.SslExceptionHandler;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import java.nio.file.Path;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class ValidatingDispatcher
implements HttpServerTransport.Dispatcher {
    private static final Logger logger = LogManager.getLogger(ValidatingDispatcher.class);
    private final ThreadContext threadContext;
    private final HttpServerTransport.Dispatcher originalDispatcher;
    private final SslExceptionHandler errorHandler;
    private final Settings settings;
    private final Path configPath;

    public ValidatingDispatcher(ThreadContext threadContext, HttpServerTransport.Dispatcher originalDispatcher, Settings settings, Path configPath, SslExceptionHandler errorHandler) {
        this.threadContext = threadContext;
        this.originalDispatcher = originalDispatcher;
        this.settings = settings;
        this.configPath = configPath;
        this.errorHandler = errorHandler;
    }

    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        this.checkRequest(request, channel);
        this.originalDispatcher.dispatchRequest(request, channel, threadContext);
    }

    public void dispatchBadRequest(RestRequest request, RestChannel channel, ThreadContext threadContext, Throwable cause) {
        this.checkRequest(request, channel);
        this.originalDispatcher.dispatchBadRequest(request, channel, threadContext, cause);
    }

    protected void checkRequest(RestRequest request, RestChannel channel) {
        if (SSLRequestHelper.containsBadHeader(this.threadContext, "_sg_ssl_")) {
            ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
            this.errorHandler.logError((Throwable)exception, request, 1);
            throw exception;
        }
        try {
            if (SSLRequestHelper.getSSLInfo(this.settings, this.configPath, request, null) == null) {
                logger.error("Not an SSL request");
                throw new ElasticsearchSecurityException("Not an SSL request", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
        }
        catch (SSLPeerUnverifiedException e) {
            logger.error("No client certificates found but such are needed (SG 8).");
            this.errorHandler.logError(e, request, 0);
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }
}

