/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.floragunn.searchguard.DefaultObjectMapper;
import com.floragunn.searchguard.sgconf.impl.CType;
import com.floragunn.searchguard.sgconf.impl.SgDynamicConfiguration;
import com.floragunn.searchguard.support.SearchGuardDeprecationHandler;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class ConfigHelper {
    private static final Logger LOGGER = LogManager.getLogger(ConfigHelper.class);

    public static void uploadFile(Client tc, String filepath, String index, CType cType, int configVersion) throws Exception {
        LOGGER.info("Will update '" + (Object)((Object)cType) + "' with " + filepath);
        ConfigHelper.fromYamlFile(filepath, cType, configVersion, 0L, 0L);
        try (FileReader reader = new FileReader(filepath);){
            String res = ((IndexResponse)tc.index(((IndexRequest)new IndexRequest(index).type(configVersion == 1 ? "sg" : "_doc").id(cType.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{cType.toLCString(), ConfigHelper.readXContent(reader, XContentType.YAML)})).actionGet()).getId();
            if (!cType.toLCString().equals(res)) {
                throw new Exception("   FAIL: Configuration for '" + cType.toLCString() + "' failed for unknown reasons. Pls. consult logfile of elasticsearch");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BytesReference readXContent(Reader reader, XContentType xContentType) throws IOException {
        BytesReference retVal;
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)xContentType).createParser(NamedXContentRegistry.EMPTY, SearchGuardDeprecationHandler.INSTANCE, reader);
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            retVal = BytesReference.bytes((XContentBuilder)builder);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> SgDynamicConfiguration<T> fromYamlReader(Reader yamlReader, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        try {
            SgDynamicConfiguration sgDynamicConfiguration = SgDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(yamlReader), ctype, version, seqNo, primaryTerm);
            return sgDynamicConfiguration;
        }
        finally {
            if (yamlReader != null) {
                yamlReader.close();
            }
        }
    }

    public static <T> SgDynamicConfiguration<T> fromYamlFile(String filepath, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return ConfigHelper.fromYamlReader(new FileReader(filepath), ctype, version, seqNo, primaryTerm);
    }

    public static <T> SgDynamicConfiguration<T> fromYamlString(String yamlString, CType ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return ConfigHelper.fromYamlReader(new StringReader(yamlString), ctype, version, seqNo, primaryTerm);
    }
}

