/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auditlog.NullAuditLog;
import com.floragunn.searchguard.compliance.ComplianceConfig;
import com.floragunn.searchguard.compliance.ComplianceIndexingOperationListener;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.DlsFlsRequestValve;
import com.floragunn.searchguard.privileges.PrivilegesEvaluator;
import com.floragunn.searchguard.privileges.PrivilegesInterceptor;
import com.floragunn.searchguard.ssl.transport.DefaultPrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.support.ModuleInfo;
import com.floragunn.searchguard.support.ModuleType;
import com.floragunn.searchguard.transport.DefaultInterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.InterClusterRequestEvaluator;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ThreadPool;

public class ReflectionHelper {
    protected static final Logger log = LogManager.getLogger(ReflectionHelper.class);
    private static Set<ModuleInfo> modulesLoaded = new HashSet<ModuleInfo>();
    private static boolean enterpriseModulesEnabled;

    public static Set<ModuleInfo> getModulesLoaded() {
        return Collections.unmodifiableSet(modulesLoaded);
    }

    private static boolean enterpriseModulesDisabled() {
        return !enterpriseModulesEnabled;
    }

    public static void registerMngtRestApiHandler(Settings settings) {
        block4: {
            if (ReflectionHelper.enterpriseModulesDisabled()) {
                return;
            }
            if (!settings.getAsBoolean("http.enabled", Boolean.valueOf(true)).booleanValue()) {
                try {
                    Class<?> clazz = Class.forName("com.floragunn.searchguard.dlic.rest.api.SearchGuardRestApiActions");
                    ReflectionHelper.addLoadedModule(clazz);
                }
                catch (Throwable e) {
                    log.warn("Unable to register Rest Management Api Module due to {}", (Object)e.toString());
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Stacktrace: ", e);
                }
            }
        }
    }

    public static Collection<RestHandler> instantiateMngtRestApiHandler(Settings settings, Path configPath, RestController restController, Client localClient, AdminDNs adminDns, ConfigurationRepository cr, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditlog) {
        if (ReflectionHelper.enterpriseModulesDisabled()) {
            return Collections.emptyList();
        }
        try {
            Class<?> clazz = Class.forName("com.floragunn.searchguard.dlic.rest.api.SearchGuardRestApiActions");
            Collection ret = (Collection)clazz.getDeclaredMethod("getHandler", Settings.class, Path.class, RestController.class, Client.class, AdminDNs.class, ConfigurationRepository.class, ClusterService.class, PrincipalExtractor.class, PrivilegesEvaluator.class, ThreadPool.class, AuditLog.class).invoke(null, settings, configPath, restController, localClient, adminDns, cr, cs, principalExtractor, evaluator, threadPool, auditlog);
            ReflectionHelper.addLoadedModule(clazz);
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to enable Rest Management Api Module due to {}", (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return Collections.emptyList();
        }
    }

    public static Constructor instantiateDlsFlsConstructor() {
        if (ReflectionHelper.enterpriseModulesDisabled()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("com.floragunn.searchguard.configuration.SearchGuardFlsDlsIndexSearcherWrapper");
            Constructor<?> ret = clazz.getConstructor(IndexService.class, Settings.class, AdminDNs.class, ClusterService.class, AuditLog.class, ComplianceIndexingOperationListener.class, ComplianceConfig.class);
            ReflectionHelper.addLoadedModule(clazz);
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to enable DLS/FLS Module due to {}", (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return null;
        }
    }

    public static DlsFlsRequestValve instantiateDlsFlsValve() {
        if (ReflectionHelper.enterpriseModulesDisabled()) {
            return new DlsFlsRequestValve.NoopDlsFlsRequestValve();
        }
        try {
            Class<?> clazz = Class.forName("com.floragunn.searchguard.configuration.DlsFlsValveImpl");
            DlsFlsRequestValve ret = (DlsFlsRequestValve)clazz.newInstance();
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to enable DLS/FLS Valve Module due to {}", (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return new DlsFlsRequestValve.NoopDlsFlsRequestValve();
        }
    }

    public static AuditLog instantiateAuditLog(Settings settings, Path configPath, Client localClient, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService) {
        if (ReflectionHelper.enterpriseModulesDisabled()) {
            return new NullAuditLog();
        }
        try {
            Class<?> clazz = Class.forName("com.floragunn.searchguard.auditlog.impl.AuditLogImpl");
            AuditLog impl = (AuditLog)clazz.getConstructor(Settings.class, Path.class, Client.class, ThreadPool.class, IndexNameExpressionResolver.class, ClusterService.class).newInstance(settings, configPath, localClient, threadPool, resolver, clusterService);
            ReflectionHelper.addLoadedModule(clazz);
            return impl;
        }
        catch (Throwable e) {
            log.warn("Unable to enable Auditlog Module due to {}", (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return new NullAuditLog();
        }
    }

    public static ComplianceIndexingOperationListener instantiateComplianceListener(ComplianceConfig complianceConfig, AuditLog auditlog) {
        if (ReflectionHelper.enterpriseModulesDisabled()) {
            return new ComplianceIndexingOperationListener();
        }
        try {
            Class<?> clazz = Class.forName("com.floragunn.searchguard.compliance.ComplianceIndexingOperationListenerImpl");
            ComplianceIndexingOperationListener impl = (ComplianceIndexingOperationListener)clazz.getConstructor(ComplianceConfig.class, AuditLog.class).newInstance(complianceConfig, auditlog);
            return impl;
        }
        catch (ClassNotFoundException e) {
            log.debug("Unable to enable Compliance Module due to {}", (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", (Throwable)e);
            }
            return new ComplianceIndexingOperationListener();
        }
        catch (Throwable e) {
            log.error("Unable to enable Compliance Module due to {}", (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return new ComplianceIndexingOperationListener();
        }
    }

    public static PrivilegesInterceptor instantiatePrivilegesInterceptorImpl(IndexNameExpressionResolver resolver, ClusterService clusterService, Client localClient, ThreadPool threadPool) {
        PrivilegesInterceptor noop = new PrivilegesInterceptor(resolver, clusterService, localClient, threadPool);
        if (ReflectionHelper.enterpriseModulesDisabled()) {
            return noop;
        }
        try {
            Class<?> clazz = Class.forName("com.floragunn.searchguard.configuration.PrivilegesInterceptorImpl");
            PrivilegesInterceptor ret = (PrivilegesInterceptor)clazz.getConstructor(IndexNameExpressionResolver.class, ClusterService.class, Client.class, ThreadPool.class).newInstance(resolver, clusterService, localClient, threadPool);
            ReflectionHelper.addLoadedModule(clazz);
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to enable Kibana Module due to {}", (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return noop;
        }
    }

    public static <T> T instantiateAAA(String clazz, Settings settings, Path configPath, boolean checkEnterprise) {
        if (checkEnterprise && ReflectionHelper.enterpriseModulesDisabled()) {
            throw new ElasticsearchException("Can not load '{}' because enterprise modules are disabled", new Object[]{clazz});
        }
        try {
            Class<?> clazz0 = Class.forName(clazz);
            Object ret = clazz0.getConstructor(Settings.class, Path.class).newInstance(settings, configPath);
            ReflectionHelper.addLoadedModule(clazz0);
            return (T)ret;
        }
        catch (Throwable e) {
            log.warn("Unable to enable '{}' due to {}", (Object)clazz, (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            throw new ElasticsearchException(e);
        }
    }

    public static InterClusterRequestEvaluator instantiateInterClusterRequestEvaluator(String clazz, Settings settings) {
        try {
            Class<?> clazz0 = Class.forName(clazz);
            InterClusterRequestEvaluator ret = (InterClusterRequestEvaluator)clazz0.getConstructor(Settings.class).newInstance(settings);
            ReflectionHelper.addLoadedModule(clazz0);
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to load inter cluster request evaluator '{}' due to {}", (Object)clazz, (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return new DefaultInterClusterRequestEvaluator(settings);
        }
    }

    public static PrincipalExtractor instantiatePrincipalExtractor(String clazz) {
        try {
            Class<?> clazz0 = Class.forName(clazz);
            PrincipalExtractor ret = (PrincipalExtractor)clazz0.newInstance();
            ReflectionHelper.addLoadedModule(clazz0);
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to load pricipal extractor '{}' due to {}", (Object)clazz, (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return new DefaultPrincipalExtractor();
        }
    }

    public static boolean isEnterpriseAAAModule(String clazz) {
        boolean enterpriseModuleInstalled = false;
        if (clazz.equalsIgnoreCase("com.floragunn.dlic.auth.ldap.backend.LDAPAuthorizationBackend")) {
            enterpriseModuleInstalled = true;
        }
        if (clazz.equalsIgnoreCase("com.floragunn.dlic.auth.ldap.backend.LDAPAuthenticationBackend")) {
            enterpriseModuleInstalled = true;
        }
        if (clazz.equalsIgnoreCase("com.floragunn.dlic.auth.http.jwt.HTTPJwtAuthenticator")) {
            enterpriseModuleInstalled = true;
        }
        if (clazz.equalsIgnoreCase("com.floragunn.dlic.auth.http.jwt.keybyoidc.HTTPJwtKeyByOpenIdConnectAuthenticator")) {
            enterpriseModuleInstalled = true;
        }
        if (clazz.equalsIgnoreCase("com.floragunn.dlic.auth.http.kerberos.HTTPSpnegoAuthenticator")) {
            enterpriseModuleInstalled = true;
        }
        if (clazz.equalsIgnoreCase("com.floragunn.dlic.auth.http.saml.HTTPSamlAuthenticator")) {
            enterpriseModuleInstalled = true;
        }
        return enterpriseModuleInstalled;
    }

    public static boolean addLoadedModule(Class<?> clazz) {
        ModuleInfo moduleInfo = ReflectionHelper.getModuleInfo(clazz);
        if (log.isDebugEnabled()) {
            log.debug("Loaded module {}", (Object)moduleInfo);
        }
        return modulesLoaded.add(moduleInfo);
    }

    public static void init(boolean enterpriseModulesEnabled) {
        ReflectionHelper.enterpriseModulesEnabled = enterpriseModulesEnabled;
    }

    private static ModuleInfo getModuleInfo(Class<?> impl) {
        ModuleType moduleType = ModuleType.getByDefaultImplClass(impl);
        ModuleInfo moduleInfo = new ModuleInfo(moduleType, impl.getName());
        try {
            String classPath = impl.getResource(impl.getSimpleName() + ".class").toString();
            moduleInfo.setClasspath(classPath);
            if (!classPath.startsWith("jar")) {
                return moduleInfo;
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            try (InputStream stream = new URL(manifestPath).openStream();){
                Manifest manifest = new Manifest(stream);
                Attributes attr = manifest.getMainAttributes();
                moduleInfo.setVersion(attr.getValue("Implementation-Version"));
                moduleInfo.setBuildTime(attr.getValue("Build-Time"));
                moduleInfo.setGitsha1(attr.getValue("git-sha1"));
            }
        }
        catch (Throwable e) {
            log.error("Unable to retrieve module info for " + impl, e);
        }
        return moduleInfo;
    }
}

