/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.floragunn.searchguard.DefaultObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SgJsonNode {
    private final JsonNode node;

    public SgJsonNode(JsonNode node) {
        this.node = node;
    }

    public SgJsonNode get(String name) {
        if (SgJsonNode.isNull(this.node)) {
            return new SgJsonNode(null);
        }
        JsonNode val = this.node.get(name);
        return new SgJsonNode(val);
    }

    public String asString() {
        if (SgJsonNode.isNull(this.node)) {
            return null;
        }
        return this.node.asText(null);
    }

    private static boolean isNull(JsonNode node) {
        return node == null || node.isNull();
    }

    public boolean isNull() {
        return SgJsonNode.isNull(this.node);
    }

    public SgJsonNode get(int i) {
        if (SgJsonNode.isNull(this.node) || this.node.getNodeType() != JsonNodeType.ARRAY || i > this.node.size() - 1) {
            return new SgJsonNode(null);
        }
        return new SgJsonNode(this.node.get(i));
    }

    public SgJsonNode getDotted(String string) {
        SgJsonNode tmp = this;
        for (String part : string.split("\\.")) {
            tmp = tmp.get(part);
        }
        return tmp;
    }

    public List<String> asList() {
        if (SgJsonNode.isNull(this.node) || this.node.getNodeType() != JsonNodeType.ARRAY) {
            return null;
        }
        ArrayList<String> retVal = new ArrayList<String>();
        for (int i = 0; i < this.node.size(); ++i) {
            retVal.add(this.node.get(i).asText());
        }
        return Collections.unmodifiableList(retVal);
    }

    public static SgJsonNode fromJson(String json) throws IOException {
        return new SgJsonNode(DefaultObjectMapper.readTree(json));
    }
}

