/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;

public class WildcardMatcher {
    private static final int NOT_FOUND = -1;

    public static boolean matchAny(String[] pattern, String[] candidate) {
        return WildcardMatcher.matchAny(pattern, candidate, false);
    }

    public static boolean matchAny(Collection<String> pattern, Collection<String> candidate) {
        return WildcardMatcher.matchAny(pattern, candidate, false);
    }

    public static boolean matchAny(String[] pattern, String[] candidate, boolean ignoreCase) {
        for (int i = 0; i < pattern.length; ++i) {
            String string = pattern[i];
            if (!WildcardMatcher.matchAny(string, candidate, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchAny(Collection<String> pattern, String[] candidate, boolean ignoreCase) {
        for (String string : pattern) {
            if (!WildcardMatcher.matchAny(string, candidate, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchAny(Collection<String> pattern, Collection<String> candidate, boolean ignoreCase) {
        for (String string : pattern) {
            if (!WildcardMatcher.matchAny(string, candidate, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchAll(String[] pattern, String[] candidate) {
        for (int i = 0; i < candidate.length; ++i) {
            String string = candidate[i];
            if (WildcardMatcher.matchAny(pattern, string)) continue;
            return false;
        }
        return true;
    }

    public static boolean allPatternsMatched(String[] pattern, String[] candidate) {
        int matchedPatternNum = 0;
        for (int i = 0; i < pattern.length; ++i) {
            String string = pattern[i];
            if (!WildcardMatcher.matchAny(string, candidate)) continue;
            ++matchedPatternNum;
        }
        return matchedPatternNum == pattern.length && pattern.length > 0;
    }

    public static boolean allPatternsMatched(Collection<String> pattern, Collection<String> candidate) {
        int matchedPatternNum = 0;
        for (String string : pattern) {
            if (!WildcardMatcher.matchAny(string, candidate)) continue;
            ++matchedPatternNum;
        }
        return matchedPatternNum == pattern.size() && pattern.size() > 0;
    }

    public static boolean matchAny(String pattern, String[] candidate) {
        return WildcardMatcher.matchAny(pattern, candidate, false);
    }

    public static boolean matchAny(String pattern, Collection<String> candidate) {
        return WildcardMatcher.matchAny(pattern, candidate, false);
    }

    public static boolean matchAny(String pattern, String[] candidate, boolean ignoreCase) {
        for (int i = 0; i < candidate.length; ++i) {
            String string = candidate[i];
            if (!WildcardMatcher.match(pattern, string, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchAny(String pattern, Collection<String> candidates, boolean ignoreCase) {
        for (String candidate : candidates) {
            if (!WildcardMatcher.match(pattern, candidate, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static String[] matches(String pattern, String[] candidate, boolean ignoreCase) {
        ArrayList<String> ret = new ArrayList<String>(candidate.length);
        for (int i = 0; i < candidate.length; ++i) {
            String string = candidate[i];
            if (!WildcardMatcher.match(pattern, string, ignoreCase)) continue;
            ret.add(string);
        }
        return ret.toArray(new String[0]);
    }

    public static List<String> getMatchAny(String pattern, String[] candidate) {
        ArrayList<String> matches = new ArrayList<String>(candidate.length);
        for (int i = 0; i < candidate.length; ++i) {
            String string = candidate[i];
            if (!WildcardMatcher.match(pattern, string)) continue;
            matches.add(string);
        }
        return matches;
    }

    public static List<String> getMatchAny(String[] patterns, String[] candidate) {
        ArrayList<String> matches = new ArrayList<String>(candidate.length);
        for (int i = 0; i < candidate.length; ++i) {
            String string = candidate[i];
            if (!WildcardMatcher.matchAny(patterns, string)) continue;
            matches.add(string);
        }
        return matches;
    }

    public static List<String> getMatchAny(Collection<String> patterns, String[] candidate) {
        ArrayList<String> matches = new ArrayList<String>(candidate.length);
        for (int i = 0; i < candidate.length; ++i) {
            String string = candidate[i];
            if (!WildcardMatcher.matchAny(patterns, string)) continue;
            matches.add(string);
        }
        return matches;
    }

    public static List<String> getMatchAny(Collection<String> patterns, Collection<String> candidates) {
        ArrayList<String> matches = new ArrayList<String>(candidates.size());
        for (String string : candidates) {
            if (!WildcardMatcher.matchAny(patterns, string)) continue;
            matches.add(string);
        }
        return matches;
    }

    public static List<String> getMatchAny(String pattern, Collection<String> candidate) {
        ArrayList<String> matches = new ArrayList<String>(candidate.size());
        for (String string : candidate) {
            if (!WildcardMatcher.match(pattern, string)) continue;
            matches.add(string);
        }
        return matches;
    }

    public static List<String> getMatchAny(String[] patterns, Collection<String> candidate) {
        ArrayList<String> matches = new ArrayList<String>(candidate.size());
        for (String string : candidate) {
            if (!WildcardMatcher.matchAny(patterns, string)) continue;
            matches.add(string);
        }
        return matches;
    }

    public static Optional<String> getFirstMatchingPattern(Collection<String> pattern, String candidate) {
        for (String p : pattern) {
            if (!WildcardMatcher.match(p, candidate)) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    public static List<String> getAllMatchingPatterns(Collection<String> pattern, String candidate) {
        ArrayList<String> matches = new ArrayList<String>(pattern.size());
        for (String p : pattern) {
            if (!WildcardMatcher.match(p, candidate)) continue;
            matches.add(p);
        }
        return matches;
    }

    public static List<String> getAllMatchingPatterns(Collection<String> pattern, Collection<String> candidates) {
        ArrayList<String> matches = new ArrayList<String>(pattern.size());
        for (String c : candidates) {
            matches.addAll(WildcardMatcher.getAllMatchingPatterns(pattern, c));
        }
        return matches;
    }

    public static boolean matchAny(String[] pattern, String candidate) {
        for (int i = 0; i < pattern.length; ++i) {
            String string = pattern[i];
            if (!WildcardMatcher.match(string, candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchAny(Collection<String> pattern, String candidate) {
        for (String string : pattern) {
            if (!WildcardMatcher.match(string, candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(String pattern, String candidate) {
        return WildcardMatcher.match(pattern, candidate, false);
    }

    public static boolean match(String pattern, String candidate, boolean ignoreCase) {
        if (pattern == null || candidate == null) {
            return false;
        }
        if (ignoreCase) {
            pattern = pattern.toLowerCase();
            candidate = candidate.toLowerCase();
        }
        if (pattern.startsWith("/") && pattern.endsWith("/")) {
            return Pattern.matches("^" + pattern.substring(1, pattern.length() - 1) + "$", candidate);
        }
        if (pattern.length() == 1 && pattern.charAt(0) == '*') {
            return true;
        }
        if (pattern.indexOf(63) == -1 && pattern.indexOf(42) == -1) {
            return pattern.equals(candidate);
        }
        return WildcardMatcher.simpleWildcardMatch(pattern, candidate);
    }

    public static boolean containsWildcard(String pattern) {
        return pattern != null && (pattern.indexOf("*") > -1 || pattern.indexOf("?") > -1 || pattern.startsWith("/") && pattern.endsWith("/"));
    }

    public static boolean wildcardRemoveFromSet(Set<String> set, String stringContainingWc) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        if (!WildcardMatcher.containsWildcard(stringContainingWc) && set.contains(stringContainingWc)) {
            return set.remove(stringContainingWc);
        }
        boolean modified = false;
        HashSet<String> copy = new HashSet<String>(set);
        for (String it : copy) {
            if (!WildcardMatcher.match(stringContainingWc, it)) continue;
            modified = set.remove(it) || modified;
        }
        return modified;
    }

    public static boolean wildcardRetainInSet(Set<String> set, String[] setContainingWc) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        boolean modified = false;
        HashSet<String> copy = new HashSet<String>(set);
        for (String it : copy) {
            if (WildcardMatcher.matchAny(setContainingWc, it)) continue;
            modified = set.remove(it) || modified;
        }
        return modified;
    }

    private static boolean simpleWildcardMatch(String pattern, String candidate) {
        if (candidate == null && pattern == null) {
            return true;
        }
        if (candidate == null || pattern == null) {
            return false;
        }
        String[] wcs = WildcardMatcher.splitOnTokens(pattern);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (backtrack.size() > 0) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    if (++textIdx > candidate.length()) break;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = candidate.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = WildcardMatcher.checkIndexOf(candidate, textIdx, wcs[wcsIdx])) == -1) break;
                        int repeat = WildcardMatcher.checkIndexOf(candidate, textIdx + 1, wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!WildcardMatcher.checkRegionMatches(candidate, textIdx, wcs[wcsIdx])) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != candidate.length()) continue;
            return true;
        } while (backtrack.size() > 0);
        return false;
    }

    private static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char prevChar = '\u0000';
        for (char ch : array) {
            if (ch == '?' || ch == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (ch == '?') {
                    list.add("?");
                } else if (prevChar != '*') {
                    list.add("*");
                }
            } else {
                buffer.append(ch);
            }
            prevChar = ch;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    private static int checkIndexOf(String str, int strStartIndex, String search) {
        int endIndex = str.length() - search.length();
        if (endIndex >= strStartIndex) {
            for (int i = strStartIndex; i <= endIndex; ++i) {
                if (!WildcardMatcher.checkRegionMatches(str, i, search)) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean checkRegionMatches(String str, int strStartIndex, String search) {
        return str.regionMatches(false, strStartIndex, search, 0, search.length());
    }
}

