/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.tools;

import com.floragunn.searchguard.DefaultObjectMapper;
import com.floragunn.searchguard.sgconf.Migration;
import com.floragunn.searchguard.sgconf.impl.CType;
import com.floragunn.searchguard.sgconf.impl.SgDynamicConfiguration;
import com.floragunn.searchguard.sgconf.impl.v7.ActionGroupsV7;
import com.floragunn.searchguard.sgconf.impl.v7.ConfigV7;
import com.floragunn.searchguard.sgconf.impl.v7.InternalUserV7;
import com.floragunn.searchguard.sgconf.impl.v7.RoleMappingsV7;
import com.floragunn.searchguard.sgconf.impl.v7.RoleV7;
import com.floragunn.searchguard.sgconf.impl.v7.TenantV7;
import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.elasticsearch.common.collect.Tuple;

public class Migrater {
    public static void main(String[] args) {
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        options.addOption(Option.builder((String)"dir").argName("directory").hasArg().required().desc("Directory containing file to be migrated").build());
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("dir")) {
                File dir = new File(line.getOptionValue("dir"));
                if (!Migrater.migrateDirectory(dir, true)) {
                    System.exit(-1);
                } else {
                    System.exit(0);
                }
            }
        }
        catch (Exception exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            formatter.printHelp("migrater.sh", options, true);
        }
        System.exit(-1);
    }

    public static boolean migrateDirectory(File dir, boolean backup) {
        if (!dir.exists()) {
            System.out.println(dir.getAbsolutePath() + " does not exist");
            return false;
        }
        if (!dir.isDirectory()) {
            System.out.println(dir.getAbsolutePath() + " is not a directory");
            return false;
        }
        boolean retVal = Migrater.migrateFile(new File(dir, "sg_config.yml"), CType.CONFIG, backup);
        retVal = Migrater.migrateFile(new File(dir, "sg_action_groups.yml"), CType.ACTIONGROUPS, backup) && retVal;
        retVal = Migrater.migrateFile(new File(dir, "sg_roles.yml"), CType.ROLES, backup) && retVal;
        retVal = Migrater.migrateFile(new File(dir, "sg_roles_mapping.yml"), CType.ROLESMAPPING, backup) && retVal;
        retVal = Migrater.migrateFile(new File(dir, "sg_internal_users.yml"), CType.INTERNALUSERS, backup) && retVal;
        return retVal;
    }

    public static boolean migrateFile(File file, CType cType, boolean backup) {
        String absolutePath = file.getAbsolutePath();
        if (!file.exists()) {
            System.out.println("Skip " + absolutePath + " because it does not exist");
            return false;
        }
        if (!file.isFile()) {
            System.out.println("Skip " + absolutePath + " because it is a directory or a special file");
            return false;
        }
        try {
            if (cType == CType.ACTIONGROUPS) {
                SgDynamicConfiguration<ActionGroupsV7> val;
                try {
                    val = Migration.migrateActionGroups(SgDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(file), CType.ACTIONGROUPS, 0, 0L, 0L));
                }
                catch (Exception e) {
                    val = Migration.migrateActionGroups(SgDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(file), CType.ACTIONGROUPS, 1, 0L, 0L));
                }
                return Migrater.backupAndWrite(file, val, backup);
            }
            if (cType == CType.CONFIG) {
                SgDynamicConfiguration<ConfigV7> val = Migration.migrateConfig(SgDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(file), CType.CONFIG, 1, 0L, 0L));
                return Migrater.backupAndWrite(file, val, backup);
            }
            if (cType == CType.ROLES) {
                Tuple<SgDynamicConfiguration<RoleV7>, SgDynamicConfiguration<TenantV7>> tup = Migration.migrateRoles(SgDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(file), CType.ROLES, 1, 0L, 0L), null);
                boolean roles = Migrater.backupAndWrite(file, (SgDynamicConfiguration)tup.v1(), backup);
                return roles && Migrater.backupAndWrite(new File(file.getParent(), "sg_tenants.yml"), (SgDynamicConfiguration)tup.v2(), backup);
            }
            if (cType == CType.ROLESMAPPING) {
                SgDynamicConfiguration<RoleMappingsV7> val = Migration.migrateRoleMappings(SgDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(file), CType.ROLESMAPPING, 1, 0L, 0L));
                return Migrater.backupAndWrite(file, val, backup);
            }
            if (cType == CType.INTERNALUSERS) {
                SgDynamicConfiguration<InternalUserV7> val = Migration.migrateInternalUsers(SgDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(file), CType.INTERNALUSERS, 1, 0L, 0L));
                return Migrater.backupAndWrite(file, val, backup);
            }
        }
        catch (Exception e) {
            System.out.println("Can not migrate " + file + " due to " + e);
        }
        return false;
    }

    private static boolean backupAndWrite(File file, SgDynamicConfiguration<?> val, boolean backup) {
        try {
            if (val == null) {
                System.out.println("NULL object for " + file.getAbsolutePath());
                return false;
            }
            if (backup && file.exists()) {
                Files.copy((File)file, (File)new File(file.getParent(), file.getName() + ".bck6"));
            }
            DefaultObjectMapper.YAML_MAPPER.writeValue(file, val);
            System.out.println("Migrated (as " + (Object)((Object)val.getCType()) + ") " + file.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            System.out.println("Unable to write " + file.getAbsolutePath() + ". This is unexpected and we will abort migration.");
            System.out.println("    Details: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

