/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.user;

import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.CustomAttributesAware;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class User
implements Serializable,
Writeable,
CustomAttributesAware {
    public static final User ANONYMOUS = new User("sg_anonymous", Lists.newArrayList((Object[])new String[]{"sg_anonymous_backendrole"}), null);
    private static final long serialVersionUID = -5500938501822658596L;
    private final String name;
    private final Set<String> roles = new HashSet<String>();
    private final Set<String> searchGuardRoles = new HashSet<String>();
    private String requestedTenant;
    private Map<String, String> attributes = new HashMap<String, String>();
    private boolean isInjected = false;

    public User(StreamInput in) throws IOException {
        this.name = in.readString();
        this.roles.addAll(in.readList(StreamInput::readString));
        this.requestedTenant = in.readString();
        this.attributes = in.readMap(StreamInput::readString, StreamInput::readString);
        this.searchGuardRoles.addAll(in.readList(StreamInput::readString));
    }

    public User(String name, Collection<String> roles, AuthCredentials customAttributes) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        this.name = name;
        if (roles != null) {
            this.addRoles(roles);
        }
        if (customAttributes != null) {
            this.attributes.putAll(customAttributes.getAttributes());
        }
    }

    public User(String name) {
        this(name, null, null);
    }

    public final String getName() {
        return this.name;
    }

    public final Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public final void addRole(String role) {
        this.roles.add(role);
    }

    public final void addRoles(Collection<String> roles) {
        if (roles != null) {
            this.roles.addAll(roles);
        }
    }

    public final boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    public final void addAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public final String getRequestedTenant() {
        return this.requestedTenant;
    }

    public final void setRequestedTenant(String requestedTenant) {
        this.requestedTenant = requestedTenant;
    }

    public boolean isInjected() {
        return this.isInjected;
    }

    public void setInjected(boolean isInjected) {
        this.isInjected = isInjected;
    }

    public final String toStringWithAttributes() {
        return "User [name=" + this.name + ", backend_roles=" + this.roles + ", requestedTenant=" + this.requestedTenant + ", attributes=" + this.attributes + "]";
    }

    public final String toString() {
        return "User [name=" + this.name + ", backend_roles=" + this.roles + ", requestedTenant=" + this.requestedTenant + "]";
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public final void copyRolesFrom(User user) {
        if (user != null) {
            this.addRoles(user.getRoles());
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(new ArrayList<String>(this.roles));
        out.writeString(this.requestedTenant);
        out.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeString);
        out.writeStringCollection((Collection)(this.searchGuardRoles == null ? Collections.emptyList() : new ArrayList<String>(this.searchGuardRoles)));
    }

    @Override
    public final synchronized Map<String, String> getCustomAttributesMap() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public final void addSearchGuardRoles(Collection<String> sgRoles) {
        if (sgRoles != null && this.searchGuardRoles != null) {
            this.searchGuardRoles.addAll(sgRoles);
        }
    }

    public final Set<String> getSearchGuardRoles() {
        return this.searchGuardRoles == null ? Collections.emptySet() : Collections.unmodifiableSet(this.searchGuardRoles);
    }
}

