/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.File;
import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.AbstractRequestExecutor;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import me.chanjar.weixin.common.util.http.okhttp.OkhttpProxyInfo;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class MediaUploadRequestExecutor
extends AbstractRequestExecutor<WxMediaUploadResult, File> {
    /*
     * Loose catch block
     */
    @Override
    public WxMediaUploadResult executeApache(CloseableHttpClient httpclient, HttpHost httpProxy, String uri, File file) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            httpPost.setConfig(config);
        }
        if (file != null) {
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("media", file).setMode(HttpMultipartMode.RFC6532).build();
            httpPost.setEntity(entity);
            httpPost.setHeader("Content-Type", ContentType.MULTIPART_FORM_DATA.toString());
        }
        try {
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((org.apache.http.HttpResponse)response);
                WxError error = WxError.fromJson(responseContent);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxMediaUploadResult wxMediaUploadResult = WxMediaUploadResult.fromJson(responseContent);
                return wxMediaUploadResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    @Override
    public WxMediaUploadResult executeJodd(HttpConnectionProvider provider, ProxyInfo proxyInfo, String uri, File file) throws WxErrorException, IOException {
        HttpRequest request = HttpRequest.post((String)uri);
        if (proxyInfo != null) {
            provider.useProxy(proxyInfo);
        }
        request.withConnectionProvider(provider);
        request.form("media", (Object)file);
        HttpResponse response = request.send();
        String responseContent = response.bodyText();
        WxError error = WxError.fromJson(responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMediaUploadResult.fromJson(responseContent);
    }

    @Override
    public WxMediaUploadResult executeOkhttp(ConnectionPool pool, final OkhttpProxyInfo proxyInfo, String uri, File file) throws WxErrorException, IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(pool);
        if (proxyInfo != null) {
            clientBuilder.proxy(proxyInfo.getProxy());
        }
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)proxyInfo.getProxyUsername(), (String)proxyInfo.getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        });
        OkHttpClient client = clientBuilder.build();
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
        MultipartBody body = new MultipartBody.Builder().addFormDataPart("media", null, fileBody).build();
        Request request = new Request.Builder().url(uri).post((RequestBody)body).build();
        Response response = client.newCall(request).execute();
        String responseContent = response.body().toString();
        WxError error = WxError.fromJson(responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMediaUploadResult.fromJson(responseContent);
    }
}

