/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.okhttp.OkhttpProxyInfo;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class OkSimplePostRequestExecutor
extends SimplePostRequestExecutor<ConnectionPool, OkhttpProxyInfo> {
    public OkSimplePostRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    @Override
    public String execute(String uri, String postEntity) throws WxErrorException, IOException {
        ConnectionPool pool = (ConnectionPool)this.requestHttp.getRequestHttpClient();
        final OkhttpProxyInfo proxyInfo = (OkhttpProxyInfo)this.requestHttp.getRequestHttpProxy();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(pool);
        if (proxyInfo != null) {
            clientBuilder.proxy(proxyInfo.getProxy());
        }
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)proxyInfo.getProxyUsername(), (String)proxyInfo.getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        });
        OkHttpClient client = clientBuilder.build();
        MediaType mediaType = MediaType.parse((String)"text/plain; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)postEntity);
        Request request = new Request.Builder().url(uri).post(body).build();
        Response response = client.newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson(responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }
}

