/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.jodd;

import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;

public class JoddHttpSimplePostRequestExecutor
extends SimplePostRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    public JoddHttpSimplePostRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    @Override
    public String execute(String uri, String postEntity) throws WxErrorException, IOException {
        HttpConnectionProvider provider = (HttpConnectionProvider)this.requestHttp.getRequestHttpClient();
        ProxyInfo proxyInfo = (ProxyInfo)this.requestHttp.getRequestHttpProxy();
        HttpRequest request = HttpRequest.post((String)uri);
        if (proxyInfo != null) {
            provider.useProxy(proxyInfo);
        }
        request.withConnectionProvider(provider);
        if (postEntity != null) {
            request.bodyText(postEntity);
        }
        HttpResponse response = request.send();
        response.charset("UTF-8");
        String responseContent = response.bodyText();
        if (responseContent.isEmpty()) {
            throw new WxErrorException(WxError.builder().errorCode(9999).errorMsg("\u65e0\u54cd\u5e94\u5185\u5bb9").build());
        }
        if (responseContent.startsWith("<xml>")) {
            return responseContent;
        }
        WxError error = WxError.fromJson(responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }
}

