/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.IOException;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientSimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.jodd.JoddHttpSimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpSimpleGetRequestExecutor;

public abstract class SimpleGetRequestExecutor<H, P>
implements RequestExecutor<String, String> {
    protected RequestHttp<H, P> requestHttp;

    public SimpleGetRequestExecutor(RequestHttp<H, P> requestHttp) {
        this.requestHttp = requestHttp;
    }

    @Override
    public void execute(String uri, String data, ResponseHandler<String> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle((String)this.execute(uri, data, wxType));
    }

    public static RequestExecutor<String, String> create(RequestHttp requestHttp) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new ApacheHttpClientSimpleGetRequestExecutor(requestHttp);
            }
            case JODD_HTTP: {
                return new JoddHttpSimpleGetRequestExecutor(requestHttp);
            }
            case OK_HTTP: {
                return new OkHttpSimpleGetRequestExecutor(requestHttp);
            }
        }
        throw new IllegalArgumentException("\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570");
    }
}

