/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.error;

import java.io.Serializable;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxCpErrorMsgEnum;
import me.chanjar.weixin.common.error.WxMaErrorMsgEnum;
import me.chanjar.weixin.common.error.WxMpErrorMsgEnum;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;

public class WxError
implements Serializable {
    private static final long serialVersionUID = 7869786563361406291L;
    private int errorCode;
    private String errorMsg;
    private String errorMsgEn;
    private String json;

    public WxError(int errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public static WxError fromJson(String json) {
        return WxError.fromJson(json, null);
    }

    public static WxError fromJson(String json, WxType type) {
        WxError wxError = (WxError)WxGsonBuilder.create().fromJson(json, WxError.class);
        if (wxError.getErrorCode() == 0 || type == null) {
            return wxError;
        }
        if (StringUtils.isNotEmpty((CharSequence)wxError.getErrorMsg())) {
            wxError.setErrorMsgEn(wxError.getErrorMsg());
        }
        switch (type) {
            case MP: {
                String msg = WxMpErrorMsgEnum.findMsgByCode(wxError.getErrorCode());
                if (msg == null) break;
                wxError.setErrorMsg(msg);
                break;
            }
            case CP: {
                String msg = WxCpErrorMsgEnum.findMsgByCode(wxError.getErrorCode());
                if (msg == null) break;
                wxError.setErrorMsg(msg);
                break;
            }
            case MiniApp: {
                String msg = WxMaErrorMsgEnum.findMsgByCode(wxError.getErrorCode());
                if (msg == null) break;
                wxError.setErrorMsg(msg);
                break;
            }
            default: {
                return wxError;
            }
        }
        return wxError;
    }

    public String toString() {
        if (this.json == null) {
            return "\u9519\u8bef\u4ee3\u7801\uff1a" + this.errorCode + ", \u9519\u8bef\u4fe1\u606f\uff1a" + this.errorMsg;
        }
        return "\u9519\u8bef\u4ee3\u7801\uff1a" + this.errorCode + ", \u9519\u8bef\u4fe1\u606f\uff1a" + this.errorMsg + "\uff0c\u5fae\u4fe1\u539f\u59cb\u62a5\u6587\uff1a" + this.json;
    }

    public static WxErrorBuilder builder() {
        return new WxErrorBuilder();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getErrorMsgEn() {
        return this.errorMsgEn;
    }

    public String getJson() {
        return this.json;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setErrorMsgEn(String errorMsgEn) {
        this.errorMsgEn = errorMsgEn;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxError)) {
            return false;
        }
        WxError other = (WxError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        String this$errorMsgEn = this.getErrorMsgEn();
        String other$errorMsgEn = other.getErrorMsgEn();
        if (this$errorMsgEn == null ? other$errorMsgEn != null : !this$errorMsgEn.equals(other$errorMsgEn)) {
            return false;
        }
        String this$json = this.getJson();
        String other$json = other.getJson();
        return !(this$json == null ? other$json != null : !this$json.equals(other$json));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getErrorCode();
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        String $errorMsgEn = this.getErrorMsgEn();
        result = result * 59 + ($errorMsgEn == null ? 43 : $errorMsgEn.hashCode());
        String $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        return result;
    }

    public WxError() {
    }

    public WxError(int errorCode, String errorMsg, String errorMsgEn, String json) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.errorMsgEn = errorMsgEn;
        this.json = json;
    }

    public static class WxErrorBuilder {
        private int errorCode;
        private String errorMsg;
        private String errorMsgEn;
        private String json;

        WxErrorBuilder() {
        }

        public WxErrorBuilder errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public WxErrorBuilder errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public WxErrorBuilder errorMsgEn(String errorMsgEn) {
            this.errorMsgEn = errorMsgEn;
            return this;
        }

        public WxErrorBuilder json(String json) {
            this.json = json;
            return this;
        }

        public WxError build() {
            return new WxError(this.errorCode, this.errorMsg, this.errorMsgEn, this.json);
        }

        public String toString() {
            return "WxError.WxErrorBuilder(errorCode=" + this.errorCode + ", errorMsg=" + this.errorMsg + ", errorMsgEn=" + this.errorMsgEn + ", json=" + this.json + ")";
        }
    }
}

