/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.bean.pay.result;

import com.google.common.collect.Maps;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import io.restassured.internal.path.xml.NodeChildrenImpl;
import io.restassured.internal.path.xml.NodeImpl;
import io.restassured.path.xml.XmlPath;
import io.restassured.path.xml.element.Node;
import io.restassured.path.xml.exception.XmlPathException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WxPayBaseResult {
    @XStreamAlias(value="return_code")
    protected String returnCode;
    @XStreamAlias(value="return_msg")
    protected String returnMsg;
    private String xmlString;
    @XStreamAlias(value="result_code")
    private String resultCode;
    @XStreamAlias(value="err_code")
    private String errCode;
    @XStreamAlias(value="err_code_des")
    private String errCodeDes;
    @XStreamAlias(value="appid")
    private String appid;
    @XStreamAlias(value="mch_id")
    private String mchId;
    @XStreamAlias(value="nonce_str")
    private String nonceStr;
    @XStreamAlias(value="sign")
    private String sign;

    public static String feeToYuan(Integer fee) {
        return new BigDecimal(Double.valueOf(fee.intValue()) / 100.0).setScale(2, 4).toPlainString();
    }

    public static <T extends WxPayBaseResult> T fromXML(String xmlString, Class<T> clz) {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(clz);
        WxPayBaseResult result = (WxPayBaseResult)xstream.fromXML(xmlString);
        result.setXmlString(xmlString);
        return (T)result;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public String toString() {
        return ToStringUtils.toSimpleString((Object)this);
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMsg() {
        return this.returnMsg;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrCodeDes() {
        return this.errCodeDes;
    }

    public void setErrCodeDes(String errCodeDes) {
        this.errCodeDes = errCodeDes;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMchId() {
        return this.mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public Map<String, String> toMap() {
        HashMap result = Maps.newHashMap();
        XmlPath xmlPath = new XmlPath(this.xmlString);
        NodeImpl rootNode = null;
        try {
            rootNode = (NodeImpl)xmlPath.get("xml");
        }
        catch (XmlPathException e) {
            throw new RuntimeException("xml\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        if (rootNode == null) {
            throw new RuntimeException("xml\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        Iterator iterator = rootNode.children().nodeIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            result.put(node.name(), node.value());
        }
        return result;
    }

    private String getXmlValue(XmlPath xmlPath, String path) {
        if (xmlPath.get(path) instanceof NodeChildrenImpl && ((NodeChildrenImpl)xmlPath.get(path)).size() == 0) {
            return null;
        }
        return xmlPath.getString(path);
    }

    protected <T> T getXmlValue(XmlPath xmlPath, String path, Class<T> clz) {
        String value = this.getXmlValue(xmlPath, path);
        if (value == null) {
            return null;
        }
        switch (clz.getSimpleName()) {
            case "String": {
                return (T)value;
            }
            case "Integer": {
                return (T)Integer.valueOf(value);
            }
        }
        throw new UnsupportedOperationException("\u6682\u65f6\u4e0d\u652f\u6301\u6b64\u79cd\u7c7b\u578b\u7684\u6570\u636e");
    }
}

