/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.BaseMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.api.WxMpMaterialService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.material.WxMediaImgUploadResult;
import me.chanjar.weixin.mp.bean.material.WxMpMaterial;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialArticleUpdate;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialCountResult;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialFileBatchGetResult;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialNews;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialNewsBatchGetResult;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialVideoInfoResult;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialDeleteRequestExecutor;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialNewsInfoRequestExecutor;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialUploadRequestExecutor;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialVideoInfoRequestExecutor;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialVoiceAndImageDownloadRequestExecutor;
import me.chanjar.weixin.mp.util.requestexecuter.media.MediaImgUploadRequestExecutor;

public class WxMpMaterialServiceImpl
implements WxMpMaterialService {
    private WxMpService wxMpService;

    public WxMpMaterialServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException {
        File tmpFile = null;
        try {
            tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType);
            WxMediaUploadResult wxMediaUploadResult = this.mediaUpload(mediaType, tmpFile);
            return wxMediaUploadResult;
        }
        catch (IOException e) {
            throw new WxErrorException(WxError.builder().errorCode(-1).errorMsg(e.getMessage()).build(), (Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, File file) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/media/upload?type=%s", mediaType);
        return (WxMediaUploadResult)this.wxMpService.execute(MediaUploadRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp()), url, file);
    }

    @Override
    public File mediaDownload(String mediaId) throws WxErrorException {
        return (File)this.wxMpService.execute(BaseMediaDownloadRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp(), (File)this.wxMpService.getWxMpConfigStorage().getTmpDirFile()), "https://api.weixin.qq.com/cgi-bin/media/get", "media_id=" + mediaId);
    }

    @Override
    public WxMediaImgUploadResult mediaImgUpload(File file) throws WxErrorException {
        return this.wxMpService.execute(MediaImgUploadRequestExecutor.create(this.wxMpService.getRequestHttp()), "https://api.weixin.qq.com/cgi-bin/media/uploadimg", file);
    }

    @Override
    public WxMpMaterialUploadResult materialFileUpload(String mediaType, WxMpMaterial material) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/material/add_material?type=%s", mediaType);
        return this.wxMpService.execute(MaterialUploadRequestExecutor.create(this.wxMpService.getRequestHttp()), url, material);
    }

    @Override
    public WxMpMaterialUploadResult materialNewsUpload(WxMpMaterialNews news) throws WxErrorException {
        if (news == null || news.isEmpty()) {
            throw new IllegalArgumentException("news is empty!");
        }
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/material/add_news", news.toJson());
        return WxMpMaterialUploadResult.fromJson(responseContent);
    }

    @Override
    public InputStream materialImageOrVoiceDownload(String mediaId) throws WxErrorException {
        return this.wxMpService.execute(MaterialVoiceAndImageDownloadRequestExecutor.create(this.wxMpService.getRequestHttp(), this.wxMpService.getWxMpConfigStorage().getTmpDirFile()), "https://api.weixin.qq.com/cgi-bin/material/get_material", mediaId);
    }

    @Override
    public WxMpMaterialVideoInfoResult materialVideoInfo(String mediaId) throws WxErrorException {
        return this.wxMpService.execute(MaterialVideoInfoRequestExecutor.create(this.wxMpService.getRequestHttp()), "https://api.weixin.qq.com/cgi-bin/material/get_material", mediaId);
    }

    @Override
    public WxMpMaterialNews materialNewsInfo(String mediaId) throws WxErrorException {
        return this.wxMpService.execute(MaterialNewsInfoRequestExecutor.create(this.wxMpService.getRequestHttp()), "https://api.weixin.qq.com/cgi-bin/material/get_material", mediaId);
    }

    @Override
    public boolean materialNewsUpdate(WxMpMaterialArticleUpdate wxMpMaterialArticleUpdate) throws WxErrorException {
        String responseText = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/material/update_news", wxMpMaterialArticleUpdate.toJson());
        WxError wxError = WxError.fromJson((String)responseText, (WxType)WxType.MP);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public boolean materialDelete(String mediaId) throws WxErrorException {
        return this.wxMpService.execute(MaterialDeleteRequestExecutor.create(this.wxMpService.getRequestHttp()), "https://api.weixin.qq.com/cgi-bin/material/del_material", mediaId);
    }

    @Override
    public WxMpMaterialCountResult materialCount() throws WxErrorException {
        String responseText = this.wxMpService.get("https://api.weixin.qq.com/cgi-bin/material/get_materialcount", null);
        WxError wxError = WxError.fromJson((String)responseText, (WxType)WxType.MP);
        if (wxError.getErrorCode() == 0) {
            return (WxMpMaterialCountResult)WxMpGsonBuilder.create().fromJson(responseText, WxMpMaterialCountResult.class);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMpMaterialNewsBatchGetResult materialNewsBatchGet(int offset, int count) throws WxErrorException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "news");
        params.put("offset", offset);
        params.put("count", count);
        String responseText = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/material/batchget_material", WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText, (WxType)WxType.MP);
        if (wxError.getErrorCode() == 0) {
            return (WxMpMaterialNewsBatchGetResult)WxMpGsonBuilder.create().fromJson(responseText, WxMpMaterialNewsBatchGetResult.class);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMpMaterialFileBatchGetResult materialFileBatchGet(String type, int offset, int count) throws WxErrorException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("offset", offset);
        params.put("count", count);
        String responseText = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/material/batchget_material", WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText, (WxType)WxType.MP);
        if (wxError.getErrorCode() == 0) {
            return (WxMpMaterialFileBatchGetResult)WxMpGsonBuilder.create().fromJson(responseText, WxMpMaterialFileBatchGetResult.class);
        }
        throw new WxErrorException(wxError);
    }
}

