/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.requestexecuter.qrcode;

import java.io.File;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import me.chanjar.weixin.mp.util.requestexecuter.qrcode.QrCodeApacheHttpRequestExecutor;
import me.chanjar.weixin.mp.util.requestexecuter.qrcode.QrCodeJoddHttpRequestExecutor;
import me.chanjar.weixin.mp.util.requestexecuter.qrcode.QrCodeOkhttpRequestExecutor;

public abstract class QrCodeRequestExecutor<H, P>
implements RequestExecutor<File, WxMpQrCodeTicket> {
    protected RequestHttp<H, P> requestHttp;

    public QrCodeRequestExecutor(RequestHttp requestHttp) {
        this.requestHttp = requestHttp;
    }

    public static RequestExecutor<File, WxMpQrCodeTicket> create(RequestHttp requestHttp) throws WxErrorException {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new QrCodeApacheHttpRequestExecutor(requestHttp);
            }
            case JODD_HTTP: {
                return new QrCodeJoddHttpRequestExecutor(requestHttp);
            }
            case OK_HTTP: {
                return new QrCodeOkhttpRequestExecutor(requestHttp);
            }
        }
        throw new WxErrorException(WxError.builder().errorCode(-1).errorMsg("\u4e0d\u652f\u6301\u7684http\u6846\u67b6").build());
    }
}

