/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian;

import cucumber.api.CucumberOptions;
import cucumber.api.junit.Cucumber;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import cucumber.runtime.FeatureBuilder;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.arquillian.api.Tags;
import cucumber.runtime.arquillian.backend.ArquillianBackend;
import cucumber.runtime.arquillian.config.CucumberConfiguration;
import cucumber.runtime.arquillian.feature.Features;
import cucumber.runtime.arquillian.glue.Glues;
import cucumber.runtime.arquillian.reporter.CucumberReporter;
import cucumber.runtime.io.Resource;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.PathWithLines;
import gherkin.formatter.Formatter;
import gherkin.formatter.JSONFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;

public class ArquillianCucumber
extends Arquillian {
    private static final Logger LOGGER = Logger.getLogger(ArquillianCucumber.class.getName());
    private static final String RUN_CUCUMBER_MTD = "____Cucumber_Runner_Not_A_Test";
    private static final Class<? extends Annotation>[] OPTIONS_ANNOTATIONS = new Class[]{CucumberOptions.class, Cucumber.Options.class};
    private List<FrameworkMethod> methods;

    public ArquillianCucumber(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Description describeChild(FrameworkMethod method) {
        if (!Boolean.getBoolean("cukespace.runner.standard-describe") && InstanceControlledFrameworkMethod.class.isInstance(method)) {
            return Description.createTestDescription(((InstanceControlledFrameworkMethod)((Object)InstanceControlledFrameworkMethod.class.cast(method))).getOriginalClass(), (String)RUN_CUCUMBER_MTD, (Annotation[])method.getAnnotations());
        }
        return super.describeChild(method);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        this.methods = new LinkedList<FrameworkMethod>();
        for (FrameworkMethod each : ArquillianCucumber.super.computeTestMethods()) {
            this.methods.add(each);
        }
        try {
            Method runCucumber = ArquillianCucumber.class.getDeclaredMethod(RUN_CUCUMBER_MTD, Object.class, RunNotifier.class);
            this.methods.add(new InstanceControlledFrameworkMethod(this, this.getTestClass().getJavaClass(), runCucumber));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return this.methods;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (InstanceControlledFrameworkMethod.class.isInstance(method)) {
            ((InstanceControlledFrameworkMethod)((Object)InstanceControlledFrameworkMethod.class.cast(method))).setNotifier(notifier);
        }
        super.runChild(method, notifier);
    }

    public void ____Cucumber_Runner_Not_A_Test(Object testInstance, RunNotifier runNotifier) throws Exception {
        String path;
        RuntimeOptions runtimeOptions;
        Class clazz = this.getTestClass().getJavaClass();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        InputStream configIs = tccl.getResourceAsStream("cukespace-config.properties");
        Properties cukespaceConfig = new Properties();
        if (configIs != null) {
            cukespaceConfig.load(configIs);
        } else {
            CucumberConfiguration config = CucumberConfiguration.instance();
            if (config.isInitialized()) {
                cukespaceConfig.setProperty("colors", Boolean.toString(config.isColorized()));
                cukespaceConfig.setProperty("reportable", Boolean.toString(config.isReport()));
                cukespaceConfig.setProperty("reportablePath", config.getReportDirectory());
                if (config.getFeatureHome() != null) {
                    cukespaceConfig.setProperty("featureHome", config.getFeatureHome());
                }
                if (config.hasOptions()) {
                    cukespaceConfig.setProperty("options", config.getOptions());
                }
                if (config.getFeatureHome() != null) {
                    cukespaceConfig.setProperty("featureHome", config.getFeatureHome());
                }
            }
        }
        ArrayList cucumberFeatures = new ArrayList();
        FeatureBuilder builder = new FeatureBuilder(cucumberFeatures);
        List<Object> filters = ArquillianCucumber.createFilters(testInstance);
        InputStream featuresIs = tccl.getResourceAsStream("cukespace-features.txt");
        if (featuresIs != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(featuresIs));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                HashSet<Object> resourceFilters = new HashSet<Object>(filters);
                PathWithLines pathWithLines = new PathWithLines(line);
                resourceFilters.addAll(pathWithLines.lines);
                builder.parse((Resource)new ClassLoaderResource(tccl, pathWithLines.path), new ArrayList<Object>(resourceFilters));
            }
        } else {
            for (Map.Entry<String, Collection<URL>> entry : Features.createFeatureMap(CucumberConfiguration.instance().getTempDir(), cukespaceConfig.getProperty("featureHome"), clazz, tccl).entrySet()) {
                PathWithLines pathWithLines = new PathWithLines(entry.getKey());
                HashSet<Object> resourceFilters = new HashSet<Object>(filters);
                resourceFilters.addAll(pathWithLines.lines);
                for (URL url : entry.getValue()) {
                    builder.parse((Resource)new URLResource(pathWithLines.path, url), new ArrayList<Object>(resourceFilters));
                }
            }
        }
        if (cucumberFeatures.isEmpty()) {
            throw new IllegalArgumentException("No feature found");
        }
        if (clazz.getAnnotation(Cucumber.Options.class) != null || clazz.getAnnotation(CucumberOptions.class) != null) {
            RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz, (Class[])OPTIONS_ANNOTATIONS);
            runtimeOptions = runtimeOptionsFactory.create();
            ArquillianCucumber.cleanClasspathList(runtimeOptions.getGlue());
            ArquillianCucumber.cleanClasspathList(runtimeOptions.getFeaturePaths());
        } else {
            runtimeOptions = cukespaceConfig.containsKey("options") ? new RuntimeOptions(new Env("cucumber-jvm"), Arrays.asList((cukespaceConfig.getProperty("options", "--strict") + " --strict").split(" "))) : new RuntimeOptions(new Env("cucumber-jvm"), Arrays.asList("--strict", "-f", "pretty", ArquillianCucumber.areColorsNotAvailable(cukespaceConfig)));
        }
        boolean reported = Boolean.parseBoolean(cukespaceConfig.getProperty("reportable", "false"));
        StringBuilder reportBuilder = new StringBuilder();
        if (reported) {
            runtimeOptions.addFormatter((Formatter)new JSONFormatter((Appendable)reportBuilder));
        }
        LinkedList glues = new LinkedList();
        InputStream gluesIs = tccl.getResourceAsStream("cukespace-glues.txt");
        if (gluesIs != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(gluesIs));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                glues.add(tccl.loadClass(line));
            }
        } else {
            glues.addAll(Glues.findGlues(clazz));
        }
        Runtime runtime = new Runtime(null, tccl, Arrays.asList(new ArquillianBackend(glues, clazz, testInstance)), runtimeOptions);
        Formatter formatter = runtimeOptions.formatter(tccl);
        JUnitReporter jUnitReporter = new JUnitReporter(runtimeOptions.reporter(tccl), formatter, runtimeOptions.isStrict());
        for (CucumberFeature feature : cucumberFeatures) {
            LOGGER.info("Running " + feature.getPath());
            new FeatureRunner(feature, runtime, jUnitReporter).run(runNotifier);
        }
        jUnitReporter.done();
        jUnitReporter.close();
        runtime.printSummary();
        if (reported && (path = cukespaceConfig.getProperty("reportablePath")) != null) {
            block25: {
                File destination = CucumberConfiguration.reportFile(path, clazz);
                File parentFile = destination.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    throw new IllegalArgumentException("Can't create " + parentFile.getAbsolutePath());
                }
                FileWriter writer = null;
                try {
                    writer = new FileWriter(destination);
                    writer.write(reportBuilder.toString());
                    writer.flush();
                }
                catch (IOException e) {
                    if (writer == null) break block25;
                    writer.close();
                }
            }
            CucumberReporter.addReport(CucumberConfiguration.reportFile(path, clazz));
        }
        List errors = runtime.getErrors();
        for (String snippet : runtime.getSnippets()) {
            errors.add(new CucumberException("Missing snippet: " + snippet));
        }
        if (!errors.isEmpty()) {
            throw new MultipleFailureException(errors);
        }
    }

    private static List<Object> createFilters(Object testInstance) {
        Cucumber.Options options;
        ArrayList<Object> filters = new ArrayList<Object>();
        Class<?> clazz = testInstance.getClass();
        Tags tags = clazz.getAnnotation(Tags.class);
        if (tags != null) {
            filters.addAll(Arrays.asList(tags.value()));
        }
        if ((options = clazz.getAnnotation(Cucumber.Options.class)) != null) {
            if (options.tags().length > 0) {
                filters.addAll(Arrays.asList(options.tags()));
            }
            if (options.name().length > 0) {
                for (String name : options.name()) {
                    filters.add(Pattern.compile(name));
                }
            }
        }
        return filters;
    }

    private static void cleanClasspathList(List<String> list) {
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith("classpath:")) continue;
            it.remove();
        }
    }

    private static String areColorsNotAvailable(Properties cukespaceConfig) {
        if (!Boolean.parseBoolean(cukespaceConfig.getProperty("colors", "false"))) {
            return "--monochrome";
        }
        return "--no-monochrome";
    }

    private static class InstanceControlledFrameworkMethod
    extends FrameworkMethod {
        private final ArquillianCucumber instance;
        private final Class<?> originalClass;
        private RunNotifier notifier;

        public InstanceControlledFrameworkMethod(ArquillianCucumber runner, Class<?> originalClass, Method runCucumber) {
            super(runCucumber);
            this.originalClass = originalClass;
            this.instance = runner;
        }

        public Object invokeExplosively(Object target, Object ... params) throws Throwable {
            this.instance.____Cucumber_Runner_Not_A_Test(target, this.notifier == null ? new RunNotifier() : this.notifier);
            return null;
        }

        public Class<?> getOriginalClass() {
            return this.originalClass;
        }

        public void setNotifier(RunNotifier notifier) {
            this.notifier = notifier;
        }
    }

    private static class URLResource
    implements Resource {
        private final URL url;
        private final String path;

        public URLResource(String path, URL url) {
            this.url = url;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getAbsolutePath() {
            return this.url.toExternalForm();
        }

        public InputStream getInputStream() throws IOException {
            return this.url.openStream();
        }

        public String getClassName(String extension) {
            String path = this.getPath();
            return path.substring(0, path.length() - extension.length()).replace('/', '.');
        }
    }

    private static class ClassLoaderResource
    implements Resource {
        private final String path;
        private final ClassLoader loader;

        public ClassLoaderResource(ClassLoader loader, String path) {
            this.path = path;
            this.loader = loader;
        }

        public String getPath() {
            return this.path;
        }

        public String getAbsolutePath() {
            URL resource = this.loader.getResource(this.path);
            if (resource == null) {
                throw new IllegalArgumentException(this.path + " doesn't exist");
            }
            return resource.toExternalForm();
        }

        public InputStream getInputStream() throws IOException {
            URL resource = this.loader.getResource(this.path);
            if (resource == null) {
                throw new IllegalArgumentException(this.path + " doesn't exist");
            }
            return resource.openStream();
        }

        public String getClassName(String extension) {
            String path = this.getPath();
            return path.substring(0, path.length() - extension.length()).replace('/', '.');
        }
    }
}

