/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.backend;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.Utils;
import cucumber.runtime.arquillian.backend.ArquillianHookDefinition;
import cucumber.runtime.arquillian.backend.ArquillianSnippet;
import cucumber.runtime.arquillian.backend.ArquillianStepDefinition;
import cucumber.runtime.arquillian.lifecycle.CucumberLifecycle;
import cucumber.runtime.arquillian.shared.ClassLoaders;
import cucumber.runtime.java.StepDefAnnotation;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ArquillianBackend
implements Backend {
    private SnippetGenerator snippetGenerator;
    private final Map<Class<?>, Object> instances = new HashMap();
    private final Collection<Class<?>> glues = new ArrayList();
    private Glue glue;
    private GlueType glueType = GlueType.UNKNOWN;

    public ArquillianBackend(Collection<Class<?>> classes, Class<?> clazz, Object testInstance) {
        this.instances.put(clazz, testInstance);
        this.glues.addAll(classes);
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        this.initInstances();
        this.scan();
    }

    private void initInstances() {
        for (Class<?> glueClass : this.glues) {
            Object instance;
            try {
                instance = glueClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't instantiate " + glueClass.getName(), e);
            }
            this.instances.put(glueClass, CucumberLifecycle.enrich(instance));
        }
    }

    private void scan() {
        for (Map.Entry<Class<?>, Object> clazz : this.instances.entrySet()) {
            if (this.readFromJava(clazz)) {
                this.glueType = GlueType.JAVA;
            }
            if (!this.readFromScalaDsl(clazz.getValue()) || this.glueType == GlueType.JAVA) continue;
            this.glueType = GlueType.SCALA;
        }
    }

    private boolean readFromJava(Map.Entry<Class<?>, Object> clazz) {
        boolean found = false;
        for (Method method : clazz.getKey().getMethods()) {
            for (Class<? extends Annotation> cucumberAnnotationClass : CucumberLifecycle.cucumberAnnotations()) {
                Annotation annotation = method.getAnnotation(cucumberAnnotationClass);
                if (annotation == null) continue;
                if (this.isHookAnnotation(annotation)) {
                    this.addHook(annotation, method, clazz.getValue());
                    found = true;
                    continue;
                }
                if (!this.isStepdefAnnotation(annotation)) continue;
                this.addStepDefinition(annotation, method, clazz.getValue());
                found = true;
            }
        }
        return found;
    }

    private boolean readFromScalaDsl(Object instance) {
        try {
            ClassLoaders.load("cucumber.api.scala.ScalaDsl");
            Class<?> clazz = instance.getClass();
            Collection<StepDefinition> stepDefinitions = ArquillianBackend.readField(clazz, "stepDefinitions", instance, StepDefinition.class);
            for (StepDefinition sd : stepDefinitions) {
                this.glue.addStepDefinition((StepDefinition)StepDefinition.class.cast(sd));
            }
            Collection<HookDefinition> beforeHooks = ArquillianBackend.readField(clazz, "beforeHooks", instance, HookDefinition.class);
            for (HookDefinition sd : beforeHooks) {
                this.glue.addBeforeHook((HookDefinition)HookDefinition.class.cast(sd));
            }
            Collection<HookDefinition> afterHooks = ArquillianBackend.readField(clazz, "afterHooks", instance, HookDefinition.class);
            for (HookDefinition sd : afterHooks) {
                this.glue.addAfterHook((HookDefinition)HookDefinition.class.cast(sd));
            }
            return stepDefinitions.size() + beforeHooks.size() + afterHooks.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isHookAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(Before.class) || annotationClass.equals(After.class);
    }

    private boolean isStepdefAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefAnnotation.class) != null;
    }

    private void addStepDefinition(Annotation annotation, Method method, Object instance) {
        try {
            this.glue.addStepDefinition((StepDefinition)new ArquillianStepDefinition(method, this.pattern(annotation), this.timeout(annotation), instance));
        }
        catch (DuplicateStepDefinitionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
    }

    private Pattern pattern(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("value", new Class[0]);
        String regexpString = (String)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
        return Pattern.compile(regexpString);
    }

    private long timeout(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("timeout", new Class[0]);
        return (Long)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
    }

    private void addHook(Annotation annotation, Method method, Object instance) {
        if (annotation.annotationType().equals(Before.class)) {
            String[] tagExpressions = ((Before)annotation).value();
            long timeout = ((Before)annotation).timeout();
            this.glue.addBeforeHook((HookDefinition)new ArquillianHookDefinition(method, tagExpressions, ((Before)annotation).order(), timeout, instance));
        } else {
            String[] tagExpressions = ((After)annotation).value();
            long timeout = ((After)annotation).timeout();
            this.glue.addAfterHook((HookDefinition)new ArquillianHookDefinition(method, tagExpressions, ((After)annotation).order(), timeout, instance));
        }
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
    }

    public void disposeWorld() {
    }

    public String getSnippet(Step step, FunctionNameGenerator nameGenerator) {
        if (this.snippetGenerator == null && GlueType.SCALA.equals((Object)this.glueType)) {
            try {
                this.snippetGenerator = new SnippetGenerator((Snippet)Snippet.class.cast(ClassLoaders.load("cucumber.runtime.scala.ScalaSnippetGenerator").newInstance()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.snippetGenerator == null) {
            this.snippetGenerator = new SnippetGenerator((Snippet)new ArquillianSnippet());
        }
        return this.snippetGenerator.getSnippet(step, nameGenerator);
    }

    private static <T> Collection<T> readField(Class<?> clazz, String field, Object instance, Class<T> cast) throws Exception {
        Field f = clazz.getDeclaredField(field);
        f.setAccessible(true);
        Object o = f.get(instance);
        Class<?> arrayBuffer = ClassLoaders.load("scala.collection.mutable.ArrayBuffer");
        if (arrayBuffer.isInstance(o)) {
            Object[] array = (Object[])Object[].class.cast(arrayBuffer.getDeclaredMethod("array", new Class[0]).invoke(o, new Object[0]));
            ArrayList<T> result = new ArrayList<T>(array.length);
            for (Object i : array) {
                if (!cast.isInstance(i)) continue;
                result.add(cast.cast(i));
            }
            return result;
        }
        throw new IllegalArgumentException("expected an ArrayBuffer and got " + o);
    }

    protected static enum GlueType {
        JAVA,
        SCALA,
        UNKNOWN;

    }
}

