/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.backend;

import cucumber.api.Scenario;
import cucumber.runtime.CucumberException;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.MethodFormat;
import cucumber.runtime.Utils;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;

public class ArquillianHookDefinition
implements HookDefinition {
    private final Method method;
    private final long timeout;
    private final TagExpression tagExpression;
    private final int order;
    private final Object instance;

    public ArquillianHookDefinition(Method method, String[] tagExpressions, int order, long timeout, Object instance) {
        this.method = method;
        this.timeout = timeout;
        this.tagExpression = new TagExpression(Arrays.asList(tagExpressions));
        this.order = order;
        this.instance = instance;
    }

    public String getLocation(boolean detail) {
        MethodFormat format = detail ? MethodFormat.FULL : MethodFormat.SHORT;
        return format.format(this.method);
    }

    public void execute(Scenario scenario) throws Throwable {
        Object[] args;
        switch (this.method.getParameterTypes().length) {
            case 0: {
                args = new Object[]{};
                break;
            }
            case 1: {
                if (!Scenario.class.equals(this.method.getParameterTypes()[0])) {
                    throw new CucumberException("When a hook declares an argument it must be of type " + Scenario.class.getName() + ". " + this.method.toString());
                }
                args = new Object[]{scenario};
                break;
            }
            default: {
                throw new CucumberException("Hooks must declare 0 or 1 arguments. " + this.method.toString());
            }
        }
        Utils.invoke((Object)this.instance, (Method)this.method, (long)this.timeout, (Object[])args);
    }

    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.evaluate(tags);
    }

    public int getOrder() {
        return this.order;
    }
}

