/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.feature;

import cucumber.api.CucumberOptions;
import cucumber.api.junit.Cucumber;
import cucumber.runtime.arquillian.client.IOs;
import cucumber.runtime.io.FileResource;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ZipResource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

public final class Features {
    private static final Logger LOGGER = Logger.getLogger(Features.class.getName());
    public static final String EXTENSION = ".feature";

    private Features() {
    }

    public static String featurePath(Class<?> javaClass) {
        return javaClass.getPackage().getName().replace('.', '/') + '/' + Features.createClassNameSubPackage(javaClass.getSimpleName()) + EXTENSION;
    }

    public static Map<String, Collection<URL>> createFeatureMap(String tempDir, String featureHome, Class<?> javaClass, ClassLoader loader) {
        HashMap<String, Collection<URL>> featureUrls = new HashMap<String, Collection<URL>>();
        String home = featureHome != null && !featureHome.endsWith("/") ? featureHome + "/" : featureHome;
        cucumber.runtime.arquillian.api.Features additionalFeaturesAnn = javaClass.getAnnotation(cucumber.runtime.arquillian.api.Features.class);
        LinkedList<ResourceLoader> customLoaders = new LinkedList<ResourceLoader>();
        if (additionalFeaturesAnn != null) {
            Class<? extends ResourceLoader>[] userLoaders;
            for (Class<? extends ResourceLoader> resourceLoader : userLoaders = additionalFeaturesAnn.loaders()) {
                try {
                    ResourceLoader instance = resourceLoader.newInstance();
                    customLoaders.add(instance);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("can't create a " + resourceLoader.getName(), e);
                }
            }
        }
        for (String raw : Features.findFeatures(javaClass)) {
            String suffix;
            String path;
            ArrayList<URL> list = new ArrayList<URL>();
            int lineIdx = raw.lastIndexOf(58);
            if (lineIdx > 0 && lineIdx + 1 != "classpath:".length()) {
                path = raw.substring(0, lineIdx);
                suffix = raw.substring(lineIdx);
            } else {
                suffix = "";
                path = raw;
            }
            boolean directResource = path.endsWith(EXTENSION);
            if (directResource) {
                URL url = loader.getResource(path);
                if (url != null) {
                    list.add(url);
                    featureUrls.put(raw + suffix, list);
                    continue;
                }
                if (Features.urlFromFileSystem(featureUrls, list, path, path, suffix) || home != null && Features.urlFromFileSystem(featureUrls, list, path, featureHome + path, suffix)) continue;
                for (ResourceLoader instance : customLoaders) {
                    for (Resource r : instance.resources(path.substring(0, path.length() - EXTENSION.length()), EXTENSION)) {
                        try {
                            String feature = new String(IOs.slurp(r.getInputStream()));
                            String featurePath = r.getPath();
                            File featureDump = IOs.dump(tempDir, javaClass.getName() + '/' + featurePath, feature);
                            featureDump.deleteOnExit();
                            featureUrls.put(featurePath, Arrays.asList(featureDump.toURI().toURL()));
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
            }
            Features.findWithCucumberSearcher(loader, path, list);
            if (home != null) {
                Features.findWithCucumberSearcher(loader, home + path, list);
            }
            if (list.isEmpty()) continue;
            featureUrls.put(path + suffix, list);
        }
        for (ResourceLoader instance : customLoaders) {
            try {
                for (Resource r : instance.resources(null, EXTENSION)) {
                    try {
                        String feature = new String(IOs.slurp(r.getInputStream()));
                        String featurePath = r.getPath();
                        File featureDump = IOs.dump(tempDir, javaClass.getName() + '/' + featurePath, feature);
                        featureDump.deleteOnExit();
                        featureUrls.put(featurePath, Arrays.asList(featureDump.toURI().toURL()));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
            catch (NullPointerException npe) {
            }
            catch (IllegalArgumentException npe) {
            }
        }
        LOGGER.fine("Features: " + featureUrls);
        return featureUrls;
    }

    private static boolean urlFromFileSystem(Map<String, Collection<URL>> featureUrls, Collection<URL> list, String path, String filePath, String keySuffix) {
        File file = new File(filePath);
        if (file.exists() && !file.isDirectory()) {
            try {
                list.add(file.toURI().toURL());
                featureUrls.put(path + keySuffix, list);
                return true;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return false;
    }

    private static void findWithCucumberSearcher(ClassLoader loader, String path, Collection<URL> list) {
        Iterator resources;
        MultiLoader multiLoader = new MultiLoader(loader);
        try {
            resources = multiLoader.resources(path, EXTENSION).iterator();
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            if (FileResource.class.isInstance(resource)) {
                FileResource fr = (FileResource)FileResource.class.cast(resource);
                try {
                    Field field = FileResource.class.getDeclaredField("file");
                    field.setAccessible(true);
                    list.add(((File)File.class.cast(field.get(fr))).toURI().toURL());
                }
                catch (Exception e) {}
                continue;
            }
            if (ZipResource.class.isInstance(resource)) {
                list.add(loader.getResource(resource.getPath()));
                continue;
            }
            LOGGER.warning("Resource " + resource + " ignored (unknown type).");
        }
    }

    public static Collection<String> findFeatures(Class<?> javaClass) {
        Cucumber.Options annotation;
        ArrayList<String> featureUrls = new ArrayList<String>();
        String featurePath = Features.featurePath(javaClass);
        featureUrls.add(featurePath);
        cucumber.runtime.arquillian.api.Features additionalFeaturesAnn = javaClass.getAnnotation(cucumber.runtime.arquillian.api.Features.class);
        if (additionalFeaturesAnn != null) {
            Collections.addAll(featureUrls, additionalFeaturesAnn.value());
        }
        if ((annotation = javaClass.getAnnotation(Cucumber.Options.class)) != null && annotation.features() != null) {
            Collections.addAll(featureUrls, annotation.features());
        }
        if ((annotation = javaClass.getAnnotation(CucumberOptions.class)) != null && annotation.features() != null) {
            Collections.addAll(featureUrls, annotation.features());
        }
        return featureUrls;
    }

    private static String createClassNameSubPackage(String name) {
        String result = name;
        if (result.endsWith("Test")) {
            result = result.substring(0, result.length() - "Test".length());
        } else if (result.endsWith("IT")) {
            result = result.substring(0, result.length() - "IT".length());
        }
        if (result.length() == 1) {
            return result;
        }
        return Character.toLowerCase(result.charAt(0)) + Features.replaceUpperCaseWithADashAndLowercase(result.substring(1));
    }

    private static String replaceUpperCaseWithADashAndLowercase(String substring) {
        StringBuilder builder = new StringBuilder();
        for (char c : substring.toCharArray()) {
            if (!Character.isUpperCase(c)) {
                builder.append(c);
                continue;
            }
            builder.append('-').append(Character.toLowerCase(c));
        }
        String s = builder.toString();
        if (s.endsWith("-")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }
}

