/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.glue;

import cucumber.api.CucumberOptions;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.java.JavaBackend;
import gherkin.I18n;
import gherkin.formatter.model.Step;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Glues {
    private Glues() {
    }

    public static Collection<Class<?>> findGlues(Class<?> clazz) {
        String[] cucumberGlues;
        CucumberOptions cucumberOptions;
        ArrayList glues = new ArrayList();
        cucumber.runtime.arquillian.api.Glues additionalGlues = clazz.getAnnotation(cucumber.runtime.arquillian.api.Glues.class);
        if (additionalGlues != null) {
            Collections.addAll(glues, additionalGlues.value());
        }
        if ((cucumberOptions = clazz.getAnnotation(CucumberOptions.class)) != null && (cucumberGlues = cucumberOptions.glue()).length > 0) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            JavaBackend javaBackend = new JavaBackend((ResourceLoader)new MultiLoader(classLoader));
            ScanGlue glue = new ScanGlue();
            javaBackend.loadGlue((Glue)glue, Arrays.asList(cucumberGlues));
            glues.addAll(glue.classes);
        }
        return glues;
    }

    private static class ScanGlue
    implements Glue {
        private final Set<Class<?>> classes = new HashSet();

        private ScanGlue() {
        }

        private static Class<?> clazz(Object hookDefinition) {
            Class<?> stepClass = hookDefinition.getClass();
            if (stepClass.getName().startsWith("cucumber.runtime.java.Java")) {
                try {
                    Field f = stepClass.getDeclaredField("method");
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    Method m = (Method)Method.class.cast(f.get(hookDefinition));
                    return m.getDeclaringClass();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private void addClazz(Class<?> clazz) {
            if (clazz != null) {
                this.classes.add(clazz);
            }
        }

        public void addStepDefinition(StepDefinition stepDefinition) throws DuplicateStepDefinitionException {
            this.addClazz(ScanGlue.clazz(stepDefinition));
        }

        public void addBeforeHook(HookDefinition hookDefinition) {
            this.addClazz(ScanGlue.clazz(hookDefinition));
        }

        public void addAfterHook(HookDefinition hookDefinition) {
            this.addClazz(ScanGlue.clazz(hookDefinition));
        }

        public List<HookDefinition> getBeforeHooks() {
            throw new UnsupportedOperationException();
        }

        public List<HookDefinition> getAfterHooks() {
            throw new UnsupportedOperationException();
        }

        public StepDefinitionMatch stepDefinitionMatch(String featurePath, Step step, I18n i18n) {
            throw new UnsupportedOperationException();
        }

        public void writeStepdefsJson(ResourceLoader resourceLoader, List<String> featurePaths, URL dotCucumber) {
            throw new UnsupportedOperationException();
        }
    }
}

