/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.reporter;

import cucumber.runtime.arquillian.config.CucumberConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import net.masterthought.cucumber.ReportBuilder;
import org.jboss.arquillian.container.spi.event.KillContainer;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class CucumberReporter {
    private static final Logger LOGGER = Logger.getLogger(CucumberReporter.class.getName());
    private static Set<String> jsonReports;
    @Inject
    private Instance<CucumberConfiguration> configuration;

    public void initOnStart(@Observes StartContainer startContainer) {
        jsonReports = new HashSet<String>();
    }

    public void reportOnStop(@Observes StopContainer stopContainer) {
        this.doReport();
    }

    public void reportOnKill(@Observes KillContainer stopContainer) {
        this.doReport();
    }

    public static void addReport(File path) {
        if (jsonReports != null) {
            jsonReports.add(path.getAbsolutePath());
        }
    }

    private void doReport() {
        if (jsonReports == null || jsonReports.isEmpty()) {
            return;
        }
        Iterator<String> files = jsonReports.iterator();
        while (files.hasNext()) {
            if (new File(files.next()).exists()) continue;
            files.remove();
        }
        File outputDir = new File(((CucumberConfiguration)this.configuration.get()).getReportDirectory());
        try {
            new ReportBuilder(new ArrayList<String>(jsonReports), outputDir, "/", "#", CucumberReporter.findProjectName(), false, false, true, false, false, "", true).generateReports();
            LOGGER.info("Cucumber report available at " + new File(outputDir, "feature-overview.html").getAbsolutePath());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        jsonReports.clear();
        CucumberConfiguration.reset();
    }

    private static String findProjectName() {
        for (File file = new File("."); file != null; file = file.getParentFile()) {
            if (Arrays.asList("target", "classes").contains(file.getName())) {
                continue;
            }
            return file.getName();
        }
        return "Cucumber Report";
    }
}

