/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.config;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class CucumberConfiguration {
    private static final CucumberConfiguration CONFIGURATION = new CucumberConfiguration();
    public static final String PERSISTENCE_EVENTS = "persistenceEventsActivated";
    public static final String COLORS = "colors";
    public static final String REPORTABLE = "reportable";
    public static final String REPORTABLE_PATH = "reportablePath";
    public static final String OPTIONS = "options";
    public static final String FEATURE_HOME = "featureHome";
    private boolean report;
    private boolean generateDocs;
    private boolean colorized;
    private boolean initialized;
    private String reportDirectory;
    private String docsDirectory;
    private String options;
    private String featureHome;
    private String tempDir = CucumberConfiguration.guessDefaultTempDir();
    private boolean persistenceEventsActivated = false;
    private Map<String, String> original;

    private static String guessDefaultTempDir() {
        String suffix = "/cukespace/features/";
        if (new File("target").exists()) {
            return new File("target", "/cukespace/features/").getAbsolutePath();
        }
        if (new File("build").exists()) {
            return new File("build", "/cukespace/features/").getAbsolutePath();
        }
        return System.getProperty("java.io.tmpdir") + "/cukespace/features/";
    }

    public Map<String, String> getConfig(String prefix) {
        if (prefix == null) {
            return new HashMap<String, String>(this.original);
        }
        HashMap<String, String> config = new HashMap<String, String>();
        if (this.original != null) {
            for (String key : this.original.keySet()) {
                if (!key.startsWith(prefix)) continue;
                config.put(key, this.original.get(key));
            }
        }
        return config;
    }

    public boolean isReport() {
        return this.report;
    }

    public boolean isGenerateDocs() {
        return this.generateDocs;
    }

    public String getDocsDirectory() {
        return this.docsDirectory;
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isColorized() {
        return this.colorized;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public String getOptions() {
        return this.options;
    }

    public String getFeatureHome() {
        return this.featureHome;
    }

    public boolean arePersistenceEventsActivated() {
        return this.persistenceEventsActivated;
    }

    public static File reportFile(String path, Class<?> clazz) {
        return new File(path, clazz.getName() + ".json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CucumberConfiguration from(Map<String, String> properties) {
        CucumberConfiguration cucumberConfiguration = CONFIGURATION;
        synchronized (cucumberConfiguration) {
            CucumberConfiguration.reset();
            if (properties.containsKey(PERSISTENCE_EVENTS)) {
                CucumberConfiguration.CONFIGURATION.persistenceEventsActivated = "true".equalsIgnoreCase(properties.get(PERSISTENCE_EVENTS));
            }
            if (properties.containsKey("tempDir")) {
                CucumberConfiguration.CONFIGURATION.tempDir = properties.get("tempDir");
            }
            if (properties.containsKey("report")) {
                CucumberConfiguration.CONFIGURATION.report = Boolean.parseBoolean(properties.get("report"));
            }
            if (properties.containsKey("reportDirectory")) {
                CucumberConfiguration.CONFIGURATION.reportDirectory = properties.get("reportDirectory");
            }
            if (properties.containsKey("generateDocs")) {
                CucumberConfiguration.CONFIGURATION.generateDocs = Boolean.parseBoolean(properties.get("generateDocs"));
            }
            if (properties.containsKey("docsDirectory")) {
                CucumberConfiguration.CONFIGURATION.docsDirectory = properties.get("docsDirectory");
            }
            if (properties.containsKey(COLORS)) {
                CucumberConfiguration.CONFIGURATION.colorized = Boolean.parseBoolean(properties.get(COLORS));
            }
            if (properties.containsKey(OPTIONS)) {
                CucumberConfiguration.CONFIGURATION.options = properties.get(OPTIONS);
            }
            if (properties.containsKey(FEATURE_HOME)) {
                CucumberConfiguration.CONFIGURATION.featureHome = properties.get(FEATURE_HOME);
            }
            CucumberConfiguration.CONFIGURATION.original = properties;
            CucumberConfiguration.CONFIGURATION.initialized = true;
        }
        return CONFIGURATION;
    }

    public static void reset() {
        CucumberConfiguration.CONFIGURATION.persistenceEventsActivated = false;
        CucumberConfiguration.CONFIGURATION.initialized = false;
        CucumberConfiguration.CONFIGURATION.reportDirectory = "target/cucumber-report/";
        CucumberConfiguration.CONFIGURATION.docsDirectory = "target/docs/";
        CucumberConfiguration.CONFIGURATION.tempDir = CucumberConfiguration.guessDefaultTempDir();
        CucumberConfiguration.CONFIGURATION.options = null;
        CucumberConfiguration.CONFIGURATION.report = false;
        CucumberConfiguration.CONFIGURATION.generateDocs = false;
        CucumberConfiguration.CONFIGURATION.colorized = !System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win") && !System.getProperty("java.class.path").contains("idea_rt");
    }

    public static CucumberConfiguration instance() {
        return CONFIGURATION;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public Properties getConfigurationAsProperties() {
        Properties configurationProperties = new Properties();
        if (this.isInitialized()) {
            configurationProperties.setProperty(PERSISTENCE_EVENTS, Boolean.toString(this.persistenceEventsActivated));
            configurationProperties.setProperty(COLORS, Boolean.toString(this.colorized));
            configurationProperties.setProperty(REPORTABLE, Boolean.toString(this.report));
            configurationProperties.setProperty(REPORTABLE_PATH, this.reportDirectory);
            if (this.featureHome != null) {
                configurationProperties.setProperty(FEATURE_HOME, this.featureHome);
            }
            if (this.hasOptions()) {
                configurationProperties.setProperty(OPTIONS, this.options);
            }
            if (this.featureHome != null) {
                configurationProperties.setProperty(FEATURE_HOME, this.featureHome);
            }
        }
        return configurationProperties;
    }
}

