/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.arquillian.reporter;

import com.github.cukedoctor.Cukedoctor;
import com.github.cukedoctor.api.CukedoctorConverter;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.parser.FeatureParser;
import com.github.cukedoctor.util.FileUtil;
import cucumber.runtime.arquillian.config.CucumberConfiguration;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.masterthought.cucumber.ReportBuilder;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.jboss.arquillian.container.spi.event.KillContainer;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class CucumberReporter {
    private static final Logger LOGGER = Logger.getLogger(CucumberReporter.class.getName());
    private static Set<String> jsonReports;
    @Inject
    private Instance<CucumberConfiguration> configuration;

    public void initOnStart(@Observes StartContainer startContainer) {
        jsonReports = new HashSet<String>();
    }

    public void reportOnStop(@Observes StopContainer stopContainer) {
        this.doReport();
    }

    public void reportOnKill(@Observes KillContainer stopContainer) {
        this.doReport();
    }

    public static void addReport(File path) {
        if (jsonReports != null) {
            jsonReports.add(path.getAbsolutePath());
        }
    }

    private void doReport() {
        if (jsonReports == null || jsonReports.isEmpty()) {
            return;
        }
        Iterator<String> files = jsonReports.iterator();
        while (files.hasNext()) {
            if (new File(files.next()).exists()) continue;
            files.remove();
        }
        File outputDir = new File(((CucumberConfiguration)this.configuration.get()).getReportDirectory());
        try {
            new ReportBuilder(new ArrayList<String>(jsonReports), outputDir, "/", "#", CucumberReporter.findProjectName(), false, false, false, false, true, false, false, "", true, false).generateReports();
            LOGGER.info("Cucumber report available at " + new File(outputDir, "feature-overview.html").getAbsolutePath());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (((CucumberConfiguration)this.configuration.get()).isGenerateDocs()) {
            ArrayList features = new ArrayList();
            for (String jsonReport : jsonReports) {
                features.addAll(FeatureParser.parse((String)jsonReport));
            }
            if (features.isEmpty()) {
                LOGGER.info("No features found for Cucumber documentation");
            } else {
                Map<String, String> attrs;
                DocumentAttributes da = CucumberReporter.bind(((CucumberConfiguration)this.configuration.get()).getConfig("adoc.doc.attributes."), new DocumentAttributes());
                CukedoctorConverter converter = Cukedoctor.instance(features, (DocumentAttributes)da);
                String doc = converter.renderDocumentation();
                File adocFile = FileUtil.saveFile((String)(((CucumberConfiguration)this.configuration.get()).getDocsDirectory() + "documentation.adoc"), (String)doc);
                OptionsBuilder optBuilder = OptionsBuilder.options().backend("html5").safe(SafeMode.UNSAFE);
                Map<String, String> opts = ((CucumberConfiguration)this.configuration.get()).getConfig("adoc.options.");
                if (!opts.isEmpty()) {
                    CucumberReporter.bind(opts, optBuilder);
                }
                if (!(attrs = ((CucumberConfiguration)this.configuration.get()).getConfig("adoc.attributes.")).isEmpty()) {
                    optBuilder.attributes(CucumberReporter.bind(attrs, AttributesBuilder.attributes()));
                }
                Map options = optBuilder.asMap();
                Asciidoctor asciidoctor = Asciidoctor.Factory.create();
                asciidoctor.convertFile(adocFile, options);
                asciidoctor.shutdown();
                LOGGER.info("Cucumber documentation generated at " + adocFile.getParent());
            }
        }
        jsonReports.clear();
        CucumberConfiguration.reset();
    }

    private static <T> T bind(Map<String, String> config, T instance) {
        Class[] params = new Class[]{String.class, Boolean.TYPE, File.class, Date.class, URI.class, Integer.TYPE};
        for (Map.Entry<String, String> entry : config.entrySet()) {
            int dot = entry.getKey().lastIndexOf(46);
            String key = entry.getKey().substring(dot + 1);
            boolean done = false;
            for (String method : Arrays.asList(key, "set" + Character.toLowerCase(key.charAt(0)) + key.substring(1))) {
                for (Class paramType : params) {
                    try {
                        Object val;
                        Method m = instance.getClass().getMethod(method, paramType);
                        if (paramType == Boolean.TYPE) {
                            val = Boolean.valueOf(entry.getValue());
                        } else if (paramType == Integer.TYPE) {
                            val = Integer.valueOf(entry.getValue());
                        } else if (paramType == URI.class) {
                            val = new URI(entry.getValue());
                        } else if (paramType == Date.class) {
                            String pattern = config.get(key.substring(0, dot) + ".dateFormat");
                            if (pattern == null) {
                                pattern = "yyyy-MM-dd";
                            }
                            val = new SimpleDateFormat(pattern).parse(entry.getValue());
                        } else {
                            val = paramType == File.class ? new File(entry.getValue()) : entry.getValue();
                        }
                        m.invoke(instance, val);
                        done = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!done) continue;
                break;
            }
            if (done) continue;
            LOGGER.warning("Can't find matching property " + key + " in " + instance);
        }
        return instance;
    }

    private static String findProjectName() {
        for (File file = new File("."); file != null; file = file.getParentFile()) {
            if (Arrays.asList("target", "classes").contains(file.getName())) {
                continue;
            }
            return file.getName();
        }
        return "Cucumber Report";
    }
}

