/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;

public final class Actions {
    public static Action1<Integer> setAtomic(final AtomicInteger a) {
        return new Action1<Integer>(){

            public void call(Integer t) {
                a.set(t);
            }
        };
    }

    public static Action1<Long> setAtomic(final AtomicLong a) {
        return new Action1<Long>(){

            public void call(Long t) {
                a.set(t);
            }
        };
    }

    public static Action1<Boolean> setAtomic(final AtomicBoolean a) {
        return new Action1<Boolean>(){

            public void call(Boolean t) {
                a.set(t);
            }
        };
    }

    public static <T> Action1<T> setAtomic(final AtomicReference<T> a) {
        return new Action1<T>(){

            public void call(T t) {
                a.set(t);
            }
        };
    }

    public static Action0 doNothing0() {
        return HolderDoNothing0.INSTANCE;
    }

    public static <T> Action1<T> doNothing1() {
        return HolderDoNothing1.INSTANCE;
    }

    public static <T, R> Action2<T, R> doNothing2() {
        return HolderDoNothing2.INSTANCE;
    }

    public static <T, R, S> Action3<T, R, S> doNothing3() {
        return HolderDoNothing3.INSTANCE;
    }

    public static Action0 unsubscribe(final Subscription subscription) {
        return new Action0(){

            public void call() {
                subscription.unsubscribe();
            }
        };
    }

    public static <T> Action1<T> increment1(final AtomicInteger count) {
        return new Action1<T>(){

            public void call(T t) {
                count.incrementAndGet();
            }
        };
    }

    public static Action0 increment0(final AtomicInteger count) {
        return new Action0(){

            public void call() {
                count.incrementAndGet();
            }
        };
    }

    public static <T> Action1<T> decrement1(final AtomicInteger count) {
        return new Action1<T>(){

            public void call(T t) {
                count.incrementAndGet();
            }
        };
    }

    public static Action0 decrement0(final AtomicInteger count) {
        return new Action0(){

            public void call() {
                count.incrementAndGet();
            }
        };
    }

    public static Action1<Long> addTo(final AtomicLong value) {
        return new Action1<Long>(){

            public void call(Long t) {
                value.addAndGet(t);
            }
        };
    }

    public static <T> Action1<T> println() {
        return new Action1<T>(){

            public void call(T t) {
                System.out.println(t);
            }
        };
    }

    public static <T> Action1<T> setToTrue1(final AtomicBoolean ref) {
        return new Action1<T>(){

            public void call(T t) {
                ref.set(true);
            }
        };
    }

    public static Action0 setToTrue0(final AtomicBoolean ref) {
        return new Action0(){

            public void call() {
                ref.set(true);
            }
        };
    }

    private static class HolderDoNothing3 {
        static final Action3<Object, Object, Object> INSTANCE = new Action3<Object, Object, Object>(){

            public void call(Object t, Object t2, Object t3) {
            }
        };

        private HolderDoNothing3() {
        }
    }

    private static class HolderDoNothing2 {
        static final Action2<Object, Object> INSTANCE = new Action2<Object, Object>(){

            public void call(Object t, Object t2) {
            }
        };

        private HolderDoNothing2() {
        }
    }

    private static class HolderDoNothing1 {
        static final Action1<Object> INSTANCE = new Action1<Object>(){

            public void call(Object t) {
            }
        };

        private HolderDoNothing1() {
        }
    }

    private static class HolderDoNothing0 {
        static final Action0 INSTANCE = new Action0(){

            public void call() {
            }
        };

        private HolderDoNothing0() {
        }
    }
}

