/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.strategy;

import java.util.Comparator;
import org.hibernate.cache.redis.hibernate4.regions.RedisTransactionalDataRegion;
import org.hibernate.cache.redis.hibernate4.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractReadWriteRedisAccessStrategy<T extends RedisTransactionalDataRegion>
extends AbstractRedisAccessStrategy<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractReadWriteRedisAccessStrategy.class);
    private final Comparator versionComparator;

    public AbstractReadWriteRedisAccessStrategy(T region, Settings settings) {
        super(region, settings);
        this.versionComparator = ((RedisTransactionalDataRegion)region).getCacheDataDescription().getVersionComparator();
    }

    public final Object get(Object key, long txTimestamp) {
        return this.region.get(key);
    }

    @Override
    public final boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        this.region.put(key, value);
        return true;
    }

    public final SoftLock lockItem(Object key, Object version) {
        this.region.remove(key);
        return null;
    }

    public final void unlockItem(Object key, SoftLock lock) {
        this.region.remove(key);
    }
}

