/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.redis.hibernate52.regions.RedisEntityRegion;
import org.hibernate.cache.redis.hibernate52.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRedisEntityRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisEntityRegion>
implements EntityRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyRedisEntityRegionAccessStrategy.class);

    public ReadOnlyRedisEntityRegionAccessStrategy(RedisEntityRegion region, SessionFactoryOptions options) {
        super(region, options);
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return null;
    }

    public Object getCacheKeyId(Object cacheKey) {
        return null;
    }

    public EntityRegion getRegion() {
        return (EntityRegion)this.region;
    }

    @Override
    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) {
        return ((RedisEntityRegion)this.region).get(key);
    }

    @Override
    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisEntityRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }

    @Override
    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) {
        return null;
    }

    @Override
    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) {
        this.evict(key);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        return false;
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) {
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }
}

