/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedisCacheUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheUtil.class);
    public static final String FILE_URL_PREFIX = "file:";
    public static final String RESOURCE_URL_PREFIX = "classpath:";
    public static final String EXPIRY_PROPERTY_PREFIX = "redis.expiryInSeconds";
    public static final int DEFAULT_EXPIRY_IN_SECONDS = 120;
    public static final String REDISSON_CONFIG = "redisson-config";
    public static final String DEFAULT_REDISSON_CONFIG_PATH = "classpath:conf/redisson.yaml";
    private static final Properties cacheProperties = new Properties();
    private static int defaultExpiryInSeconds = 120;

    private RedisCacheUtil() {
    }

    public static int getDefaultExpiryInSeconds() {
        return defaultExpiryInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadCacheProperties(Properties props) {
        cacheProperties.putAll((Map<?, ?>)props);
        String cachePropsPath = props.getProperty("hibernate.cache.provider_configuration_file_resource_path", "classpath:conf/hibernate-redis.properties");
        InputStream is = null;
        try {
            log.debug("Loading cache properties... path={}", (Object)cachePropsPath);
            is = RedisCacheUtil.getFileInputStream(cachePropsPath);
            cacheProperties.load(is);
            RedisCacheUtil.loadDefaultExpiry();
        }
        catch (Exception e) {
            log.warn("Fail to load cache properties. path={}", (Object)cachePropsPath, (Object)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return cacheProperties;
    }

    public static InputStream getFileInputStream(String path) throws IOException {
        InputStream is = null;
        if (path.startsWith(FILE_URL_PREFIX)) {
            String filepath = path.substring(FILE_URL_PREFIX.length());
            is = new FileInputStream(new File(filepath));
        } else {
            is = path.startsWith(RESOURCE_URL_PREFIX) ? Thread.currentThread().getContextClassLoader().getResourceAsStream(path.substring(RESOURCE_URL_PREFIX.length())) : Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        }
        return is;
    }

    private static void loadDefaultExpiry() {
        try {
            defaultExpiryInSeconds = Integer.parseInt(RedisCacheUtil.getProperty("redis.expiryInSeconds.default", String.valueOf(120)));
        }
        catch (Exception ignored) {
            defaultExpiryInSeconds = 120;
        }
    }

    public static String getRedissonConfigPath() {
        return cacheProperties.getProperty(REDISSON_CONFIG, DEFAULT_REDISSON_CONFIG_PATH);
    }

    public static int getExpiryInSeconds(String region) {
        try {
            String key = "redis.expiryInSeconds." + region;
            String value = RedisCacheUtil.getProperty(key, String.valueOf(defaultExpiryInSeconds));
            log.trace("load expiry property. region={}, expiryInSeconds={}", (Object)key, (Object)value);
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            log.warn("Fail to get expiryInSeconds in region={}", (Object)region, (Object)e);
            return defaultExpiryInSeconds;
        }
    }

    public static String getProperty(String key, String defaultValue) {
        if (cacheProperties == null || cacheProperties.isEmpty()) {
            return defaultValue;
        }
        try {
            String value = cacheProperties.getProperty(key, defaultValue);
            log.trace("get property. key={}, value={}, defaultValue={}", new Object[]{key, value, defaultValue});
            return value;
        }
        catch (Exception ignored) {
            log.warn("error occurred in reading properties. key={}", (Object)key, (Object)ignored);
            return defaultValue;
        }
    }
}

