/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections;

import com.github.detentor.codex.collections.AbstractSeq;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.IndexedSeq;
import com.github.detentor.codex.collections.SharpCollection;
import com.github.detentor.codex.function.Function1;
import com.github.detentor.codex.function.Functions;
import com.github.detentor.codex.product.Tuple2;
import java.util.Iterator;

public abstract class AbstractIndexedSeq<T, U extends IndexedSeq<T>>
extends AbstractSeq<T, IndexedSeq<T>>
implements IndexedSeq<T> {
    public U subsequence(int startIndex) {
        return (U)this.subsequence(startIndex, this.size());
    }

    public U reverse() {
        Builder retorno = this.builder();
        for (int i = this.size() - 1; i > -1; --i) {
            retorno.add(this.apply(i));
        }
        return (U)((IndexedSeq)retorno.result());
    }

    protected int indexWhere(Function1<? super T, Boolean> pred) {
        for (int i = 0; i < this.size(); ++i) {
            if (!pred.apply(this.apply(i)).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    protected int lastIndexWhere(Function1<? super T, Boolean> pred) {
        for (int i = this.size() - 1; i > -1; --i) {
            if (!pred.apply(this.apply(i)).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isDefinedAt(Integer forValue) {
        return forValue >= 0 && forValue < this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public T head() {
        this.ensureNotEmpty("head foi chamado para uma cole\u00e7\u00e3o vazia");
        return (T)this.apply(0);
    }

    @Override
    public T last() {
        this.ensureNotEmpty("last foi chamado para uma cole\u00e7\u00e3o vazia");
        return (T)this.apply(this.size() - 1);
    }

    @Override
    public U tail() {
        this.ensureNotEmpty("tail foi chamado para uma cole\u00e7\u00e3o vazia");
        return (U)this.drop(1);
    }

    @Override
    public U take(Integer num) {
        int nEle = num < 0 ? 0 : num;
        return (U)this.subsequence(0, nEle);
    }

    @Override
    public U takeRight(Integer num) {
        int nEle = num < 0 ? 0 : num;
        return (U)this.drop(Math.min(this.size() - nEle, this.size()));
    }

    @Override
    public U drop(Integer num) {
        int nEle = num < 0 ? 0 : num;
        return this.subsequence(Math.min(this.size(), nEle));
    }

    @Override
    public U dropRight(Integer num) {
        int nEle = num < 0 ? 0 : num;
        return (U)this.take(this.size() - nEle);
    }

    @Override
    public U dropWhile(Function1<? super T, Boolean> pred) {
        int theIndex = this.indexWhere(Functions.not(pred));
        return (U)this.drop(theIndex == -1 ? this.size() : theIndex);
    }

    @Override
    public U dropRightWhile(Function1<? super T, Boolean> pred) {
        int theIndex = this.lastIndexWhere(Functions.not(pred));
        return (U)this.dropRight(theIndex == -1 ? this.size() : this.size() - (theIndex + 1));
    }

    @Override
    public U takeWhile(Function1<? super T, Boolean> pred) {
        int theIndex = this.indexWhere(Functions.not(pred));
        return (U)this.take(theIndex == -1 ? this.size() : theIndex);
    }

    @Override
    public U takeRightWhile(Function1<? super T, Boolean> pred) {
        int index = this.lastIndexWhere(Functions.not(pred));
        return (U)this.takeRight(index == -1 ? this.size() : this.size() - (index + 1));
    }

    @Override
    public Tuple2<U, U> splitAt(Integer num) {
        return Tuple2.from(this.take(num), this.drop(num));
    }

    @Override
    public IndexedSeq<U> grouped(Integer size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size deve ser maior do que zero");
        }
        Builder retorno = this.builder();
        int curIndex = 0;
        while (curIndex < this.size()) {
            retorno.add(this.subsequence(curIndex, curIndex += size.intValue()));
        }
        return (IndexedSeq)retorno.result();
    }

    @Override
    public U filter(Function1<? super T, Boolean> pred) {
        return (U)((IndexedSeq)super.filter(pred));
    }

    @Override
    public Tuple2<U, U> partition(Function1<? super T, Boolean> pred) {
        return super.partition(pred);
    }

    @Override
    public U intersect(SharpCollection<T> withCollection) {
        return (U)((IndexedSeq)super.intersect(withCollection));
    }

    @Override
    public U distinct() {
        return (U)((IndexedSeq)super.distinct());
    }

    @Override
    public Iterator<T> iterator() {
        final int[] curIndex = new int[1];
        final int count = this.size();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return curIndex[0] < count;
            }

            @Override
            public T next() {
                int n = curIndex[0];
                curIndex[0] = n + 1;
                return AbstractIndexedSeq.this.apply(n);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Opera\u00e7\u00e3o de remo\u00e7\u00e3o n\u00e3o suportada");
            }
        };
    }
}

