/*
 * Decompiled with CFR 0.152.
 */
package com.github.detentor.codex.collections;

import com.github.detentor.codex.collections.AbstractSeq;
import com.github.detentor.codex.collections.Builder;
import com.github.detentor.codex.collections.LinearSeq;
import com.github.detentor.codex.function.Function1;
import java.util.Iterator;

public abstract class AbstractLinearSeq<T, U extends LinearSeq<T>>
extends AbstractSeq<T, LinearSeq<T>>
implements LinearSeq<T> {
    private static final String UNCHECKED = "unchecked";

    @Override
    public boolean isDefinedAt(Integer forValue) {
        return forValue >= 0 && forValue < this.size();
    }

    @Override
    public T apply(Integer param) {
        return (T)(param.equals(0) ? this.head() : ((LinearSeq)this.tail()).apply(param - 1));
    }

    @Override
    public T last() {
        this.ensureNotEmpty("last foi chamado para uma cole\u00e7\u00e3o vazia");
        return this.apply(this.size() - 1);
    }

    @Override
    public U take(Integer num) {
        Builder colecaoRetorno = this.builder();
        Iterator<T> ite = this.iterator();
        int count = 0;
        while (count++ < num && ite.hasNext()) {
            colecaoRetorno.add(ite.next());
        }
        return (U)((LinearSeq)colecaoRetorno.result());
    }

    @Override
    public U takeRight(Integer num) {
        int eleToSkip = Math.max(this.size() - num, 0);
        Builder colecaoRetorno = this.builder();
        Iterator<T> ite = this.iterator();
        for (int curCount = 0; ite.hasNext() && curCount < eleToSkip; ++curCount) {
            ite.next();
        }
        while (ite.hasNext()) {
            colecaoRetorno.add(ite.next());
        }
        return (U)((LinearSeq)colecaoRetorno.result());
    }

    @Override
    public U drop(Integer num) {
        Builder colecaoRetorno = this.builder();
        Iterator<T> ite = this.iterator();
        int count = 0;
        while (count++ < num && ite.hasNext()) {
            ite.next();
        }
        while (ite.hasNext()) {
            colecaoRetorno.add(ite.next());
        }
        return (U)((LinearSeq)colecaoRetorno.result());
    }

    @Override
    public U dropRight(Integer num) {
        int toAdd = Math.max(0, this.size() - num);
        Builder colecaoRetorno = this.builder();
        Iterator<T> ite = this.iterator();
        int count = 0;
        while (ite.hasNext() && count++ < toAdd) {
            colecaoRetorno.add(ite.next());
        }
        return (U)((LinearSeq)colecaoRetorno.result());
    }

    @Override
    public U dropWhile(Function1<? super T, Boolean> pred) {
        Builder colecaoRetorno = this.builder();
        Iterator<T> ite = this.iterator();
        while (ite.hasNext()) {
            T curEle = ite.next();
            if (pred.apply(curEle).booleanValue()) continue;
            colecaoRetorno.add(curEle);
            break;
        }
        while (ite.hasNext()) {
            colecaoRetorno.add(ite.next());
        }
        return (U)((LinearSeq)colecaoRetorno.result());
    }

    @Override
    public U dropRightWhile(Function1<? super T, Boolean> pred) {
        Builder colecaoRetorno = this.builder();
        Iterator<T> ite = this.iterator();
        Builder tempCollection = this.builder();
        while (ite.hasNext()) {
            T curEle = ite.next();
            if (pred.apply(curEle).booleanValue()) {
                tempCollection.add(curEle);
                continue;
            }
            for (Object ele : tempCollection.result()) {
                colecaoRetorno.add(ele);
            }
            colecaoRetorno.add(curEle);
            tempCollection = this.builder();
        }
        return (U)((LinearSeq)colecaoRetorno.result());
    }

    @Override
    public U takeWhile(Function1<? super T, Boolean> pred) {
        Builder colecaoRetorno = this.builder();
        for (T curEle : this) {
            if (!pred.apply(curEle).booleanValue()) break;
            colecaoRetorno.add(curEle);
        }
        return (U)((LinearSeq)colecaoRetorno.result());
    }

    @Override
    public U takeRightWhile(Function1<? super T, Boolean> pred) {
        Builder colecaoRetorno = this.builder();
        for (T curEle : this) {
            if (pred.apply(curEle).booleanValue()) {
                colecaoRetorno.add(curEle);
                continue;
            }
            colecaoRetorno = this.builder();
        }
        return (U)((LinearSeq)colecaoRetorno.result());
    }

    @Override
    public int size() {
        int theSize = 0;
        LinearSeq<Object> curEle = this;
        while (curEle.notEmpty()) {
            curEle = curEle.tail();
            ++theSize;
        }
        return theSize;
    }

    @Override
    public Iterator<T> iterator() {
        final LinearSeq[] curEle = new LinearSeq[]{this};
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return !curEle[0].isEmpty();
            }

            @Override
            public T next() {
                Object toReturn = curEle[0].head();
                curEle[0] = curEle[0].tail();
                return toReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada");
            }
        };
    }
}

